/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import java.util.Objects;
import java.util.Set;

public class HivePrincipal {
    private final PrincipalType type;
    private final String name;

    public static Set<HivePrincipal> from(Set<PrestoPrincipal> prestoPrincipals) {
        return (Set)prestoPrincipals.stream().map(HivePrincipal::from).collect(ImmutableSet.toImmutableSet());
    }

    public static HivePrincipal from(PrestoPrincipal prestoPrincipal) {
        return new HivePrincipal(prestoPrincipal.getType(), prestoPrincipal.getName());
    }

    @JsonCreator
    public HivePrincipal(@JsonProperty(value="type") PrincipalType type, @JsonProperty(value="name") String name) {
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(name, "name is null");
        if (type == PrincipalType.USER) {
            this.name = name;
        } else if (type == PrincipalType.ROLE) {
            this.name = name;
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
    }

    @JsonProperty
    public PrincipalType getType() {
        return this.type;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrincipal prestoPrincipal = (HivePrincipal)o;
        return this.type == prestoPrincipal.type && Objects.equals(this.name, prestoPrincipal.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    public String toString() {
        return this.type + " " + this.name;
    }

    public PrestoPrincipal toPrestoPrincipal() {
        return new PrestoPrincipal(this.type, this.name);
    }
}

