/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.metastore.api.DataOperationType;

public class HiveTransaction {
    private final HiveIdentity identity;
    private final long transactionId;
    private final ScheduledFuture<?> heartbeatTask;
    private final Map<String, AtomicBoolean> locksMap = new HashMap<String, AtomicBoolean>();
    private final Map<HivePartition, AtomicBoolean> partitionLocks = new HashMap<HivePartition, AtomicBoolean>();
    private final Map<SchemaTableName, ValidTxnWriteIdList> validHiveTransactionsForTable = new HashMap<SchemaTableName, ValidTxnWriteIdList>();

    public HiveTransaction(HiveIdentity identity, long transactionId, ScheduledFuture<?> heartbeatTask) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.transactionId = transactionId;
        this.heartbeatTask = Objects.requireNonNull(heartbeatTask, "heartbeatTask is null");
    }

    public HiveIdentity getIdentity() {
        return this.identity;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public ScheduledFuture<?> getHeartbeatTask() {
        return this.heartbeatTask;
    }

    public ValidTxnWriteIdList getValidWriteIds(HiveMetastore metastore, HiveTableHandle tableHandle, String queryId, boolean isVacuum) {
        if (this.isSharedLockNeeded(tableHandle)) {
            metastore.acquireSharedReadLock(this.identity, queryId, this.transactionId, (List<SchemaTableName>)(!tableHandle.getPartitions().isPresent() ? ImmutableList.of((Object)tableHandle.getSchemaTableName()) : ImmutableList.of()), tableHandle.getPartitions().orElse((List<HivePartition>)ImmutableList.of()));
        }
        return this.validHiveTransactionsForTable.computeIfAbsent(tableHandle.getSchemaTableName(), schemaTableName -> new ValidTxnWriteIdList(metastore.getValidWriteIds(this.identity, (List<SchemaTableName>)ImmutableList.of((Object)schemaTableName), this.transactionId, isVacuum)));
    }

    private synchronized boolean isSharedLockNeeded(HiveTableHandle tableHandle) {
        if (tableHandle.getPartitions().isPresent() && tableHandle.getPartitions().get().size() > 0) {
            List<HivePartition> hivePartitions = tableHandle.getPartitions().get();
            for (HivePartition partition : hivePartitions) {
                AtomicBoolean partitionLockFlag = this.partitionLocks.get(partition);
                if (partitionLockFlag != null && partitionLockFlag.get()) continue;
                return true;
            }
        } else {
            AtomicBoolean lockFlag = this.locksMap.get(tableHandle.getSchemaPrefixedTableName());
            if (lockFlag == null || !lockFlag.get()) {
                return true;
            }
        }
        return false;
    }

    private synchronized void setLockFlagForTable(HiveTableHandle tableHandle) {
        if (tableHandle.getPartitions().isPresent() && tableHandle.getPartitions().get().size() > 0) {
            List<HivePartition> hivePartitions = tableHandle.getPartitions().get();
            hivePartitions.stream().forEach(hivePartition -> {
                AtomicBoolean flag = this.partitionLocks.get(hivePartition);
                if (flag == null) {
                    flag = new AtomicBoolean(true);
                    this.partitionLocks.put((HivePartition)hivePartition, flag);
                } else {
                    flag.set(true);
                }
            });
        } else {
            AtomicBoolean flag = this.locksMap.get(tableHandle.getSchemaPrefixedTableName());
            if (flag == null) {
                flag = new AtomicBoolean(true);
                this.locksMap.put(tableHandle.getSchemaPrefixedTableName(), flag);
            } else {
                flag.set(true);
            }
        }
    }

    public Long getTableWriteId(HiveMetastore metastore, HiveTableHandle tableHandle, HiveACIDWriteType writeType, String queryId) {
        DataOperationType operationType = DataOperationType.INSERT;
        boolean semiSharedLock = false;
        switch (writeType) {
            case VACUUM: 
            case INSERT: {
                operationType = DataOperationType.INSERT;
                break;
            }
            case INSERT_OVERWRITE: 
            case UPDATE: {
                operationType = DataOperationType.UPDATE;
                semiSharedLock = true;
                break;
            }
            case DELETE: {
                operationType = DataOperationType.DELETE;
                semiSharedLock = true;
            }
        }
        metastore.acquireLock(this.identity, queryId, this.transactionId, (List<SchemaTableName>)(!tableHandle.getPartitions().isPresent() ? ImmutableList.of((Object)tableHandle.getSchemaTableName()) : ImmutableList.of()), tableHandle.getPartitions().orElse((List<HivePartition>)ImmutableList.of()), operationType);
        if (semiSharedLock) {
            this.setLockFlagForTable(tableHandle);
        }
        return metastore.getTableWriteId(tableHandle.getSchemaName(), tableHandle.getTableName(), this.transactionId);
    }
}

