/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.spi.security.PrincipalType;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class PrincipalPrivileges {
    private final SetMultimap<String, HivePrivilegeInfo> userPrivileges;
    private final SetMultimap<String, HivePrivilegeInfo> rolePrivileges;

    public PrincipalPrivileges(Multimap<String, HivePrivilegeInfo> userPrivileges, Multimap<String, HivePrivilegeInfo> rolePrivileges) {
        this.userPrivileges = ImmutableSetMultimap.copyOf(Objects.requireNonNull(userPrivileges, "userPrivileges is null"));
        this.rolePrivileges = ImmutableSetMultimap.copyOf(Objects.requireNonNull(rolePrivileges, "rolePrivileges is null"));
    }

    public static PrincipalPrivileges fromHivePrivilegeInfos(Set<HivePrivilegeInfo> hivePrivileges) {
        Multimap localUserPrivileges = (Multimap)hivePrivileges.stream().filter(privilege -> privilege.getGrantee().getType() == PrincipalType.USER).collect(ImmutableListMultimap.toImmutableListMultimap(privilege -> privilege.getGrantee().getName(), Function.identity()));
        Multimap localRolePrivileges = (Multimap)hivePrivileges.stream().filter(privilege -> privilege.getGrantee().getType() == PrincipalType.ROLE).collect(ImmutableListMultimap.toImmutableListMultimap(privilege -> privilege.getGrantee().getName(), Function.identity()));
        return new PrincipalPrivileges((Multimap<String, HivePrivilegeInfo>)localUserPrivileges, (Multimap<String, HivePrivilegeInfo>)localRolePrivileges);
    }

    public SetMultimap<String, HivePrivilegeInfo> getUserPrivileges() {
        return this.userPrivileges;
    }

    public SetMultimap<String, HivePrivilegeInfo> getRolePrivileges() {
        return this.rolePrivileges;
    }
}

