/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveVacuumTableHandle;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.VacuumCleaner;
import io.prestosql.plugin.hive.VacuumEligibleTableCollector;
import io.prestosql.plugin.hive.VacuumTableInfoForCleaner;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadata;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.HiveTransaction;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.RetryDriver;
import io.prestosql.plugin.hive.util.Statistics;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableAlreadyExistsException;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class SemiTransactionalHiveMetastore {
    private static final Logger log = Logger.get(SemiTransactionalHiveMetastore.class);
    public static final String SCHEMA_SEPARATOR = ".";
    private final HiveMetastore delegate;
    private final HiveMetastoreClosure closure;
    private final HdfsEnvironment hdfsEnvironment;
    private final Executor renameExecutor;
    private final ScheduledExecutorService vacuumExecutorService;
    private final Duration configuredVacuumCleanupInterval;
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final ScheduledExecutorService heartbeatExecutor;
    private final Optional<Duration> configuredTransactionHeartbeatInterval;
    private final ListeningExecutorService hiveMetastoreClientService;
    private boolean throwOnCleanupFailure;
    private int partitionCommitBatchSize;
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Action<TableAndMore>> tableActions = new HashMap<SchemaTableName, Action<TableAndMore>>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>> partitionActions = new ConcurrentHashMap<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>>();
    @GuardedBy(value="this")
    private final List<DeclaredIntentionToWrite> declaredIntentionsToWrite = new ArrayList<DeclaredIntentionToWrite>();
    @GuardedBy(value="this")
    private ExclusiveOperation bufferedExclusiveOperation;
    @GuardedBy(value="this")
    private State state = State.EMPTY;
    @GuardedBy(value="this")
    private Optional<String> currentQueryId = Optional.empty();
    @GuardedBy(value="this")
    private Optional<Supplier<HiveTransaction>> hiveTransactionSupplier = Optional.empty();
    @GuardedBy(value="this")
    private Optional<HiveTransaction> currentHiveTransaction = Optional.empty();
    private List<VacuumCleaner> vacuumCleanerTasks = new ArrayList<VacuumCleaner>();
    private boolean isVacuumIncluded;
    private HiveTableHandle tableHandle;
    private static final RetryDriver DELETE_RETRY = RetryDriver.retry().maxAttempts(3).exponentialBackoff(new Duration(1.0, TimeUnit.SECONDS), new Duration(1.0, TimeUnit.SECONDS), new Duration(10.0, TimeUnit.SECONDS), 2.0);

    public SemiTransactionalHiveMetastore(HdfsEnvironment hdfsEnvironment, HiveMetastore delegate, Executor renameExecutor, ScheduledExecutorService vacuumExecutorService, Duration vacuumCleanupInterval, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, Optional<Duration> hiveTransactionHeartbeatInterval, ScheduledExecutorService heartbeatService, ScheduledExecutorService hiveMetastoreClientService, int hmsWriteBatchSize) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.renameExecutor = Objects.requireNonNull(renameExecutor, "renameExecutor is null");
        this.vacuumExecutorService = Objects.requireNonNull(vacuumExecutorService, "vacuumExecutorService is null");
        this.configuredVacuumCleanupInterval = Objects.requireNonNull(vacuumCleanupInterval, "vacuumCleanupInterval is null");
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.heartbeatExecutor = heartbeatService;
        this.configuredTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
        this.hiveMetastoreClientService = MoreExecutors.listeningDecorator((ScheduledExecutorService)hiveMetastoreClientService);
        this.closure = new HiveMetastoreClosure(delegate);
        this.partitionCommitBatchSize = hmsWriteBatchSize;
    }

    public synchronized List<String> getAllDatabases() {
        this.checkReadable();
        return this.delegate.getAllDatabases();
    }

    public synchronized Optional<Database> getDatabase(String databaseName) {
        this.checkReadable();
        return this.delegate.getDatabase(databaseName);
    }

    public synchronized Optional<List<String>> getAllTables(String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllTables(databaseName);
    }

    public synchronized Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.delegate.getTable(identity, databaseName, tableName);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return Optional.of(tableAction.getData().getTable());
            }
            case DROP: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    public synchronized PartitionStatistics getTableStatistics(HiveIdentity identity, String databaseName, String tableName) {
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return this.closure.getTableStatistics(identity, databaseName, tableName);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return tableAction.getData().getStatistics();
            }
            case DROP: {
                return PartitionStatistics.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames, Optional<Table> table) {
        this.checkReadable();
        if (!table.isPresent()) {
            return ImmutableMap.of();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableSet.Builder partitionNamesToQuery = ImmutableSet.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName2 : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName2);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQuery.add((Object)partitionName2);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName2, (Object)PartitionStatistics.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName2, (Object)((PartitionAndMore)partitionAction.getData()).getStatistics());
        }
        Map<String, PartitionStatistics> delegateResult = this.closure.getPartitionStatistics(identity, databaseName, tableName, (Set<String>)partitionNamesToQuery.build());
        if (!delegateResult.isEmpty()) {
            resultBuilder.putAll(delegateResult);
        } else {
            partitionNamesToQuery.build().forEach(partitionName -> resultBuilder.put(partitionName, (Object)PartitionStatistics.empty()));
        }
        return resultBuilder.build();
    }

    @GuardedBy(value="this")
    private TableSource getTableSource(String databaseName, String tableName) {
        this.checkHoldsLock();
        this.checkReadable();
        Action<TableAndMore> tableAction = this.tableActions.get(new SchemaTableName(databaseName, tableName));
        if (tableAction == null) {
            return TableSource.PRE_EXISTING_TABLE;
        }
        switch (tableAction.getType()) {
            case ADD: {
                return TableSource.CREATED_IN_THIS_TRANSACTION;
            }
            case DROP: {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            case ALTER: 
            case INSERT_EXISTING: {
                return TableSource.PRE_EXISTING_TABLE;
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized HivePageSinkMetadata generatePageSinkMetadata(HiveIdentity identity, SchemaTableName schemaTableName) {
        ImmutableMap modifiedPartitionMap;
        this.checkReadable();
        Optional<Table> table = this.getTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName());
        if (!table.isPresent()) {
            return new HivePageSinkMetadata(schemaTableName, Optional.empty(), (Map<List<String>, Optional<Partition>>)ImmutableMap.of());
        }
        Map<List<String>, Action<PartitionAndMore>> partitionActionMap = this.partitionActions.get(schemaTableName);
        if (partitionActionMap == null) {
            modifiedPartitionMap = ImmutableMap.of();
        } else {
            ImmutableMap.Builder modifiedPartitionMapBuilder = ImmutableMap.builder();
            for (Map.Entry<List<String>, Action<PartitionAndMore>> entry : partitionActionMap.entrySet()) {
                modifiedPartitionMapBuilder.put(entry.getKey(), SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(entry.getValue()));
            }
            modifiedPartitionMap = modifiedPartitionMapBuilder.build();
        }
        return new HivePageSinkMetadata(schemaTableName, table, (Map<List<String>, Optional<Partition>>)modifiedPartitionMap);
    }

    public synchronized Optional<List<String>> getAllViews(String databaseName) {
        this.checkReadable();
        if (!this.tableActions.isEmpty()) {
            throw new UnsupportedOperationException("Listing all tables after adding/dropping/altering tables/views in a transaction is not supported");
        }
        return this.delegate.getAllViews(databaseName);
    }

    public synchronized void createDatabase(HiveIdentity identity, Database database) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.createDatabase(identity, database));
    }

    public synchronized void dropDatabase(HiveIdentity identity, String schemaName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropDatabase(identity, schemaName));
    }

    public synchronized void renameDatabase(HiveIdentity identity, String source, String target) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameDatabase(identity, source, target));
    }

    public synchronized void setTableStatistics(HiveIdentity identity, Table table, PartitionStatistics tableStatistics) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.updateTableStatistics(identity, table.getDatabaseName(), table.getTableName(), statistics -> this.updatePartitionStatistics((PartitionStatistics)statistics, tableStatistics)));
    }

    public synchronized void setPartitionStatistics(HiveIdentity identity, Table table, Map<List<String>, PartitionStatistics> partitionStatisticsMap) {
        this.setExclusive((delegate, hdfsEnvironment) -> partitionStatisticsMap.forEach((partitionValues, newPartitionStats) -> delegate.updatePartitionStatistics(identity, table.getDatabaseName(), table.getTableName(), this.getPartitionName(table, (List<String>)partitionValues), oldPartitionStats -> this.updatePartitionStatistics((PartitionStatistics)oldPartitionStats, (PartitionStatistics)newPartitionStats))));
    }

    private PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
        HiveBasicStatistics oldBasicStatistics = oldPartitionStats.getBasicStatistics();
        HiveBasicStatistics newBasicStatistics = newPartitionStats.getBasicStatistics();
        HiveBasicStatistics updatedBasicStatistics = new HiveBasicStatistics(SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getFileCount(), oldBasicStatistics.getFileCount()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getRowCount(), oldBasicStatistics.getRowCount()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getInMemoryDataSizeInBytes(), oldBasicStatistics.getInMemoryDataSizeInBytes()), SemiTransactionalHiveMetastore.firstPresent(newBasicStatistics.getOnDiskDataSizeInBytes(), oldBasicStatistics.getOnDiskDataSizeInBytes()));
        return new PartitionStatistics(updatedBasicStatistics, newPartitionStats.getColumnStatistics());
    }

    private static OptionalLong firstPresent(OptionalLong first, OptionalLong second) {
        return first.isPresent() ? first : second;
    }

    @VisibleForTesting
    public synchronized void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges, Optional<Path> currentPath, boolean ignoreExisting, PartitionStatistics statistics) {
        this.createTable(session, table, principalPrivileges, currentPath, ignoreExisting, statistics, Optional.empty(), false);
    }

    public synchronized void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges, Optional<Path> currentPath, boolean ignoreExisting, PartitionStatistics statistics, Optional<List<String>> files, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        this.checkNoPartitionAction(table.getDatabaseName(), table.getTableName());
        Action<TableAndMore> oldTableAction = this.tableActions.get(table.getSchemaTableName());
        HiveIdentity identity = new HiveIdentity(session);
        TableAndMore tableAndMore = new TableAndMore(table, identity, Optional.of(principalPrivileges), currentPath, files, ignoreExisting, statistics, statistics, HiveSessionProperties.isCollectColumnStatisticsOnWrite(session), cleanExtraOutputFilesOnCommit);
        if (oldTableAction == null) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
            this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ADD, tableAndMore, hdfsContext, identity, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                if (!oldTableAction.getHdfsContext().getIdentity().getUser().equals(session.getUser())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same table with different user in the same transaction is not supported");
                }
                HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
                this.tableActions.put(table.getSchemaTableName(), new Action<TableAndMore>(ActionType.ALTER, tableAndMore, hdfsContext, identity, session.getQueryId()));
                break;
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new TableAlreadyExistsException(table.getSchemaTableName());
            }
            default: {
                throw new IllegalStateException("Unknown action type");
            }
        }
    }

    public synchronized void dropTable(ConnectorSession session, String databaseName, String tableName) {
        this.setShared();
        this.checkNoPartitionAction(databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null || oldTableAction.getType() == ActionType.ALTER) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            HiveIdentity identity = new HiveIdentity(session);
            this.tableActions.put(schemaTableName, new Action<Object>(ActionType.DROP, null, hdfsContext, identity, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("dropping a table added/modified in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void replaceView(HiveIdentity identity, String databaseName, String tableName, Table table, PrincipalPrivileges principalPrivileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.replaceTable(identity, databaseName, tableName, table, principalPrivileges));
    }

    public synchronized void renameTable(HiveIdentity identity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameTable(identity, databaseName, tableName, newDatabaseName, newTableName));
    }

    public synchronized void commentTable(HiveIdentity identity, String databaseName, String tableName, Optional<String> comment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.commentTable(identity, databaseName, tableName, comment));
    }

    public synchronized void addColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.addColumn(identity, databaseName, tableName, columnName, columnType, columnComment));
    }

    public synchronized void renameColumn(HiveIdentity identity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.renameColumn(identity, databaseName, tableName, oldColumnName, newColumnName));
    }

    public synchronized void dropColumn(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropColumn(identity, databaseName, tableName, columnName));
    }

    public synchronized void finishInsertIntoExistingTable(ConnectorSession session, String databaseName, String tableName, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate, HiveACIDWriteType acidWriteType, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        HiveIdentity identity = new HiveIdentity(session);
        this.isVacuumIncluded |= HiveACIDWriteType.isVacuum(acidWriteType);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> oldTableAction = this.tableActions.get(schemaTableName);
        if (oldTableAction == null) {
            Table table = this.delegate.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            PartitionStatistics mergedStatistics = statisticsUpdate;
            boolean updateStats = this.canUpdateStats(session, acidWriteType);
            if (updateStats) {
                PartitionStatistics currentStatistics = this.getTableStatistics(identity, databaseName, tableName);
                mergedStatistics = Statistics.merge(currentStatistics, statisticsUpdate);
            }
            this.tableActions.put(schemaTableName, new Action<TableAndMore>(ActionType.INSERT_EXISTING, new TableAndMore(table, identity, Optional.empty(), Optional.of(currentLocation), Optional.of(fileNames), false, mergedStatistics, statisticsUpdate, updateStats, cleanExtraOutputFilesOnCommit), hdfsContext, identity, session.getQueryId()));
            return;
        }
        switch (oldTableAction.getType()) {
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("Inserting into an unpartitioned table that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void truncateUnpartitionedTable(ConnectorSession session, String databaseName, String tableName) {
        this.checkReadable();
        Optional<Table> table = this.getTable(new HiveIdentity(session), databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(schemaTableName);
        }
        if (!table.get().getTableType().equals(TableType.MANAGED_TABLE.toString())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot delete from non-managed Hive table");
        }
        if (!table.get().getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException("Table is partitioned");
        }
        Path path = new Path(table.get().getStorage().getLocation());
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
        boolean isAutoPurge = "true".equalsIgnoreCase(table.get().getParameters().get("auto.purge"));
        this.setExclusive((delegate, hdfsEnvironment) -> {
            RecursiveDeleteResult recursiveDeleteResult = isAutoPurge ? SemiTransactionalHiveMetastore.recursiveDeleteFiles(hdfsEnvironment, context, path, (Set<String>)ImmutableSet.of((Object)""), false) : SemiTransactionalHiveMetastore.moveToTrash(hdfsEnvironment, context, path);
            if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting from unpartitioned table %s. These items can not be deleted: %s", schemaTableName, recursiveDeleteResult.getNotDeletedEligibleItems()));
            }
        });
    }

    public synchronized Optional<List<String>> getPartitionNames(HiveIdentity identity, String databaseName, String tableName) {
        Optional<Table> table = this.getTable(identity, databaseName, tableName);
        return this.doGetPartitionNames(identity, databaseName, tableName, Optional.empty(), table);
    }

    public synchronized Optional<List<String>> getPartitionNamesByParts(HiveIdentity identity, String databaseName, String tableName, List<String> parts, Table table) {
        return this.doGetPartitionNames(identity, databaseName, tableName, Optional.of(parts), Optional.of(table));
    }

    @GuardedBy(value="this")
    private Optional<List<String>> doGetPartitionNames(HiveIdentity identity, String databaseName, String tableName, Optional<List<String>> parts, Optional<Table> table) {
        Object partitionNames;
        this.checkHoldsLock();
        this.checkReadable();
        if (!table.isPresent()) {
            return Optional.empty();
        }
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        switch (tableSource) {
            case CREATED_IN_THIS_TRANSACTION: {
                partitionNames = ImmutableList.of();
                break;
            }
            case PRE_EXISTING_TABLE: {
                Optional<List<String>> partitionNameResult = parts.isPresent() ? this.delegate.getPartitionNamesByParts(identity, databaseName, tableName, parts.get()) : this.delegate.getPartitionNames(identity, databaseName, tableName);
                if (!partitionNameResult.isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table %s.%s was dropped by another transaction", databaseName, tableName));
                }
                partitionNames = partitionNameResult.get();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown table source");
            }
        }
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(table.get().getSchemaTableName(), k -> new HashMap());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        block9: for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                resultBuilder.add((Object)partitionName);
                continue;
            }
            switch (partitionAction.getType()) {
                case ADD: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Another transaction created partition %s in table %s.%s", partitionValues, databaseName, tableName));
                }
                case DROP: {
                    continue block9;
                }
                case ALTER: 
                case INSERT_EXISTING: {
                    resultBuilder.add((Object)partitionName);
                    continue block9;
                }
            }
            throw new IllegalStateException("Unknown action type");
        }
        if (!partitionActionsOfTable.isEmpty()) {
            List columnNames = table.get().getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
            for (Action partitionAction : partitionActionsOfTable.values()) {
                if (partitionAction.getType() != ActionType.ADD) continue;
                List<String> values = ((PartitionAndMore)partitionAction.getData()).getPartition().getValues();
                if (parts.isPresent() && !SemiTransactionalHiveMetastore.partitionValuesMatch(values, parts.get())) continue;
                resultBuilder.add((Object)FileUtils.makePartName(columnNames, values));
            }
        }
        return Optional.of(resultBuilder.build());
    }

    private static boolean partitionValuesMatch(List<String> values, List<String> pattern) {
        Preconditions.checkArgument((values.size() == pattern.size() ? 1 : 0) != 0);
        for (int i = 0; i < values.size(); ++i) {
            if (pattern.get(i).isEmpty() || !values.get(i).equals(pattern.get(i))) continue;
            return false;
        }
        return true;
    }

    public synchronized Optional<Partition> getPartition(HiveIdentity identity, String databaseName, String tableName, List<String> partitionValues) {
        this.checkReadable();
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (partitionAction != null) {
            return SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(partitionAction);
        }
        switch (tableSource) {
            case PRE_EXISTING_TABLE: {
                return this.delegate.getPartition(identity, databaseName, tableName, partitionValues);
            }
            case CREATED_IN_THIS_TRANSACTION: {
                return Optional.empty();
            }
        }
        throw new UnsupportedOperationException("unknown table source");
    }

    public synchronized Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, String databaseName, String tableName, List<String> partitionNames) {
        this.checkReadable();
        TableSource tableSource = this.getTableSource(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new HashMap());
        ImmutableList.Builder partitionNamesToQuery = ImmutableList.builder();
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        block4: for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            Action partitionAction = (Action)partitionActionsOfTable.get(partitionValues);
            if (partitionAction == null) {
                switch (tableSource) {
                    case PRE_EXISTING_TABLE: {
                        partitionNamesToQuery.add((Object)partitionName);
                        continue block4;
                    }
                    case CREATED_IN_THIS_TRANSACTION: {
                        resultBuilder.put((Object)partitionName, Optional.empty());
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("unknown table source");
            }
            resultBuilder.put((Object)partitionName, SemiTransactionalHiveMetastore.getPartitionFromPartitionAction(partitionAction));
        }
        Map<String, Optional<Partition>> delegateResult = this.delegate.getPartitionsByNames(identity, databaseName, tableName, (List<String>)partitionNamesToQuery.build());
        resultBuilder.putAll(delegateResult);
        return resultBuilder.build();
    }

    private static Optional<Partition> getPartitionFromPartitionAction(Action<PartitionAndMore> partitionAction) {
        switch (partitionAction.getType()) {
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                return Optional.of(partitionAction.getData().getAugmentedPartitionForInTransactionRead());
            }
            case DROP: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void addPartition(ConnectorSession session, String databaseName, String tableName, Partition partition, Path currentLocation, PartitionStatistics statistics, HiveACIDWriteType acidWriteType, Optional<List<String>> files, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition).isPresent());
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new ConcurrentHashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partition.getValues());
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
        HiveIdentity identity = new HiveIdentity(session);
        boolean canUpdateStats = this.canUpdateStats(session, acidWriteType);
        this.partitionCommitBatchSize = HiveSessionProperties.getMetastoreWriteBatchSize(session);
        if (oldPartitionAction == null) {
            partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ADD, new PartitionAndMore(identity, partition, currentLocation, files, statistics, statistics, canUpdateStats, cleanExtraOutputFilesOnCommit), hdfsContext, identity, session.getQueryId()));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: {
                if (!oldPartitionAction.getHdfsContext().getIdentity().getUser().equals(session.getUser())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "Operation on the same partition with different user in the same transaction is not supported");
                }
                partitionActionsOfTable.put(partition.getValues(), new Action<PartitionAndMore>(ActionType.ALTER, new PartitionAndMore(identity, partition, currentLocation, files, statistics, statistics, canUpdateStats, cleanExtraOutputFilesOnCommit), hdfsContext, identity, session.getQueryId()));
                break;
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Partition already exists for table '%s.%s': %s", databaseName, tableName, partition.getValues()));
            }
            default: {
                throw new IllegalStateException("Unknown action type");
            }
        }
    }

    public synchronized void dropPartition(ConnectorSession session, String databaseName, String tableName, List<String> partitionValues) {
        this.setShared();
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(new SchemaTableName(databaseName, tableName), k -> new ConcurrentHashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            HiveIdentity identity = new HiveIdentity(session);
            partitionActionsOfTable.put(partitionValues, new Action<Object>(ActionType.DROP, null, hdfsContext, identity, session.getQueryId()));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: {
                throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("dropping a partition added in the same transaction is not supported: %s %s %s", databaseName, tableName, partitionValues));
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void finishInsertIntoExistingPartition(ConnectorSession session, String databaseName, String tableName, List<String> partitionValues, Path currentLocation, List<String> fileNames, PartitionStatistics statisticsUpdate, HiveACIDWriteType acidWriteType, boolean cleanExtraOutputFilesOnCommit) {
        this.setShared();
        this.isVacuumIncluded |= HiveACIDWriteType.isVacuum(acidWriteType);
        HiveIdentity identity = new HiveIdentity(session);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Map partitionActionsOfTable = this.partitionActions.computeIfAbsent(schemaTableName, k -> new LinkedHashMap());
        Action oldPartitionAction = (Action)partitionActionsOfTable.get(partitionValues);
        if (oldPartitionAction == null) {
            Partition partition = this.delegate.getPartition(identity, databaseName, tableName, partitionValues).orElseThrow(() -> new PartitionNotFoundException(schemaTableName, partitionValues));
            String partitionName = this.getPartitionName(identity, databaseName, tableName, partitionValues);
            PartitionStatistics mergedStatistics = statisticsUpdate;
            boolean updateStats = this.canUpdateStats(session, acidWriteType);
            if (updateStats) {
                PartitionStatistics currentStatistics = this.closure.getPartitionStatistics(identity, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
                if (currentStatistics == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "currentStatistics is null");
                }
                mergedStatistics = Statistics.merge(currentStatistics, statisticsUpdate);
            }
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, databaseName, tableName);
            partitionActionsOfTable.put(partitionValues, new Action<PartitionAndMore>(ActionType.INSERT_EXISTING, new PartitionAndMore(identity, partition, currentLocation, Optional.of(fileNames), mergedStatistics, statisticsUpdate, updateStats, cleanExtraOutputFilesOnCommit), context, identity, session.getQueryId()));
            return;
        }
        switch (oldPartitionAction.getType()) {
            case DROP: {
                throw new PartitionNotFoundException(schemaTableName, partitionValues);
            }
            case ADD: 
            case ALTER: 
            case INSERT_EXISTING: {
                throw new UnsupportedOperationException("Inserting into a partition that were added, altered, or inserted into in the same transaction is not supported");
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    private boolean canUpdateStats(ConnectorSession session, HiveACIDWriteType acidWriteType) {
        boolean updateStats = HiveACIDWriteType.VACUUM_UNIFY == acidWriteType ? false : HiveSessionProperties.isCollectColumnStatisticsOnWrite(session) && !HiveACIDWriteType.isUpdateOrDelete(acidWriteType) && HiveACIDWriteType.VACUUM != acidWriteType;
        return updateStats;
    }

    private String getPartitionName(HiveIdentity identity, String databaseName, String tableName, List<String> partitionValues) {
        Table table = this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        return this.getPartitionName(table, partitionValues);
    }

    private String getPartitionName(Table table, List<String> partitionValues) {
        List columnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        return FileUtils.makePartName((List)columnNames, partitionValues);
    }

    public synchronized void createRole(String role, String grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.createRole(role, grantor));
    }

    public synchronized void dropRole(String role) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.dropRole(role));
    }

    public synchronized Set<String> listRoles() {
        this.checkReadable();
        return this.delegate.listRoles();
    }

    public synchronized void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean withAdminOption, HivePrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.grantRoles(roles, grantees, withAdminOption, grantor));
    }

    public synchronized void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOptionFor, HivePrincipal grantor) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.revokeRoles(roles, grantees, adminOptionFor, grantor));
    }

    public synchronized Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        this.checkReadable();
        return this.delegate.listRoleGrants(principal);
    }

    public synchronized Set<HivePrivilegeInfo> listColumnPrivileges(String databaseName, String tableName, String columnName, HivePrincipal principal) {
        return this.delegate.listColumnPrivileges(databaseName, tableName, columnName, principal);
    }

    public synchronized Set<HivePrivilegeInfo> listSchemaPrivileges(String databaseName, String tableName, HivePrincipal principal) {
        return this.delegate.listSchemaPrivileges(databaseName, tableName, principal);
    }

    public synchronized Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, HivePrincipal principal) {
        this.checkReadable();
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Action<TableAndMore> tableAction = this.tableActions.get(schemaTableName);
        if (tableAction == null) {
            return this.delegate.listTablePrivileges(databaseName, tableName, principal);
        }
        switch (tableAction.getType()) {
            case ADD: 
            case ALTER: {
                if (principal.getType() == PrincipalType.ROLE) {
                    return ImmutableSet.of();
                }
                if (!principal.getName().equals(tableAction.getData().getTable().getOwner())) {
                    return ImmutableSet.of();
                }
                Set privileges = tableAction.getData().getPrincipalPrivileges().getUserPrivileges().get((Object)principal.getName());
                return ImmutableSet.builder().addAll((Iterable)privileges).add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, new HivePrincipal(PrincipalType.USER, principal.getName()), new HivePrincipal(PrincipalType.USER, principal.getName()))).build();
            }
            case INSERT_EXISTING: {
                return this.delegate.listTablePrivileges(databaseName, tableName, principal);
            }
            case DROP: {
                throw new TableNotFoundException(schemaTableName);
            }
        }
        throw new IllegalStateException("Unknown action type");
    }

    public synchronized void grantTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.grantTablePrivileges(databaseName, tableName, grantee, privileges));
    }

    public synchronized void revokeTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.setExclusive((delegate, hdfsEnvironment) -> delegate.revokeTablePrivileges(databaseName, tableName, grantee, privileges));
    }

    public synchronized void declareIntentionToWrite(ConnectorSession session, LocationHandle.WriteMode writeMode, Path stagingPathRoot, SchemaTableName schemaTableName) {
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable;
        this.setShared();
        if (writeMode == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY && (partitionActionsOfTable = this.partitionActions.get(schemaTableName)) != null && !partitionActionsOfTable.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can not insert into a table with a partition that has been modified in the same transaction when Presto is configured to skip temporary directories.");
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, schemaTableName.getSchemaName(), schemaTableName.getTableName());
        HiveIdentity identity = new HiveIdentity(session);
        this.declaredIntentionsToWrite.add(new DeclaredIntentionToWrite(writeMode, hdfsContext, identity, session.getQueryId(), stagingPathRoot, schemaTableName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void commit() {
        try {
            switch (this.state) {
                case EMPTY: {
                    this.commitTransaction();
                    return;
                }
                case SHARED_OPERATION_BUFFERED: {
                    this.commitShared();
                    return;
                }
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    Objects.requireNonNull(this.bufferedExclusiveOperation, "bufferedExclusiveOperation is null");
                    this.bufferedExclusiveOperation.execute(this.delegate, this.hdfsEnvironment);
                    return;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to commit buffered metastore operations after transaction has been committed/aborted");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    public void submitCleanupTasks() {
        if (this.vacuumCleanerTasks.size() > 0) {
            this.vacuumCleanerTasks.forEach(c -> c.submitVacuumCleanupTask());
        }
        if (this.tableHandle != null) {
            VacuumEligibleTableCollector.finishVacuum(this.tableHandle.getSchemaTableName().toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void rollback() {
        try {
            switch (this.state) {
                case EMPTY: {
                    this.abortTransaction();
                }
                case EXCLUSIVE_OPERATION_BUFFERED: {
                    return;
                }
                case SHARED_OPERATION_BUFFERED: {
                    this.rollbackShared();
                    return;
                }
                case FINISHED: {
                    throw new IllegalStateException("Tried to rollback buffered metastore operations after transaction has been committed/aborted");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
        finally {
            this.state = State.FINISHED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        HiveIdentity identity = new HiveIdentity(session);
        SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this;
        synchronized (semiTransactionalHiveMetastore) {
            Preconditions.checkState((!this.currentQueryId.isPresent() ? 1 : 0) != 0, (String)"Query already begun: %s while starting query %s", this.currentQueryId, (Object)queryId);
            this.currentQueryId = Optional.of(queryId);
            if (!this.hiveTransactionSupplier.isPresent()) {
                this.hiveTransactionSupplier = Optional.of(() -> {
                    long heartbeatInterval = this.configuredTransactionHeartbeatInterval.map(Duration::toMillis).orElseGet(this::getServerExpectedHeartbeatIntervalMillis);
                    long transactionId = this.delegate.openTransaction(identity);
                    log.debug("Using hive transaction %s for query %s", new Object[]{transactionId, queryId});
                    ScheduledFuture<?> heartbeatTask = this.heartbeatExecutor.scheduleAtFixedRate(() -> this.delegate.sendTransactionHeartbeat(identity, transactionId), 0L, heartbeatInterval, TimeUnit.MILLISECONDS);
                    return new HiveTransaction(identity, transactionId, heartbeatTask);
                });
            }
        }
    }

    private long getServerExpectedHeartbeatIntervalMillis() {
        String hiveServerTransactionTimeout = this.delegate.getConfigValue(MetastoreConf.ConfVars.TXN_TIMEOUT.getVarname()).orElseGet(() -> MetastoreConf.ConfVars.TXN_TIMEOUT.getDefaultVal().toString());
        Configuration configuration = new Configuration(false);
        configuration.set(MetastoreConf.ConfVars.TXN_TIMEOUT.toString(), hiveServerTransactionTimeout);
        return MetastoreConf.getTimeVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) / 2L;
    }

    public synchronized Optional<ValidTxnWriteIdList> getValidWriteIds(ConnectorSession session, HiveTableHandle tableHandle, boolean isVacuum) {
        String queryId = session.getQueryId();
        Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is", (Object)queryId, this.currentQueryId);
        if (!AcidUtils.isTransactionalTable(tableHandle.getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing")))) {
            return Optional.empty();
        }
        if (!this.currentHiveTransaction.isPresent()) {
            this.currentHiveTransaction = Optional.of(this.hiveTransactionSupplier.orElseThrow(() -> new IllegalStateException("hiveTransactionSupplier is not set")).get());
        }
        return Optional.of(this.currentHiveTransaction.get().getValidWriteIds(this.delegate, tableHandle, queryId, isVacuum));
    }

    public synchronized Optional<Long> getTableWriteId(ConnectorSession session, HiveTableHandle tableHandle, HiveACIDWriteType writeType) {
        String queryId = session.getQueryId();
        Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is", (Object)queryId, this.currentQueryId);
        if (!AcidUtils.isTransactionalTable(tableHandle.getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing")))) {
            return Optional.empty();
        }
        if (!this.currentHiveTransaction.isPresent()) {
            this.currentHiveTransaction = Optional.of(this.hiveTransactionSupplier.orElseThrow(() -> new IllegalStateException("hiveTransactionSupplier is not set")).get());
        }
        return Optional.of(this.currentHiveTransaction.get().getTableWriteId(this.delegate, tableHandle, writeType, queryId));
    }

    public synchronized void cleanupQuery(ConnectorSession session) {
        String queryId = session.getQueryId();
        Preconditions.checkState((boolean)this.currentQueryId.equals(Optional.of(queryId)), (String)"Invalid query id %s while current query is", (Object)queryId, this.currentQueryId);
        this.currentQueryId = Optional.empty();
    }

    private void commitTransaction() {
        Optional<HiveTransaction> transaction = this.currentHiveTransaction;
        if (!transaction.isPresent()) {
            return;
        }
        long transactionId = transaction.get().getTransactionId();
        this.delegate.commitTransaction(transaction.get().getIdentity(), transactionId);
        this.currentHiveTransaction = Optional.empty();
        this.hiveTransactionSupplier = Optional.empty();
        ScheduledFuture<?> heartbeatTask = transaction.get().getHeartbeatTask();
        heartbeatTask.cancel(true);
    }

    private void abortTransaction() {
        Optional<HiveTransaction> transaction = this.currentHiveTransaction;
        if (!transaction.isPresent()) {
            return;
        }
        long transactionId = transaction.get().getTransactionId();
        this.delegate.abortTransaction(transaction.get().getIdentity(), transactionId);
        this.currentHiveTransaction = Optional.empty();
        this.hiveTransactionSupplier = Optional.empty();
        ScheduledFuture<?> heartbeatTask = transaction.get().getHeartbeatTask();
        heartbeatTask.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    private void commitShared() {
        this.checkHoldsLock();
        Committer committer = new Committer();
        HashMap ctasTablesMap = new HashMap();
        try {
            List tableActionsFutures = this.tableActions.entrySet().stream().map(entry -> this.hiveMetastoreClientService.submit(() -> {
                SchemaTableName schemaTableName = (SchemaTableName)entry.getKey();
                Action action = (Action)entry.getValue();
                switch (action.getType()) {
                    case DROP: {
                        committer.prepareDropTable(action.getIdentity(), schemaTableName);
                        break;
                    }
                    case ALTER: {
                        committer.prepareAlterTable(action.getHdfsContext(), action.getIdentity(), (TableAndMore)action.getData(), action.getQueryId());
                        break;
                    }
                    case ADD: {
                        ctasTablesMap.put(schemaTableName.toString(), action.getData());
                        committer.prepareAddTable(action.getHdfsContext(), (TableAndMore)action.getData(), action.getQueryId());
                        break;
                    }
                    case INSERT_EXISTING: {
                        committer.prepareInsertExistingTable(action.getHdfsContext(), (TableAndMore)action.getData(), action.getQueryId());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown action type");
                    }
                }
            })).collect(Collectors.toList());
            SemiTransactionalHiveMetastore.waitForCompletion(tableActionsFutures, "Table Actions preparation");
            for (Map.Entry<SchemaTableName, Map<List<String>, Action<PartitionAndMore>>> tableEntry : this.partitionActions.entrySet()) {
                Optional<Path> ctasTableCurrentPath;
                long partitionsSize;
                SchemaTableName schemaTableName = tableEntry.getKey();
                Collection<Action<PartitionAndMore>> values = tableEntry.getValue().values();
                if (values.isEmpty()) continue;
                HiveIdentity identity = values.iterator().next().getIdentity();
                Table table = this.getTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
                String tableKey = table.getDatabaseName() + SCHEMA_SEPARATOR + table.getTableName();
                TableAndMore tableData = (TableAndMore)ctasTablesMap.get(tableKey);
                if (null != tableData && (partitionsSize = tableEntry.getValue().entrySet().stream().count()) > 0L && (ctasTableCurrentPath = tableData.getCurrentLocation()).isPresent()) {
                    HdfsEnvironment.HdfsContext hdfsContext = values.iterator().next().getHdfsContext();
                    committer.renameStagingDir(hdfsContext, ctasTableCurrentPath.get(), new Path(table.getStorage().getLocation()));
                }
                List partitionActionsFutures = tableEntry.getValue().entrySet().stream().map(partitionEntry -> this.hiveMetastoreClientService.submit(() -> {
                    List partitionValues = (List)partitionEntry.getKey();
                    Action action = (Action)partitionEntry.getValue();
                    switch (action.getType()) {
                        case DROP: {
                            committer.prepareDropPartition(action.getIdentity(), schemaTableName, partitionValues);
                            break;
                        }
                        case ALTER: {
                            committer.prepareAlterPartition(table, action.getHdfsContext(), action.getIdentity(), (PartitionAndMore)action.getData(), action.getQueryId());
                            break;
                        }
                        case ADD: {
                            boolean isRenameRequired = true;
                            if (null != tableData && tableData.getCurrentLocation().isPresent() && ((PartitionAndMore)action.getData()).getCurrentLocation().getParent().equals((Object)tableData.getCurrentLocation().get())) {
                                isRenameRequired = false;
                            }
                            committer.prepareAddPartition(table, action.getHdfsContext(), action.getIdentity(), (PartitionAndMore)action.getData(), action.getQueryId(), isRenameRequired);
                            break;
                        }
                        case INSERT_EXISTING: {
                            committer.prepareInsertExistingPartition(table, action.getHdfsContext(), action.getIdentity(), (PartitionAndMore)action.getData(), action.getQueryId());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown action type");
                        }
                    }
                })).collect(Collectors.toList());
                SemiTransactionalHiveMetastore.waitForCompletion(partitionActionsFutures, "Partitions Actions preparation for table " + schemaTableName.toString());
            }
            committer.waitForAsyncRenames();
            committer.executeAddTableOperations();
            committer.executeAlterTableOperations();
            committer.executeAlterPartitionOperations();
            committer.executeAddPartitionOperations();
            committer.executeUpdateStatisticsOperations();
            this.commitTransaction();
        }
        catch (Throwable t) {
            committer.cancelUnstartedAsyncRenames();
            committer.undoUpdateStatisticsOperations();
            committer.undoAddPartitionOperations();
            committer.undoAddTableOperations();
            committer.waitForAsyncRenamesSuppressThrowables();
            committer.executeCleanupTasksForAbort(this.declaredIntentionsToWrite);
            committer.executeRenameTasksForAbort();
            committer.undoAlterTableOperations();
            committer.undoAlterPartitionOperations();
            this.rollbackShared();
            throw t;
        }
        try {
            committer.executeIrreversibleMetastoreOperations();
        }
        finally {
            committer.executeDeletionTasksForFinish();
            committer.pruneAndDeleteStagingDirectories(this.declaredIntentionsToWrite);
        }
    }

    private static void waitForCompletion(List<? extends ListenableFuture<?>> tableActionsFuture, String operation) {
        ListenableFuture listListenableFuture = Futures.allAsList(tableActionsFuture);
        try {
            listListenableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof PrestoException) {
                throw (PrestoException)e.getCause();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Error during " + operation, e.getCause());
        }
    }

    public void initiateVacuumCleanupTasks(HiveVacuumTableHandle vacuumTableHandle, ConnectorSession session, List<PartitionUpdate> partitionUpdates) {
        if (vacuumTableHandle.getRanges() != null && vacuumTableHandle.getRanges().size() > 0) {
            HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, vacuumTableHandle.getSchemaName(), vacuumTableHandle.getTableName());
            long maxId = Long.MIN_VALUE;
            if (vacuumTableHandle.isUnifyVacuum()) {
                maxId = vacuumTableHandle.getLocationHandle().getJsonSerializablewriteIdInfo().get().getMaxWriteId();
            } else {
                for (List<HiveVacuumTableHandle.Range> partitionRange : vacuumTableHandle.getRanges().values()) {
                    for (HiveVacuumTableHandle.Range range : partitionRange) {
                        if (maxId >= range.getMax()) continue;
                        maxId = range.getMax();
                    }
                }
            }
            for (int index = 0; index < partitionUpdates.size(); ++index) {
                VacuumTableInfoForCleaner info = new VacuumTableInfoForCleaner(vacuumTableHandle.getSchemaName(), vacuumTableHandle.getTableName(), partitionUpdates.get(index).getName(), maxId, partitionUpdates.get(index).getTargetPath());
                this.vacuumCleanerTasks.add(new VacuumCleaner(info, this, this.hdfsEnvironment, hdfsContext));
            }
        }
    }

    public void refreshMetastoreCache() {
        this.delegate.refreshMetastoreCache();
    }

    @GuardedBy(value="this")
    private void rollbackShared() {
        this.checkHoldsLock();
        this.abortTransaction();
        block4: for (DeclaredIntentionToWrite declaredIntentionToWrite : this.declaredIntentionsToWrite) {
            switch (declaredIntentionToWrite.getMode()) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: 
                case DIRECT_TO_TARGET_NEW_DIRECTORY: {
                    if (declaredIntentionToWrite.getMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY && this.skipTargetCleanupOnRollback) break;
                    Path rootPath = declaredIntentionToWrite.getRootPath();
                    this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), rootPath, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), true, String.format("staging/target_new directory rollback for table %s", declaredIntentionToWrite.getSchemaTableName()));
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    HashSet<Path> pathsToClean = new HashSet<Path>();
                    Path baseDirectory = declaredIntentionToWrite.getRootPath();
                    pathsToClean.add(baseDirectory);
                    HiveIdentity identity = declaredIntentionToWrite.getIdentity();
                    SchemaTableName schemaTableName = declaredIntentionToWrite.getSchemaTableName();
                    Optional<Table> table = this.delegate.getTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    if (table.isPresent()) {
                        if (!table.get().getPartitionColumns().isEmpty()) {
                            List<String> partitionNames = this.delegate.getPartitionNames(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElse((List<String>)ImmutableList.of());
                            for (List partitionNameBatch : Iterables.partition(partitionNames, (int)10)) {
                                Collection<Optional<Partition>> partitions = this.delegate.getPartitionsByNames(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionNameBatch).values();
                                partitions.stream().filter(Optional::isPresent).map(Optional::get).map(partition -> partition.getStorage().getLocation()).map(Path::new).filter(path -> !SemiTransactionalHiveMetastore.isSameOrParent(baseDirectory, path)).forEach(pathsToClean::add);
                            }
                        }
                    } else {
                        this.logCleanupFailure("Error rolling back write to table %s.%s. Data directory may contain temporary data. Table was dropped in another transaction.", schemaTableName.getSchemaName(), schemaTableName.getTableName());
                    }
                    for (Path path2 : pathsToClean) {
                        this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), path2, (Set<String>)ImmutableSet.of((Object)declaredIntentionToWrite.getQueryId()), false, String.format("target_existing directory rollback for table %s", schemaTableName));
                    }
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown write mode");
                }
            }
        }
    }

    @VisibleForTesting
    public synchronized void testOnlyCheckIsReadOnly() {
        if (this.state != State.EMPTY) {
            throw new AssertionError((Object)"Test did not commit or rollback");
        }
    }

    @VisibleForTesting
    public void testOnlyThrowOnCleanupFailures() {
        this.throwOnCleanupFailure = true;
    }

    @GuardedBy(value="this")
    private void checkReadable() {
        this.checkHoldsLock();
        switch (this.state) {
            case EMPTY: 
            case SHARED_OPERATION_BUFFERED: {
                return;
            }
            case EXCLUSIVE_OPERATION_BUFFERED: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
            }
            case FINISHED: {
                throw new IllegalStateException("Tried to access metastore after transaction has been committed/aborted");
            }
        }
    }

    @GuardedBy(value="this")
    private void setShared() {
        this.checkHoldsLock();
        this.checkReadable();
        this.state = State.SHARED_OPERATION_BUFFERED;
    }

    @GuardedBy(value="this")
    private void setExclusive(ExclusiveOperation exclusiveOperation) {
        this.checkHoldsLock();
        if (this.state != State.EMPTY) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported combination of operations in a single transaction");
        }
        this.state = State.EXCLUSIVE_OPERATION_BUFFERED;
        this.bufferedExclusiveOperation = exclusiveOperation;
    }

    @GuardedBy(value="this")
    private void checkNoPartitionAction(String databaseName, String tableName) {
        this.checkHoldsLock();
        Map<List<String>, Action<PartitionAndMore>> partitionActionsOfTable = this.partitionActions.get(new SchemaTableName(databaseName, tableName));
        if (partitionActionsOfTable != null && !partitionActionsOfTable.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot make schema changes to a table/view with modified partitions in the same transaction");
        }
    }

    private static boolean isSameOrParent(Path parent, Path inputCchild) {
        int childDepth;
        Path child = inputCchild;
        int parentDepth = parent.depth();
        if (parentDepth > (childDepth = child.depth())) {
            return false;
        }
        for (int i = childDepth; i > parentDepth; --i) {
            child = child.getParent();
        }
        return parent.equals((Object)child);
    }

    private void logCleanupFailure(String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args));
        }
        log.warn(format, args);
    }

    private void logCleanupFailure(Throwable t, String format, Object ... args) {
        if (this.throwOnCleanupFailure) {
            throw new RuntimeException(String.format(format, args), t);
        }
        log.warn(t, format, args);
    }

    private static void asyncRename(HdfsEnvironment hdfsEnvironment, Executor executor, AtomicBoolean cancelled, List<CompletableFuture<?>> fileRenameFutures, HdfsEnvironment.HdfsContext context, Path currentPath, Path targetPath, List<String> inputFileNames, List<DirectoryCleanUpTask> cleanUpTasksForAbort, boolean useDirectExecutor) {
        FileSystem fileSystem;
        List<String> fileNames = inputFileNames;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, currentPath);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files to final location. Error listing directory %s", currentPath), (Throwable)e);
        }
        fileNames = fileNames.stream().distinct().collect(Collectors.toList());
        Executor localRenameExecutor = useDirectExecutor ? MoreExecutors.directExecutor() : executor;
        for (String fileName : fileNames) {
            Path source = new Path(currentPath, fileName);
            Path target = new Path(targetPath, fileName);
            fileRenameFutures.add(CompletableFuture.runAsync(() -> {
                if (cancelled.get()) {
                    return;
                }
                try {
                    if (fileSystem.exists(target)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s", source, target));
                    }
                    if (!fileSystem.exists(target.getParent())) {
                        fileSystem.mkdirs(target.getParent());
                    }
                    if (!fileSystem.rename(source, target)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s", source, target));
                    }
                    cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, target, true));
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving data files from %s to final location %s", source, target), (Throwable)e);
                }
            }, localRenameExecutor));
        }
    }

    private void recursiveDeleteFilesAndLog(HdfsEnvironment.HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories, String reason) {
        RecursiveDeleteResult recursiveDeleteResult = SemiTransactionalHiveMetastore.recursiveDeleteFiles(this.hdfsEnvironment, context, directory, queryIds, deleteEmptyDirectories);
        if (!recursiveDeleteResult.getNotDeletedEligibleItems().isEmpty()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Some eligible items can not be deleted: %s.", directory.toString(), reason, recursiveDeleteResult.getNotDeletedEligibleItems());
        } else if (deleteEmptyDirectories && !recursiveDeleteResult.isDirectoryNoLongerExists()) {
            this.logCleanupFailure("Error deleting directory %s for %s. Can not delete the directory.", directory.toString(), reason);
        }
    }

    private static Optional<String> getPrestoQueryId(Table table) {
        return Optional.ofNullable(table.getParameters().get("presto_query_id"));
    }

    private static Optional<String> getPrestoQueryId(Partition partition) {
        return Optional.ofNullable(partition.getParameters().get("presto_query_id"));
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    private static boolean deleteIfExists(FileSystem fileSystem, Path path, boolean recursive) {
        try {
            if (fileSystem.delete(path, recursive)) {
                return true;
            }
            return !fileSystem.exists(path);
        }
        catch (FileNotFoundException ignored) {
            log.debug("path may be removed or never existed", new Object[]{ignored});
            return true;
        }
        catch (IOException ignored) {
            log.error("Hdfs RPC Call Error", new Object[]{ignored});
            return false;
        }
    }

    private static void renameNewPartitionDirectory(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path source, Path target, List<DirectoryCleanUpTask> cleanUpTasksForAbort) {
        FileStatus fileStatus = HiveWriteUtils.getFileStatus(context, hdfsEnvironment, source);
        if (fileStatus.isDirectory()) {
            FileStatus[] children = HiveWriteUtils.getChildren(context, hdfsEnvironment, source);
            int childFileCounter = 0;
            for (FileStatus child : children) {
                Path subTarget = new Path(target, child.getPath().getName());
                if (childFileCounter == 0) {
                    SemiTransactionalHiveMetastore.renameFile(context, hdfsEnvironment, child.getPath(), subTarget, () -> cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, subTarget, true)), true);
                } else {
                    SemiTransactionalHiveMetastore.renameFile(context, hdfsEnvironment, child.getPath(), subTarget, () -> cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, subTarget, true)), false);
                }
                ++childFileCounter;
            }
        } else {
            SemiTransactionalHiveMetastore.renameDirectory(context, hdfsEnvironment, source, target, () -> cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, target, true)));
        }
    }

    private static void renameDirectory(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path source, Path target, Runnable runWhenRenameSuccess) {
        if (HiveWriteUtils.pathExists(context, hdfsEnvironment, target)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to rename from %s to %s: target directory already exists", source, target));
        }
        if (!HiveWriteUtils.pathExists(context, hdfsEnvironment, target.getParent())) {
            HiveWriteUtils.createDirectory(context, hdfsEnvironment, target.getParent());
        }
        try {
            if (!hdfsEnvironment.getFileSystem(context, source).rename(source, target)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s: rename returned false", source, target));
            }
            runWhenRenameSuccess.run();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s", source, target), (Throwable)e);
        }
    }

    private static void renameFile(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path source, Path target, Runnable runWhenRenameSuccess, boolean createParentDir) {
        if (createParentDir && !HiveWriteUtils.pathExists(context, hdfsEnvironment, target.getParent())) {
            HiveWriteUtils.createDirectory(context, hdfsEnvironment, target.getParent());
        }
        try {
            if (!hdfsEnvironment.getFileSystem(context, source).rename(source, target)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename file from %s to %s: rename returned false", source, target));
            }
            runWhenRenameSuccess.run();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename file from %s to %s", source, target), (Throwable)e);
        }
    }

    private static boolean deleteRecursivelyIfExists(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, path);
        }
        catch (IOException ignored) {
            log.error("Hdfs RPC Call Error", new Object[]{ignored});
            return false;
        }
        return SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, path, true);
    }

    private static RecursiveDeleteResult doRecursiveDeleteFiles(FileSystem fileSystem, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        FileStatus[] allFiles;
        if (directory.getName().startsWith(".presto")) {
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of());
        }
        if (directory.getName().startsWith(".staging") && SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, directory, true)) {
            return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
        }
        try {
            allFiles = fileSystem.listStatus(directory);
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        boolean allDescendentsDeleted = true;
        ImmutableList.Builder notDeletedEligibleItems = ImmutableList.builder();
        for (FileStatus fileStatus : allFiles) {
            if (fileStatus.isFile()) {
                Path filePath = fileStatus.getPath();
                String fileName = filePath.getName();
                boolean eligible = false;
                if (!fileName.startsWith(".presto") && !fileName.startsWith("_orc")) {
                    eligible = queryIds.stream().anyMatch(id -> fileName.startsWith((String)id) || fileName.endsWith((String)id) || fileName.startsWith("bucket_"));
                }
                if (eligible) {
                    if (SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, filePath, false)) continue;
                    allDescendentsDeleted = false;
                    notDeletedEligibleItems.add((Object)filePath.toString());
                    continue;
                }
                allDescendentsDeleted = false;
                continue;
            }
            if (fileStatus.isDirectory()) {
                RecursiveDeleteResult subResult = SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, fileStatus.getPath(), queryIds, deleteEmptyDirectories);
                if (!subResult.isDirectoryNoLongerExists()) {
                    allDescendentsDeleted = false;
                }
                if (subResult.getNotDeletedEligibleItems().isEmpty()) continue;
                notDeletedEligibleItems.addAll(subResult.getNotDeletedEligibleItems());
                continue;
            }
            allDescendentsDeleted = false;
            notDeletedEligibleItems.add((Object)fileStatus.getPath().toString());
        }
        if (allDescendentsDeleted && deleteEmptyDirectories) {
            Verify.verify((boolean)notDeletedEligibleItems.build().isEmpty());
            if (!SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, directory, false)) {
                return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of((Object)(directory.toString() + "/")));
            }
            return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
        }
        return new RecursiveDeleteResult(false, (List<String>)notDeletedEligibleItems.build());
    }

    private static RecursiveDeleteResult recursiveDeleteFiles(HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext context, Path directory, Set<String> queryIds, boolean deleteEmptyDirectories) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, directory);
            if (!fileSystem.exists(directory)) {
                return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
            }
        }
        catch (IOException e) {
            ImmutableList.Builder notDeletedItems = ImmutableList.builder();
            notDeletedItems.add((Object)(directory.toString() + "/**"));
            return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
        }
        return SemiTransactionalHiveMetastore.doRecursiveDeleteFiles(fileSystem, directory, queryIds, deleteEmptyDirectories);
    }

    private static RecursiveDeleteResult moveToTrash(HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext context, Path directory) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, directory);
            if (!fileSystem.exists(directory)) {
                return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
            }
        }
        catch (IOException ioe) {
            log.error("Hdfs RPC Call Error", new Object[]{ioe});
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of((Object)(directory.toString() + "/**")));
        }
        return SemiTransactionalHiveMetastore.doMoveToTrash(fileSystem, directory, hdfsEnvironment, context);
    }

    private static RecursiveDeleteResult doMoveToTrash(FileSystem fileSystem, Path directory, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext context) {
        FileStatus[] allFiles;
        if (directory.getName().startsWith(".presto")) {
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of());
        }
        try {
            allFiles = fileSystem.listStatus(directory);
        }
        catch (IOException ioe) {
            return new RecursiveDeleteResult(false, (List<String>)ImmutableList.of((Object)(directory.toString() + "/**")));
        }
        boolean allDeleted = true;
        ImmutableList.Builder notDeletedItems = ImmutableList.builder();
        for (FileStatus fileStatus : allFiles) {
            if (fileStatus.isFile()) {
                boolean isSuccess;
                Path filePath = fileStatus.getPath();
                String fileName = filePath.getName();
                if (fileName.startsWith(".presto") || fileName.startsWith("_orc") || (isSuccess = SemiTransactionalHiveMetastore.moveFileToTrash(fileSystem, filePath, hdfsEnvironment, context))) continue;
                allDeleted = false;
                notDeletedItems.add((Object)filePath.toString());
                continue;
            }
            if (fileStatus.isDirectory()) {
                RecursiveDeleteResult subResult = SemiTransactionalHiveMetastore.doMoveToTrash(fileSystem, fileStatus.getPath(), hdfsEnvironment, context);
                if (!subResult.isDirectoryNoLongerExists()) {
                    allDeleted = false;
                }
                if (subResult.getNotDeletedEligibleItems().isEmpty()) continue;
                notDeletedItems.addAll(subResult.getNotDeletedEligibleItems());
                continue;
            }
            allDeleted = false;
            notDeletedItems.add((Object)fileStatus.getPath().toString());
        }
        if (allDeleted) {
            return new RecursiveDeleteResult(true, (List<String>)ImmutableList.of());
        }
        return new RecursiveDeleteResult(false, (List<String>)notDeletedItems.build());
    }

    private static boolean moveFileToTrash(FileSystem fileSystem, Path path, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext context) {
        try {
            Trash trash = new Trash(fileSystem, hdfsEnvironment.getConfiguration(context, path));
            boolean result = trash.moveToTrash(path);
            if (result) {
                return true;
            }
        }
        catch (IOException ignored) {
            log.warn(String.format("move file %s to trash failed and force to delete it.", path.toString()), new Object[]{ignored});
        }
        return SemiTransactionalHiveMetastore.deleteIfExists(fileSystem, path, false);
    }

    public ScheduledExecutorService getVacuumExecutorService() {
        return this.vacuumExecutorService;
    }

    public long getVacuumCleanupInterval() {
        return this.configuredVacuumCleanupInterval.toMillis();
    }

    public ShowLocksResponse showLocks(VacuumTableInfoForCleaner tableInfo) {
        ShowLocksRequest rqst = new ShowLocksRequest();
        rqst.setDbname(tableInfo.getDbName());
        rqst.setTablename(tableInfo.getTableName());
        if (tableInfo.getPartitionName().length() > 0) {
            rqst.setPartname(tableInfo.getPartitionName());
        }
        return this.delegate.showLocks(rqst);
    }

    public void setVacuumTableHandle(HiveTableHandle vacuumTableHandle) {
        this.tableHandle = vacuumTableHandle;
    }

    public static void cleanExtraOutputFiles(HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext, String queryId, Path path, Set<String> filesToKeep) {
        LinkedList<String> filesToDelete = new LinkedList<String>();
        try {
            log.debug("Deleting failed attempt files from %s for query %s", new Object[]{path, queryId});
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(hdfsContext, path);
            if (!fileSystem.exists(path)) {
                return;
            }
            RemoteIterator iterator = fileSystem.listFiles(path, false);
            while (iterator.hasNext()) {
                Path file = ((LocatedFileStatus)iterator.next()).getPath();
                if (!HiveWriteUtils.isFileCreatedByQuery(file.getName(), queryId) || filesToKeep.contains(file.getName())) continue;
                filesToDelete.add(file.getName());
            }
            ImmutableList.Builder deletedFilesBuilder = ImmutableList.builder();
            Iterator filesToDeleteIterator = filesToDelete.iterator();
            while (filesToDeleteIterator.hasNext()) {
                String fileName = (String)filesToDeleteIterator.next();
                Path filePath = new Path(path, fileName);
                log.debug("Deleting failed attempt file %s for query %s", new Object[]{filePath, queryId});
                DELETE_RETRY.run("delete " + filePath, () -> {
                    HiveWriteUtils.checkedDelete(fileSystem, filePath, false);
                    return null;
                });
                deletedFilesBuilder.add((Object)fileName);
                filesToDeleteIterator.remove();
            }
            ImmutableList deletedFiles = deletedFilesBuilder.build();
            if (!deletedFiles.isEmpty()) {
                log.info("Deleted failed attempt files %s from %s for query %s", new Object[]{deletedFiles, path, queryId});
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error deleting failed retry attempt files from %s; remaining files %s; manual cleanup may be required", path, filesToDelete), (Throwable)e);
        }
    }

    private static interface ExclusiveOperation {
        public void execute(HiveMetastore var1, HdfsEnvironment var2);
    }

    private static class PartitionAdder {
        private final HiveIdentity identity;
        private final String schemaName;
        private final String tableName;
        private final HiveMetastore metastore;
        private final int batchSize;
        private final List<PartitionWithStatistics> partitions;
        private List<List<String>> createdPartitionValues = new ArrayList<List<String>>();
        private final List<UpdateStatisticsOperation> updateStatisticsOperations;

        public PartitionAdder(HiveIdentity identity, String schemaName, String tableName, HiveMetastore metastore, int batchSize, List<UpdateStatisticsOperation> updateStatisticsOperations) {
            this.identity = identity;
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.metastore = metastore;
            this.batchSize = batchSize;
            this.partitions = new ArrayList<PartitionWithStatistics>(batchSize);
            this.updateStatisticsOperations = updateStatisticsOperations;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public synchronized void addPartition(PartitionWithStatistics partition) {
            Preconditions.checkArgument((boolean)SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()).isPresent());
            this.partitions.add(partition);
        }

        public void execute(ListeningExecutorService hiveMetastoreClientService) {
            List batchedPartitions = Lists.partition(this.partitions, (int)this.batchSize);
            List futures = batchedPartitions.stream().map(batch -> hiveMetastoreClientService.submit(() -> this.addPartitionBatch((List<PartitionWithStatistics>)batch))).collect(Collectors.toList());
            SemiTransactionalHiveMetastore.waitForCompletion(futures, "add partition");
            this.partitions.clear();
        }

        private void addPartitionBatch(List<PartitionWithStatistics> batch) {
            block9: {
                try {
                    this.metastore.addPartitions(this.identity, this.schemaName, this.tableName, batch);
                    for (PartitionWithStatistics partition : batch) {
                        this.createdPartitionValues.add(partition.getPartition().getValues());
                    }
                }
                catch (Throwable t) {
                    boolean batchCompletelyAdded = true;
                    for (PartitionWithStatistics partition : batch) {
                        try {
                            Optional<Partition> remotePartition = this.metastore.getPartition(this.identity, this.schemaName, this.tableName, partition.getPartition().getValues());
                            if (remotePartition.isPresent()) {
                                if (SemiTransactionalHiveMetastore.getPrestoQueryId(remotePartition.get()).equals(SemiTransactionalHiveMetastore.getPrestoQueryId(partition.getPartition()))) {
                                    this.createdPartitionValues.add(partition.getPartition().getValues());
                                    continue;
                                }
                                if (!partition.isUpdateStats()) continue;
                                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(this.identity, partition.getPartition().getSchemaTableName(), Optional.of(partition.getPartitionName()), partition.getStatistics(), true));
                                continue;
                            }
                            batchCompletelyAdded = false;
                        }
                        catch (Throwable ignored) {
                            batchCompletelyAdded = false;
                        }
                    }
                    if (batchCompletelyAdded) break block9;
                    if (t instanceof TableNotFoundException) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, t);
                    }
                    throw t;
                }
            }
        }

        public List<List<String>> rollback() {
            ArrayList<List<String>> partitionsFailedToRollback = new ArrayList<List<String>>();
            for (List<String> createdPartitionValue : this.createdPartitionValues) {
                try {
                    this.metastore.dropPartition(this.identity, this.schemaName, this.tableName, createdPartitionValue, false);
                }
                catch (PartitionNotFoundException e) {
                    log.debug("Drop partition error(schemaName=%s tableName=%s), may be partition is not there anymore", new Object[]{this.schemaName, this.tableName});
                }
                catch (Throwable t) {
                    partitionsFailedToRollback.add(createdPartitionValue);
                }
            }
            this.createdPartitionValues = partitionsFailedToRollback;
            return partitionsFailedToRollback;
        }
    }

    private static class UpdateStatisticsOperation {
        private final HiveIdentity identity;
        private final SchemaTableName tableName;
        private final Optional<String> partitionName;
        private final PartitionStatistics statistics;
        private final boolean merge;
        private boolean done;

        public UpdateStatisticsOperation(HiveIdentity identity, SchemaTableName tableName, Optional<String> partitionName, PartitionStatistics statistics, boolean merge) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.partitionName = Objects.requireNonNull(partitionName, "partitionValues is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.merge = merge;
        }

        public void run(HiveMetastore metastore) {
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::updateStatistics);
            } else {
                metastore.updateTableStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this::updateStatistics);
            }
            this.done = true;
        }

        public void undo(HiveMetastore metastore) {
            if (!this.done) {
                return;
            }
            if (this.partitionName.isPresent()) {
                metastore.updatePartitionStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this.partitionName.get(), this::resetStatistics);
            } else {
                metastore.updateTableStatistics(this.identity, this.tableName.getSchemaName(), this.tableName.getTableName(), this::resetStatistics);
            }
        }

        public String getDescription() {
            if (this.partitionName.isPresent()) {
                return String.format("replace partition parameters %s %s", this.tableName, this.partitionName.get());
            }
            return String.format("replace table parameters %s", this.tableName);
        }

        private PartitionStatistics updateStatistics(PartitionStatistics currentStatistics) {
            if (currentStatistics.getBasicStatistics().getRowCount().orElse(1L) == 0L) {
                return this.statistics;
            }
            return this.merge ? Statistics.merge(currentStatistics, this.statistics) : this.statistics;
        }

        private PartitionStatistics resetStatistics(PartitionStatistics currentStatistics) {
            return new PartitionStatistics(Statistics.reduce(currentStatistics.getBasicStatistics(), this.statistics.getBasicStatistics(), Statistics.ReduceOperator.SUBTRACT), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
    }

    private static class AlterPartitionOperation {
        private final HiveIdentity identity;
        private final PartitionWithStatistics newPartition;
        private final PartitionWithStatistics oldPartition;
        private boolean undo;

        public AlterPartitionOperation(HiveIdentity identity, PartitionWithStatistics newPartition, PartitionWithStatistics oldPartition) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.newPartition = Objects.requireNonNull(newPartition, "newPartition is null");
            this.oldPartition = Objects.requireNonNull(oldPartition, "oldPartition is null");
            Preconditions.checkArgument((boolean)newPartition.getPartition().getDatabaseName().equals(oldPartition.getPartition().getDatabaseName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getTableName().equals(oldPartition.getPartition().getTableName()));
            Preconditions.checkArgument((boolean)newPartition.getPartition().getValues().equals(oldPartition.getPartition().getValues()));
        }

        public String getDescription() {
            return String.format("alter partition %s.%s %s", this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition.getPartition().getValues());
        }

        public void run(HiveMetastore metastore) {
            this.undo = true;
            metastore.alterPartition(this.identity, this.newPartition.getPartition().getDatabaseName(), this.newPartition.getPartition().getTableName(), this.newPartition);
        }

        public void undo(HiveMetastore metastore) {
            if (!this.undo) {
                return;
            }
            metastore.alterPartition(this.identity, this.oldPartition.getPartition().getDatabaseName(), this.oldPartition.getPartition().getTableName(), this.oldPartition);
        }
    }

    private static class AlterTableOperation {
        private final HiveIdentity identity;
        private final Table newTable;
        private final Table oldTable;
        private final PrincipalPrivileges principalPrivileges;
        private boolean undo;

        public AlterTableOperation(HiveIdentity identity, Table newTable, Table oldTable, PrincipalPrivileges principalPrivileges) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.newTable = Objects.requireNonNull(newTable, "newTable is null");
            this.oldTable = Objects.requireNonNull(oldTable, "oldTable is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            Preconditions.checkArgument((boolean)newTable.getDatabaseName().equals(oldTable.getDatabaseName()));
            Preconditions.checkArgument((boolean)newTable.getTableName().equals(oldTable.getTableName()));
        }

        public String getDescription() {
            return String.format("alter table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastore metastore) {
            this.undo = true;
            metastore.replaceTable(this.identity, this.newTable.getDatabaseName(), this.newTable.getTableName(), this.newTable, this.principalPrivileges);
        }

        public void undo(HiveMetastore metastore) {
            if (!this.undo) {
                return;
            }
            metastore.replaceTable(this.identity, this.oldTable.getDatabaseName(), this.oldTable.getTableName(), this.oldTable, this.principalPrivileges);
        }
    }

    private static class CreateTableOperation {
        private final HiveIdentity identity;
        private final Table newTable;
        private final PrincipalPrivileges privileges;
        private boolean tableCreated;
        private final boolean ignoreExisting;
        private final String queryId;

        public CreateTableOperation(HiveIdentity identity, Table newTable, PrincipalPrivileges privileges, boolean ignoreExisting) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(newTable, "newTable is null");
            this.newTable = newTable;
            this.privileges = Objects.requireNonNull(privileges, "privileges is null");
            this.ignoreExisting = ignoreExisting;
            this.queryId = (String)SemiTransactionalHiveMetastore.getPrestoQueryId(newTable).orElseThrow(() -> new IllegalArgumentException("Query id is not present"));
        }

        public String getDescription() {
            return String.format("add table %s.%s", this.newTable.getDatabaseName(), this.newTable.getTableName());
        }

        public void run(HiveMetastore metastore) {
            block9: {
                boolean done = false;
                try {
                    metastore.createTable(this.identity, this.newTable, this.privileges);
                    done = true;
                }
                catch (RuntimeException e2) {
                    PrestoException e2;
                    try {
                        Optional<Table> existingTable = metastore.getTable(this.identity, this.newTable.getDatabaseName(), this.newTable.getTableName());
                        if (existingTable.isPresent()) {
                            Table table = existingTable.get();
                            Optional existingTableQueryId = SemiTransactionalHiveMetastore.getPrestoQueryId(table);
                            if (existingTableQueryId.isPresent() && ((String)existingTableQueryId.get()).equals(this.queryId)) {
                                done = true;
                            } else if (!this.hasTheSameSchema(this.newTable, table)) {
                                e2 = new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("Table already exists with a different schema: '%s'", this.newTable.getTableName()));
                            } else {
                                done = this.ignoreExisting;
                            }
                        }
                    }
                    catch (RuntimeException ignored) {
                        log.debug("Create table error(dataBaseName=%s tableName=%s)", new Object[]{this.newTable.getDatabaseName(), this.newTable.getTableName()});
                    }
                    if (done) break block9;
                    throw e2;
                }
            }
            this.tableCreated = true;
        }

        private boolean hasTheSameSchema(Table newTable, Table existingTable) {
            List<Column> newTableColumns = newTable.getDataColumns();
            List<Column> existingTableColumns = existingTable.getDataColumns();
            if (newTableColumns.size() != existingTableColumns.size()) {
                return false;
            }
            for (Column existingColumn : existingTableColumns) {
                if (!newTableColumns.stream().noneMatch(newColumn -> newColumn.getName().equals(existingColumn.getName()) && newColumn.getType().equals(existingColumn.getType()))) continue;
                return false;
            }
            return true;
        }

        public void undo(HiveMetastore metastore) {
            if (!this.tableCreated) {
                return;
            }
            metastore.dropTable(this.identity, this.newTable.getDatabaseName(), this.newTable.getTableName(), false);
        }
    }

    private static class IrreversibleMetastoreOperation {
        private final String description;
        private final Runnable action;

        public IrreversibleMetastoreOperation(String description, Runnable action) {
            this.description = Objects.requireNonNull(description, "description is null");
            this.action = Objects.requireNonNull(action, "action is null");
        }

        public String getDescription() {
            return this.description;
        }

        public void run() {
            this.action.run();
        }
    }

    private static class DirectoryRenameTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path renameFrom;
        private final Path renameTo;

        public DirectoryRenameTask(HdfsEnvironment.HdfsContext context, Path renameFrom, Path renameTo) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.renameFrom = Objects.requireNonNull(renameFrom, "renameFrom is null");
            this.renameTo = Objects.requireNonNull(renameTo, "renameTo is null");
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getRenameFrom() {
            return this.renameFrom;
        }

        public Path getRenameTo() {
            return this.renameTo;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("renameFrom", (Object)this.renameFrom).add("renameTo", (Object)this.renameTo).toString();
        }
    }

    private static class DirectoryDeletionTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path path;

        public DirectoryDeletionTask(HdfsEnvironment.HdfsContext context, Path path) {
            this.context = context;
            this.path = path;
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).toString();
        }
    }

    private static class DirectoryCleanUpTask {
        private final HdfsEnvironment.HdfsContext context;
        private final Path path;
        private final boolean deleteEmptyDirectory;

        public DirectoryCleanUpTask(HdfsEnvironment.HdfsContext context, Path path, boolean deleteEmptyDirectory) {
            this.context = context;
            this.path = path;
            this.deleteEmptyDirectory = deleteEmptyDirectory;
        }

        public HdfsEnvironment.HdfsContext getContext() {
            return this.context;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isDeleteEmptyDirectory() {
            return this.deleteEmptyDirectory;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).add("path", (Object)this.path).add("deleteEmptyDirectory", this.deleteEmptyDirectory).toString();
        }
    }

    private static class DeclaredIntentionToWrite {
        private final LocationHandle.WriteMode mode;
        private final HdfsEnvironment.HdfsContext hdfsContext;
        private final HiveIdentity identity;
        private final String queryId;
        private final Path rootPath;
        private final SchemaTableName schemaTableName;

        public DeclaredIntentionToWrite(LocationHandle.WriteMode mode, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, String queryId, Path stagingPathRoot, SchemaTableName schemaTableName) {
            this.mode = Objects.requireNonNull(mode, "mode is null");
            this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.rootPath = Objects.requireNonNull(stagingPathRoot, "stagingPathRoot is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        public LocationHandle.WriteMode getMode() {
            return this.mode;
        }

        public HdfsEnvironment.HdfsContext getHdfsContext() {
            return this.hdfsContext;
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public Path getRootPath() {
            return this.rootPath;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("hdfsContext", (Object)this.hdfsContext).add("identity", (Object)this.identity).add("queryId", (Object)this.queryId).add("rootPath", (Object)this.rootPath).add("schemaTableName", (Object)this.schemaTableName).toString();
        }
    }

    private static class PartitionAndMore {
        private final HiveIdentity identity;
        private final Partition partition;
        private final Path currentLocation;
        private final Optional<List<String>> fileNames;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;
        private final boolean updateStats;
        private final boolean cleanExtraOutputFilesOnCommit;

        public PartitionAndMore(HiveIdentity identity, Partition partition, Path currentLocation, Optional<List<String>> fileNames, PartitionStatistics statistics, PartitionStatistics statisticsUpdate, boolean updateStats, boolean cleanExtraOutputFilesOnCommit) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.partition = Objects.requireNonNull(partition, "partition is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
            this.updateStats = updateStats;
            this.cleanExtraOutputFilesOnCommit = cleanExtraOutputFilesOnCommit;
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Path getCurrentLocation() {
            return this.currentLocation;
        }

        public List<String> getFileNames() {
            Preconditions.checkState((boolean)this.fileNames.isPresent());
            return this.fileNames.get();
        }

        public boolean hasFileNames() {
            return this.fileNames.isPresent();
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public boolean isCleanExtraOutputFilesOnCommit() {
            return this.cleanExtraOutputFilesOnCommit;
        }

        public Partition getAugmentedPartitionForInTransactionRead() {
            Partition localPartition = this.partition;
            String localCurrentLocation = this.currentLocation.toString();
            if (!localCurrentLocation.equals(localPartition.getStorage().getLocation())) {
                localPartition = Partition.builder(localPartition).withStorage(storage -> storage.setLocation(localCurrentLocation)).build();
            }
            return localPartition;
        }

        public boolean isUpdateStats() {
            return this.updateStats;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partition", (Object)this.partition).add("currentLocation", (Object)this.currentLocation).add("fileNames", this.fileNames).add("cleanExtraOutputFilesOnCommit", this.cleanExtraOutputFilesOnCommit).toString();
        }
    }

    private static class TableAndMore {
        private final Table table;
        private final HiveIdentity identity;
        private final Optional<PrincipalPrivileges> principalPrivileges;
        private final Optional<Path> currentLocation;
        private final Optional<List<String>> fileNames;
        private final boolean ignoreExisting;
        private final PartitionStatistics statistics;
        private final PartitionStatistics statisticsUpdate;
        private final boolean updateStats;
        private final boolean cleanExtraOutputFilesOnCommit;

        public TableAndMore(Table table, HiveIdentity identity, Optional<PrincipalPrivileges> principalPrivileges, Optional<Path> currentLocation, Optional<List<String>> fileNames, boolean ignoreExisting, PartitionStatistics statistics, PartitionStatistics statisticsUpdate, boolean updateStats, boolean cleanExtraOutputFilesOnCommit) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.principalPrivileges = Objects.requireNonNull(principalPrivileges, "principalPrivileges is null");
            this.currentLocation = Objects.requireNonNull(currentLocation, "currentLocation is null");
            this.fileNames = Objects.requireNonNull(fileNames, "fileNames is null");
            this.ignoreExisting = ignoreExisting;
            this.statistics = Objects.requireNonNull(statistics, "statistics is null");
            this.statisticsUpdate = Objects.requireNonNull(statisticsUpdate, "statisticsUpdate is null");
            this.updateStats = updateStats;
            Preconditions.checkArgument((!table.getStorage().getLocation().isEmpty() || !currentLocation.isPresent() ? 1 : 0) != 0, (Object)"currentLocation can not be supplied for table without location");
            Preconditions.checkArgument((!fileNames.isPresent() || currentLocation.isPresent() ? 1 : 0) != 0, (Object)"fileNames can be supplied only when currentLocation is supplied");
            this.cleanExtraOutputFilesOnCommit = cleanExtraOutputFilesOnCommit;
        }

        public boolean isIgnoreExisting() {
            return this.ignoreExisting;
        }

        public Table getTable() {
            return this.table;
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public PrincipalPrivileges getPrincipalPrivileges() {
            Preconditions.checkState((boolean)this.principalPrivileges.isPresent());
            return this.principalPrivileges.get();
        }

        public Optional<Path> getCurrentLocation() {
            return this.currentLocation;
        }

        public Optional<List<String>> getFileNames() {
            return this.fileNames;
        }

        public PartitionStatistics getStatistics() {
            return this.statistics;
        }

        public PartitionStatistics getStatisticsUpdate() {
            return this.statisticsUpdate;
        }

        public boolean isUpdateStats() {
            return this.updateStats;
        }

        public boolean isCleanExtraOutputFilesOnCommit() {
            return this.cleanExtraOutputFilesOnCommit;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("principalPrivileges", this.principalPrivileges).add("currentLocation", this.currentLocation).add("fileNames", this.fileNames).add("ignoreExisting", this.ignoreExisting).add("statistics", (Object)this.statistics).add("statisticsUpdate", (Object)this.statisticsUpdate).add("cleanExtraOutputFilesOnCommit", this.cleanExtraOutputFilesOnCommit).toString();
        }
    }

    public static class Action<T> {
        private final ActionType type;
        private final T data;
        private final HdfsEnvironment.HdfsContext hdfsContext;
        private final HiveIdentity identity;
        private final String queryId;

        public Action(ActionType type, T data, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, String queryId) {
            this.type = Objects.requireNonNull(type, "type is null");
            if (type == ActionType.DROP) {
                Preconditions.checkArgument((data == null ? 1 : 0) != 0, (Object)"data is not null");
            } else {
                Objects.requireNonNull(data, "data is null");
            }
            this.data = data;
            this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext  is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        }

        public ActionType getType() {
            return this.type;
        }

        public T getData() {
            Preconditions.checkState((this.type != ActionType.DROP ? 1 : 0) != 0);
            return this.data;
        }

        public HdfsEnvironment.HdfsContext getHdfsContext() {
            return this.hdfsContext;
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("data", this.data).toString();
        }
    }

    private static enum TableSource {
        CREATED_IN_THIS_TRANSACTION,
        PRE_EXISTING_TABLE;

    }

    private static enum ActionType {
        DROP,
        ADD,
        ALTER,
        INSERT_EXISTING;

    }

    private static enum State {
        EMPTY,
        SHARED_OPERATION_BUFFERED,
        EXCLUSIVE_OPERATION_BUFFERED,
        FINISHED;

    }

    public static class RecursiveDeleteResult {
        private final boolean directoryNoLongerExists;
        private final List<String> notDeletedEligibleItems;

        public RecursiveDeleteResult(boolean directoryNoLongerExists, List<String> notDeletedEligibleItems) {
            this.directoryNoLongerExists = directoryNoLongerExists;
            this.notDeletedEligibleItems = notDeletedEligibleItems;
        }

        public boolean isDirectoryNoLongerExists() {
            return this.directoryNoLongerExists;
        }

        public List<String> getNotDeletedEligibleItems() {
            return this.notDeletedEligibleItems;
        }
    }

    private class Committer {
        private final AtomicBoolean fileRenameCancelled = new AtomicBoolean(false);
        private final List<CompletableFuture<?>> fileRenameFutures = new CopyOnWriteArrayList();
        private final List<DirectoryDeletionTask> deletionTasksForFinish = new CopyOnWriteArrayList<DirectoryDeletionTask>();
        private final List<DirectoryCleanUpTask> cleanUpTasksForAbort = new CopyOnWriteArrayList<DirectoryCleanUpTask>();
        private final List<DirectoryRenameTask> renameTasksForAbort = new CopyOnWriteArrayList<DirectoryRenameTask>();
        private final List<CreateTableOperation> addTableOperations = new CopyOnWriteArrayList<CreateTableOperation>();
        private final List<AlterTableOperation> alterTableOperations = new CopyOnWriteArrayList<AlterTableOperation>();
        private final Map<SchemaTableName, PartitionAdder> partitionAdders = new ConcurrentHashMap<SchemaTableName, PartitionAdder>();
        private final List<AlterPartitionOperation> alterPartitionOperations = new CopyOnWriteArrayList<AlterPartitionOperation>();
        private final List<UpdateStatisticsOperation> updateStatisticsOperations = new CopyOnWriteArrayList<UpdateStatisticsOperation>();
        private final List<String> partitionNames = new ArrayList<String>();
        private final List<IrreversibleMetastoreOperation> metastoreDeleteOperations = new CopyOnWriteArrayList<IrreversibleMetastoreOperation>();
        private boolean deleteOnly = true;

        private Committer() {
        }

        private void prepareDropTable(HiveIdentity identity, SchemaTableName schemaTableName) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop table %s", schemaTableName), () -> SemiTransactionalHiveMetastore.this.delegate.dropTable(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName(), true)));
        }

        private void prepareAlterTable(HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, TableAndMore tableAndMore, String currentQueryId) {
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            String targetLocation = table.getStorage().getLocation();
            Table oldTable = SemiTransactionalHiveMetastore.this.delegate.getTable(identity, table.getDatabaseName(), table.getTableName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, "The table that this transaction modified was deleted in another transaction. " + table.getSchemaTableName()));
            String oldTableLocation = oldTable.getStorage().getLocation();
            Path oldTablePath = new Path(oldTableLocation);
            this.cleanExtraOutputFiles(hdfsContext, currentQueryId, tableAndMore);
            if (targetLocation.equals(oldTableLocation)) {
                String queryId = hdfsContext.getQueryId().orElseThrow(() -> new IllegalArgumentException("query ID not present"));
                Path oldTableStagingPath = new Path(oldTablePath.getParent(), "_temp_" + oldTablePath.getName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, oldTablePath, oldTableStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(hdfsContext, oldTableStagingPath, oldTablePath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldTableStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldTablePath));
            }
            Path currentPath = tableAndMore.getCurrentLocation().orElseThrow(() -> new IllegalArgumentException("location should be present for alter table"));
            Path targetPath = new Path(targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
            }
            this.alterTableOperations.add(new AlterTableOperation(tableAndMore.getIdentity(), tableAndMore.getTable(), oldTable, tableAndMore.getPrincipalPrivileges()));
            this.updateStatisticsOperations.add(new UpdateStatisticsOperation(tableAndMore.getIdentity(), table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), false));
        }

        private void prepareAddTable(HdfsEnvironment.HdfsContext context, TableAndMore tableAndMore, String queryId) {
            this.deleteOnly = false;
            this.cleanExtraOutputFiles(context, queryId, tableAndMore);
            Table table = tableAndMore.getTable();
            if (table.getTableType().equals(TableType.MANAGED_TABLE.name())) {
                String targetLocation = table.getStorage().getLocation();
                Preconditions.checkArgument((!targetLocation.isEmpty() ? 1 : 0) != 0, (Object)"target location is empty");
                Optional<Path> currentPath = tableAndMore.getCurrentLocation();
                Path targetPath = new Path(targetLocation);
                if (table.getPartitionColumns().isEmpty() && currentPath.isPresent()) {
                    if (!targetPath.equals((Object)currentPath.get())) {
                        SemiTransactionalHiveMetastore.renameDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath.get(), targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true)));
                    }
                } else if (HiveWriteUtils.pathExists(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath)) {
                    if (!currentPath.isPresent() || !currentPath.get().equals((Object)targetPath)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to create directory %s: target directory already exists", targetPath));
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(context, targetPath, true));
                    HiveWriteUtils.createDirectory(context, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
                }
            }
            this.addTableOperations.add(new CreateTableOperation(tableAndMore.getIdentity(), table, tableAndMore.getPrincipalPrivileges(), tableAndMore.isIgnoreExisting()));
            if (!HiveUtil.isPrestoView(table) && tableAndMore.isUpdateStats()) {
                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(tableAndMore.getIdentity(), table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), false));
            }
        }

        private void prepareInsertExistingTable(HdfsEnvironment.HdfsContext context, TableAndMore tableAndMore, String queryId) {
            Path currentPath;
            this.deleteOnly = false;
            Table table = tableAndMore.getTable();
            Path targetPath = new Path(table.getStorage().getLocation());
            if (!targetPath.equals((Object)(currentPath = tableAndMore.getCurrentLocation().get()))) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, context, currentPath, targetPath, tableAndMore.getFileNames().get(), this.cleanUpTasksForAbort, SemiTransactionalHiveMetastore.this.isVacuumIncluded);
            } else {
                this.cleanExtraOutputFiles(context, queryId, tableAndMore);
            }
            if (tableAndMore.isUpdateStats()) {
                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(tableAndMore.getIdentity(), table.getSchemaTableName(), Optional.empty(), tableAndMore.getStatisticsUpdate(), true));
            }
        }

        private void prepareDropPartition(HiveIdentity identity, SchemaTableName schemaTableName, List<String> partitionValues) {
            this.metastoreDeleteOperations.add(new IrreversibleMetastoreOperation(String.format("drop partition %s.%s %s", schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues), () -> SemiTransactionalHiveMetastore.this.delegate.dropPartition(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partitionValues, true)));
        }

        private void prepareAlterPartition(Table table, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, PartitionAndMore partitionAndMore, String currentQueryId) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            String targetLocation = partition.getStorage().getLocation();
            Optional<Partition> oldPartition = SemiTransactionalHiveMetastore.this.delegate.getPartition(identity, partition.getDatabaseName(), partition.getTableName(), partition.getValues());
            if (!oldPartition.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
            }
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(table, partition.getValues());
            PartitionStatistics oldPartitionStatistics = this.getExistingPartitionStatistics(identity, partition, partitionName);
            String oldPartitionLocation = oldPartition.get().getStorage().getLocation();
            Path oldPartitionPath = new Path(oldPartitionLocation);
            this.cleanExtraOutputFiles(hdfsContext, currentQueryId, partitionAndMore);
            if (targetLocation.equals(oldPartitionLocation)) {
                String queryId = hdfsContext.getQueryId().orElseThrow(() -> new IllegalArgumentException("query ID not present"));
                Path oldPartitionStagingPath = new Path(oldPartitionPath.getParent(), "_temp_" + oldPartitionPath.getName() + "_" + queryId);
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, oldPartitionPath, oldPartitionStagingPath, () -> this.renameTasksForAbort.add(new DirectoryRenameTask(hdfsContext, oldPartitionStagingPath, oldPartitionPath)));
                if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                    this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldPartitionStagingPath));
                }
            } else if (!SemiTransactionalHiveMetastore.this.skipDeletionForAlter) {
                this.deletionTasksForFinish.add(new DirectoryDeletionTask(hdfsContext, oldPartitionPath));
            }
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            if (!targetPath.equals((Object)currentPath)) {
                SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
            }
            this.alterPartitionOperations.add(new AlterPartitionOperation(partitionAndMore.getIdentity(), new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate()), new PartitionWithStatistics(oldPartition.get(), partitionName, oldPartitionStatistics)));
        }

        private PartitionStatistics getExistingPartitionStatistics(HiveIdentity identity, Partition partition, String partitionName) {
            try {
                PartitionStatistics statistics = SemiTransactionalHiveMetastore.this.closure.getPartitionStatistics(identity, partition.getDatabaseName(), partition.getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName);
                if (statistics == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_CONFLICT, String.format("The partition that this transaction modified was deleted in another transaction. %s %s", partition.getTableName(), partition.getValues()));
                }
                return statistics;
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode())) {
                    log.warn((Throwable)e, "Corrupted statistics found when altering partition. Table: %s.%s. Partition: %s", new Object[]{partition.getDatabaseName(), partition.getTableName(), partition.getValues()});
                    return PartitionStatistics.empty();
                }
                throw e;
            }
        }

        private void prepareAddPartition(Table table, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, PartitionAndMore partitionAndMore, String queryId, boolean isRenameRequired) {
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            String targetLocation = partition.getStorage().getLocation();
            Path currentPath = partitionAndMore.getCurrentLocation();
            Path targetPath = new Path(targetLocation);
            this.cleanExtraOutputFiles(hdfsContext, queryId, partitionAndMore);
            PartitionAdder partitionAdder = this.partitionAdders.computeIfAbsent(partition.getSchemaTableName(), ignored -> new PartitionAdder(partitionAndMore.getIdentity(), partition.getDatabaseName(), partition.getTableName(), SemiTransactionalHiveMetastore.this.delegate, SemiTransactionalHiveMetastore.this.partitionCommitBatchSize, this.updateStatisticsOperations));
            if (isRenameRequired) {
                if (HiveWriteUtils.pathExists(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath)) {
                    if (!targetPath.equals((Object)currentPath)) {
                        SemiTransactionalHiveMetastore.renameNewPartitionDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, currentPath, targetPath, this.cleanUpTasksForAbort);
                    }
                } else {
                    this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true));
                    HiveWriteUtils.createDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath);
                }
            }
            String partitionName = SemiTransactionalHiveMetastore.this.getPartitionName(table, partition.getValues());
            partitionAdder.addPartition(new PartitionWithStatistics(partition, partitionName, partitionAndMore.getStatisticsUpdate(), partitionAndMore.isUpdateStats()));
        }

        private void prepareInsertExistingPartition(Table table, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, PartitionAndMore partitionAndMore, String queryId) {
            Path currentPath;
            this.deleteOnly = false;
            Partition partition = partitionAndMore.getPartition();
            Path targetPath = new Path(partition.getStorage().getLocation());
            if (!targetPath.equals((Object)(currentPath = partitionAndMore.getCurrentLocation()))) {
                SemiTransactionalHiveMetastore.asyncRename(SemiTransactionalHiveMetastore.this.hdfsEnvironment, SemiTransactionalHiveMetastore.this.renameExecutor, this.fileRenameCancelled, this.fileRenameFutures, hdfsContext, currentPath, targetPath, partitionAndMore.getFileNames(), this.cleanUpTasksForAbort, SemiTransactionalHiveMetastore.this.isVacuumIncluded);
            } else {
                this.cleanExtraOutputFiles(hdfsContext, queryId, partitionAndMore);
            }
            if (partitionAndMore.isUpdateStats()) {
                this.updateStatisticsOperations.add(new UpdateStatisticsOperation(partitionAndMore.getIdentity(), partition.getSchemaTableName(), Optional.of(SemiTransactionalHiveMetastore.this.getPartitionName(table, partition.getValues())), partitionAndMore.getStatisticsUpdate(), true));
            }
        }

        private void executeCleanupTasksForAbort(Collection<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::getQueryId).collect(ImmutableSet.toImmutableSet());
            for (DirectoryCleanUpTask cleanUpTask : this.cleanUpTasksForAbort) {
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(cleanUpTask.getContext(), cleanUpTask.getPath(), queryIds, cleanUpTask.isDeleteEmptyDirectory(), "temporary directory commit abort");
            }
        }

        private void executeDeletionTasksForFinish() {
            for (DirectoryDeletionTask deletionTask : this.deletionTasksForFinish) {
                if (SemiTransactionalHiveMetastore.deleteRecursivelyIfExists(deletionTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, deletionTask.getPath())) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Error deleting directory %s", new Object[]{deletionTask.getPath().toString()});
            }
        }

        private void executeRenameTasksForAbort() {
            for (DirectoryRenameTask directoryRenameTask : this.renameTasksForAbort) {
                try {
                    if (!HiveWriteUtils.pathExists(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom())) continue;
                    SemiTransactionalHiveMetastore.renameDirectory(directoryRenameTask.getContext(), SemiTransactionalHiveMetastore.this.hdfsEnvironment, directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo(), () -> {});
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to undo rename of partition directory: %s to %s", new Object[]{directoryRenameTask.getRenameFrom(), directoryRenameTask.getRenameTo()});
                }
            }
        }

        private void pruneAndDeleteStagingDirectories(List<DeclaredIntentionToWrite> declaredIntentionsToWrite) {
            for (DeclaredIntentionToWrite declaredIntentionToWrite : declaredIntentionsToWrite) {
                if (declaredIntentionToWrite.getMode() != LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY) continue;
                Set queryIds = (Set)declaredIntentionsToWrite.stream().map(DeclaredIntentionToWrite::getQueryId).collect(ImmutableSet.toImmutableSet());
                Path path = declaredIntentionToWrite.getRootPath();
                SemiTransactionalHiveMetastore.this.recursiveDeleteFilesAndLog(declaredIntentionToWrite.getHdfsContext(), path, queryIds, true, "staging directory cleanup");
            }
        }

        private void waitForAsyncRenames() {
            for (CompletableFuture<?> fileRenameFuture : this.fileRenameFutures) {
                MoreFutures.getFutureValue(fileRenameFuture, PrestoException.class);
            }
        }

        private void waitForAsyncRenamesSuppressThrowables() {
            for (CompletableFuture<?> future : this.fileRenameFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    log.debug("Get future(%s) error", new Object[]{future.toString()});
                }
            }
        }

        private void cancelUnstartedAsyncRenames() {
            this.fileRenameCancelled.set(true);
        }

        private void executeAddTableOperations() {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                addTableOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                alterTableOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                alterPartitionOperation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
        }

        private void executeAddPartitionOperations() {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                partitionAdder.execute(SemiTransactionalHiveMetastore.this.hiveMetastoreClientService);
            }
        }

        private void executeUpdateStatisticsOperations() {
            ArrayList<UpdateStatisticsOperation> partitionUpdateStatisticsOperations = new ArrayList<UpdateStatisticsOperation>();
            HiveIdentity identity = null;
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                if (operation.partitionName.isPresent()) {
                    partitionUpdateStatisticsOperations.add(operation);
                    if (identity != null) continue;
                    identity = operation.identity;
                    continue;
                }
                operation.run(SemiTransactionalHiveMetastore.this.delegate);
            }
            if (partitionUpdateStatisticsOperations.size() > 0) {
                SchemaTableName schemaTableName = ((UpdateStatisticsOperation)partitionUpdateStatisticsOperations.get(0)).tableName;
                this.updatePartitionsStatistics(identity, SemiTransactionalHiveMetastore.this.delegate, schemaTableName, partitionUpdateStatisticsOperations);
            }
        }

        private void updatePartitionsStatistics(HiveIdentity identity, HiveMetastore metastore, SchemaTableName schemaTableName, List<UpdateStatisticsOperation> partitionUpdateStatisticsOperations) {
            ArrayList localPartitionNames = new ArrayList();
            HashMap<String, Function<PartitionStatistics, PartitionStatistics>> partNamesUpdateFunctionMap = new HashMap<String, Function<PartitionStatistics, PartitionStatistics>>();
            for (UpdateStatisticsOperation operation : partitionUpdateStatisticsOperations) {
                partNamesUpdateFunctionMap.put((String)operation.partitionName.get(), x$0 -> operation.updateStatistics(x$0));
                localPartitionNames.add(operation.partitionName.get());
            }
            if (localPartitionNames.size() == partNamesUpdateFunctionMap.size() && partitionUpdateStatisticsOperations.size() > 0) {
                metastore.updatePartitionsStatistics(identity, schemaTableName.getSchemaName(), schemaTableName.getTableName(), partNamesUpdateFunctionMap);
            }
        }

        private void undoAddPartitionOperations() {
            for (PartitionAdder partitionAdder : this.partitionAdders.values()) {
                List<List<String>> partitionsFailedToRollback = partitionAdder.rollback();
                if (partitionsFailedToRollback.isEmpty()) continue;
                SemiTransactionalHiveMetastore.this.logCleanupFailure("Failed to rollback: add_partition for partitions %s.%s %s", new Object[]{partitionAdder.getSchemaName(), partitionAdder.getTableName(), partitionsFailedToRollback.stream()});
            }
        }

        private void undoAddTableOperations() {
            for (CreateTableOperation addTableOperation : this.addTableOperations) {
                try {
                    addTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", new Object[]{addTableOperation.getDescription()});
                }
            }
        }

        private void undoAlterTableOperations() {
            for (AlterTableOperation alterTableOperation : this.alterTableOperations) {
                try {
                    alterTableOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", new Object[]{alterTableOperation.getDescription()});
                }
            }
        }

        private void undoAlterPartitionOperations() {
            for (AlterPartitionOperation alterPartitionOperation : this.alterPartitionOperations) {
                try {
                    alterPartitionOperation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", new Object[]{alterPartitionOperation.getDescription()});
                }
            }
        }

        private void undoUpdateStatisticsOperations() {
            for (UpdateStatisticsOperation operation : this.updateStatisticsOperations) {
                try {
                    operation.undo(SemiTransactionalHiveMetastore.this.delegate);
                }
                catch (Throwable throwable) {
                    SemiTransactionalHiveMetastore.this.logCleanupFailure(throwable, "failed to rollback: %s", new Object[]{operation.getDescription()});
                }
            }
        }

        private void executeIrreversibleMetastoreOperations() {
            ArrayList<String> failedIrreversibleOperationDescriptions = new ArrayList<String>();
            ArrayList<Throwable> suppressedExceptions = new ArrayList<Throwable>();
            boolean anySucceeded = false;
            for (IrreversibleMetastoreOperation irreversibleMetastoreOperation : this.metastoreDeleteOperations) {
                try {
                    irreversibleMetastoreOperation.run();
                    anySucceeded = true;
                }
                catch (Throwable t) {
                    failedIrreversibleOperationDescriptions.add(irreversibleMetastoreOperation.getDescription());
                    if (suppressedExceptions.size() >= 5) continue;
                    suppressedExceptions.add(t);
                }
            }
            if (!suppressedExceptions.isEmpty()) {
                StringBuilder message = new StringBuilder();
                if (this.deleteOnly && !anySucceeded) {
                    message.append("The following metastore delete operations failed: ");
                } else {
                    message.append("The transaction didn't commit cleanly. All operations other than the following delete operations were completed: ");
                }
                Joiner.on((String)"; ").appendTo(message, failedIrreversibleOperationDescriptions);
                PrestoException prestoException = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, message.toString());
                suppressedExceptions.forEach(prestoException::addSuppressed);
                throw prestoException;
            }
        }

        private void cleanExtraOutputFiles(HdfsEnvironment.HdfsContext hdfsContext, String queryId, TableAndMore tableAndMore) {
            if (!tableAndMore.isCleanExtraOutputFilesOnCommit()) {
                return;
            }
            Path tableLocation = tableAndMore.getCurrentLocation().orElseThrow(() -> new IllegalArgumentException("currentLocation expected to be set if isCleanExtraOutputFilesOnCommit is true"));
            List<String> files = tableAndMore.getFileNames().orElseThrow(() -> new IllegalArgumentException("fileNames expected to be set if isCleanExtraOutputFilesOnCommit is true"));
            SemiTransactionalHiveMetastore.cleanExtraOutputFiles(SemiTransactionalHiveMetastore.this.hdfsEnvironment, hdfsContext, queryId, tableLocation, (Set<String>)ImmutableSet.copyOf(files));
        }

        private void cleanExtraOutputFiles(HdfsEnvironment.HdfsContext hdfsContext, String queryId, PartitionAndMore partitionAndMore) {
            if (!partitionAndMore.isCleanExtraOutputFilesOnCommit()) {
                return;
            }
            Verify.verify((boolean)partitionAndMore.hasFileNames(), (String)"fileNames expected to be set if isCleanExtraOutputFilesOnCommit is true", (Object[])new Object[0]);
            SemiTransactionalHiveMetastore.cleanExtraOutputFiles(SemiTransactionalHiveMetastore.this.hdfsEnvironment, hdfsContext, queryId, partitionAndMore.getCurrentLocation(), (Set<String>)ImmutableSet.copyOf(partitionAndMore.getFileNames()));
        }

        private void renameStagingDir(HdfsEnvironment.HdfsContext hdfsContext, Path sourcePath, Path targetPath) {
            if (HiveWriteUtils.pathExists(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, targetPath)) {
                try {
                    if (!SemiTransactionalHiveMetastore.this.hdfsEnvironment.getFileSystem(hdfsContext, targetPath).delete(targetPath, false)) {
                        throw new IOException("delete returned false");
                    }
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to delete target dir %s ", targetPath), (Throwable)e);
                }
            }
            SemiTransactionalHiveMetastore.renameDirectory(hdfsContext, SemiTransactionalHiveMetastore.this.hdfsEnvironment, sourcePath, targetPath, () -> this.cleanUpTasksForAbort.add(new DirectoryCleanUpTask(hdfsContext, targetPath, true)));
        }
    }
}

