/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveViewNotSupportedException;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.plugin.hive.util.RetryDriver;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.SchemaAlreadyExistsException;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableAlreadyExistsException;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ThriftHiveMetastore
implements ThriftMetastore {
    private static final Logger LOGGER = Logger.get(ThriftHiveMetastore.class);
    private final ThriftMetastoreStats stats = new ThriftMetastoreStats();
    private final MetastoreLocator clientProvider;
    private final double backoffScaleFactor;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;
    private final Duration maxRetryTime;
    private final Duration maxWaitForLock;
    private final int maxRetries;
    private final boolean isRoleNameCaseSensitive;
    private final boolean impersonationEnabled;
    private final AtomicInteger chosenGetTableAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private volatile boolean metastoreKnownToSupportTableParamEqualsPredicate;
    private volatile boolean metastoreKnownToSupportTableParamLikePredicate;

    @Inject
    public ThriftHiveMetastore(MetastoreLocator metastoreLocator, ThriftHiveMetastoreConfig thriftConfig) {
        this.clientProvider = Objects.requireNonNull(metastoreLocator, "metastoreLocator is null");
        this.backoffScaleFactor = thriftConfig.getBackoffScaleFactor();
        this.minBackoffDelay = thriftConfig.getMinBackoffDelay();
        this.maxBackoffDelay = thriftConfig.getMaxBackoffDelay();
        this.maxRetryTime = thriftConfig.getMaxRetryTime();
        this.maxRetries = thriftConfig.getMaxRetries();
        this.maxWaitForLock = thriftConfig.getMaxWaitForTransactionLock();
        this.isRoleNameCaseSensitive = thriftConfig.isRoleNameCaseSensitive();
        this.impersonationEnabled = thriftConfig.isImpersonationEnabled();
    }

    @Managed
    @Flatten
    public ThriftMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> {
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List<String> list = client.getAllDatabases();
                    return list;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<Database> optional = Optional.of(client.getDatabase(databaseName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        Callable<List> getAllTables = this.stats.getGetAllTables().wrap(() -> {
            try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                List<String> list = client.getAllTables(databaseName);
                return list;
            }
        });
        Callable<Void> getDatabase = this.stats.getGetDatabase().wrap(() -> {
            try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                client.getDatabase(databaseName);
                Void void_ = null;
                return void_;
            }
        });
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                List tables = (List)getAllTables.call();
                if (tables.isEmpty()) {
                    getDatabase.call();
                }
                return Optional.of(tables);
            });
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<org.apache.hadoop.hive.metastore.api.Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> {
                org.apache.hadoop.hive.metastore.api.Table table = this.getTableFromMetastore(identity, databaseName, tableName);
                return Optional.of(table);
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private org.apache.hadoop.hive.metastore.api.Table getTableFromMetastore(HiveIdentity identity, String databaseName, String tableName) throws TException {
        return (org.apache.hadoop.hive.metastore.api.Table)this.alternativeCall(() -> this.createMetastoreClient(identity), this.chosenGetTableAlternative, client -> client.getTable(databaseName, tableName), client -> client.getTableWithCapabilities(databaseName, tableName));
    }

    private org.apache.hadoop.hive.metastore.api.Table getTableFromMetastore(String databaseName, String tableName) throws TException {
        return (org.apache.hadoop.hive.metastore.api.Table)this.alternativeCall(() -> this.createMetastoreClient(), this.chosenGetTableAlternative, client -> client.getTable(databaseName, tableName), client -> client.getTableWithCapabilities(databaseName, tableName));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ThriftMetastoreUtil.getSupportedColumnStatistics(type);
    }

    private static boolean isPrestoView(org.apache.hadoop.hive.metastore.api.Table table) {
        return "true".equals(table.getParameters().get("presto_view"));
    }

    @Override
    public PartitionStatistics getTableStatistics(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table) {
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        HiveBasicStatistics basicStatistics = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
        Map<String, HiveColumnStatistics> columnStatistics = this.getTableColumnStatistics(identity, table.getDbName(), table.getTableName(), dataColumns, basicStatistics.getRowCount());
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private Map<String, HiveColumnStatistics> getTableColumnStatistics(HiveIdentity identity, String databaseName, String tableName, List<String> columns, OptionalLong rowCount) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTableColumnStatistics", this.stats.getGetTableColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Map<String, HiveColumnStatistics> map = this.groupStatisticsByColumn(client.getTableColumnStatistics(databaseName, tableName, columns), rowCount);
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table, List<Partition> partitions) {
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        List partitionColumns = (List)table.getPartitionKeys().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        Map partitionBasicStatistics = (Map)partitions.stream().collect(ImmutableMap.toImmutableMap(partition -> FileUtils.makePartName((List)partitionColumns, (List)partition.getValues()), partition -> ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters())));
        Map partitionRowCounts = (Map)partitionBasicStatistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((HiveBasicStatistics)entry.getValue()).getRowCount()));
        Map<String, Map<String, HiveColumnStatistics>> partitionColumnStatistics = this.getPartitionColumnStatistics(identity, table.getDbName(), table.getTableName(), partitionBasicStatistics.keySet(), dataColumns, partitionRowCounts);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String partitionName : partitionBasicStatistics.keySet()) {
            HiveBasicStatistics basicStatistics = (HiveBasicStatistics)partitionBasicStatistics.get(partitionName);
            Map<String, HiveColumnStatistics> columnStatistics = partitionColumnStatistics.getOrDefault(partitionName, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
            result.put((Object)partitionName, (Object)new PartitionStatistics(basicStatistics, columnStatistics));
        }
        return result.build();
    }

    @Override
    public Optional<List<FieldSchema>> getFields(HiveIdentity identity, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(MetaException.class, UnknownTableException.class, UnknownDBException.class).stopOnIllegalExceptions().run("getFields", this.stats.getGetFields().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<ImmutableList> optional = Optional.of(ImmutableList.copyOf(client.getFields(databaseName, tableName)));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames, Map<String, OptionalLong> partitionRowCounts) {
        return (Map)this.getMetastorePartitionColumnStatistics(identity, databaseName, tableName, partitionNames, columnNames).entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.groupStatisticsByColumn((List)entry.getValue(), partitionRowCounts.getOrDefault(entry.getKey(), OptionalLong.empty()))));
    }

    private Map<String, List<ColumnStatisticsObj>> getMetastorePartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getPartitionColumnStatistics", this.stats.getGetPartitionColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Map<String, List<ColumnStatisticsObj>> map = client.getPartitionColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)partitionNames), columnNames);
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, HiveColumnStatistics> groupStatisticsByColumn(List<ColumnStatisticsObj> statistics, OptionalLong rowCount) {
        return (Map)statistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsObj::getColName, statisticsObj -> ThriftMetastoreUtil.fromMetastoreApiColumnStatistics(statisticsObj, rowCount)));
    }

    @Override
    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        org.apache.hadoop.hive.metastore.api.Table originalTable = this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        PartitionStatistics currentStatistics = this.getTableStatistics(identity, originalTable);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        org.apache.hadoop.hive.metastore.api.Table modifiedTable = originalTable.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedTable.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedTable.getParameters(), basicStatistics));
        this.alterTable(identity, databaseName, tableName, modifiedTable);
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable(modifiedTable);
        OptionalLong rowCount = basicStatistics.getRowCount();
        List metastoreColumnStatistics = (List)updatedStatistics.getColumnStatistics().entrySet().stream().map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), table.getColumn((String)entry.getKey()).get().getType(), (HiveColumnStatistics)entry.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setTableColumnStatistics(identity, databaseName, tableName, metastoreColumnStatistics);
        }
        Sets.SetView removedColumnStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedColumnStatistics.forEach(column -> this.deleteTableColumnStatistics(identity, databaseName, tableName, (String)column));
    }

    private void setTableColumnStatistics(HiveIdentity identity, String databaseName, String tableName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setTableColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.setTableColumnStatistics(databaseName, tableName, statistics);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deleteTableColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deleteTableColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.deleteTableColumnStatistics(databaseName, tableName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void updatePartitionStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        List<Partition> partitions = this.getPartitionsByNames(identity, databaseName, tableName, (List<String>)ImmutableList.of((Object)partitionName));
        if (partitions.size() != 1) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Metastore returned multiple partitions for name: " + partitionName);
        }
        org.apache.hadoop.hive.metastore.api.Table table = this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        PartitionStatistics currentStatistics = Objects.requireNonNull(this.getPartitionStatistics(identity, table, partitions).get(partitionName), "getPartitionStatistics() returned null");
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        Partition originalPartition = (Partition)Iterables.getOnlyElement(partitions);
        Partition modifiedPartition = originalPartition.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedPartition.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedPartition.getParameters(), basicStatistics));
        this.alterPartitionWithoutStatistics(identity, databaseName, tableName, modifiedPartition);
        this.updatePartitionColumnStatistics(identity, modifiedPartition, databaseName, tableName, partitionName, basicStatistics, currentStatistics, updatedStatistics);
    }

    @Override
    public synchronized void updatePartitionsStatistics(HiveIdentity identity, String databaseName, String tableName, Map<String, Function<PartitionStatistics, PartitionStatistics>> partNamesUpdateFunctionMap) {
        ImmutableList.Builder modifiedPartitionBuilder = ImmutableList.builder();
        ImmutableMap.Builder partitionInfoMapBuilder = ImmutableMap.builder();
        Optional<org.apache.hadoop.hive.metastore.api.Table> table = this.getTable(identity, databaseName, tableName);
        List<Partition> partitions = this.getPartitionsByNames(identity, databaseName, tableName, partNamesUpdateFunctionMap.keySet().stream().collect(Collectors.toList()));
        Map<String, PartitionStatistics> partitionsStatistics = this.getPartitionStatistics(identity, table.get(), partitions);
        if (partitions.size() != partitionsStatistics.size() || partitions.size() != partNamesUpdateFunctionMap.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Metastore returned multiple partitions");
        }
        List partColumns = (List)table.get().getPartitionKeys().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        for (int index = 0; index < partitions.size(); ++index) {
            String partitionName = FileUtils.makePartName((List)partColumns, (List)partitions.get(index).getValues());
            PartitionStatistics currentStatistics = Objects.requireNonNull(partitionsStatistics.get(partitionName), "getPartitionStatistics() returned null");
            PartitionStatistics updatedStatistics = partNamesUpdateFunctionMap.get(partitionName).apply(currentStatistics);
            Partition originalPartition = partitions.get(index);
            Partition modifiedPartition = originalPartition.deepCopy();
            HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
            modifiedPartition.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedPartition.getParameters(), basicStatistics));
            originalPartition.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(originalPartition.getParameters(), basicStatistics));
            modifiedPartitionBuilder.add((Object)modifiedPartition);
            partitionInfoMapBuilder.put((Object)partitionName, (Object)new PartitionInfo(basicStatistics, currentStatistics, originalPartition, updatedStatistics));
        }
        this.alterPartitionsWithoutStatistics(databaseName, tableName, (List<Partition>)modifiedPartitionBuilder.build());
        ImmutableMap partitionInfoMap = partitionInfoMapBuilder.build();
        partitionInfoMap.forEach((partName, partInfo) -> this.updatePartitionColumnStatistics(identity, ((PartitionInfo)partInfo).modifiedPartition, databaseName, tableName, (String)partName, ((PartitionInfo)partInfo).basicStatistics, ((PartitionInfo)partInfo).currentStatistics, ((PartitionInfo)partInfo).updatedStatistics));
    }

    private void updatePartitionColumnStatistics(HiveIdentity identity, Partition modifiedPartition, String databaseName, String tableName, String partitionName, HiveBasicStatistics basicStatistics, PartitionStatistics currentStatistics, PartitionStatistics updatedStatistics) {
        Map columns = (Map)modifiedPartition.getSd().getCols().stream().collect(ImmutableMap.toImmutableMap(FieldSchema::getName, schema -> HiveType.valueOf(schema.getType())));
        this.setPartitionColumnStatistics(identity, databaseName, tableName, partitionName, columns, updatedStatistics.getColumnStatistics(), basicStatistics.getRowCount());
        Sets.SetView removedStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedStatistics.forEach(column -> this.deletePartitionColumnStatistics(identity, databaseName, tableName, partitionName, (String)column));
    }

    private void setPartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, Map<String, HiveType> columns, Map<String, HiveColumnStatistics> columnStatistics, OptionalLong rowCount) {
        List metastoreColumnStatistics = (List)columnStatistics.entrySet().stream().filter(entry -> columns.containsKey(entry.getKey())).map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), (HiveType)columns.get(entry.getKey()), (HiveColumnStatistics)entry.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setPartitionColumnStatistics(identity, databaseName, tableName, partitionName, metastoreColumnStatistics);
        }
    }

    private void setPartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setPartitionColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.setPartitionColumnStatistics(databaseName, tableName, partitionName, statistics);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deletePartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deletePartitionColumnStatistics", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.deletePartitionColumnStatistics(databaseName, tableName, partitionName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("createRole", this.stats.getCreateRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.createRole(this.isRoleNameCaseSensitive ? role : role.toLowerCase(Locale.ENGLISH), grantor);
                    Object var5_5 = null;
                    return var5_5;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("dropRole", this.stats.getDropRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.dropRole(this.isRoleNameCaseSensitive ? role : role.toLowerCase(Locale.ENGLISH));
                    Object var4_4 = null;
                    return var4_4;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<String> listRoles() {
        try {
            return (Set)this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoles", this.stats.getListRoles().wrap(() -> {
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    ArrayList<String> roles = new ArrayList<String>();
                    for (String role : client.getRoleNames()) {
                        roles.add(this.isRoleNameCaseSensitive ? role : role.toLowerCase(Locale.ENGLISH));
                    }
                    ImmutableSet immutableSet = ImmutableSet.copyOf(roles);
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean withAdminOption, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.grantRole(role, grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), grantor.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantor.getType()), withAdminOption);
            }
        }
    }

    private void grantRole(String role, String granteeName, org.apache.hadoop.hive.metastore.api.PrincipalType granteeType, String grantorName, org.apache.hadoop.hive.metastore.api.PrincipalType grantorType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("grantRole", this.stats.getGrantRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.grantRole(this.isRoleNameCaseSensitive ? role : role.toLowerCase(Locale.ENGLISH), granteeType == org.apache.hadoop.hive.metastore.api.PrincipalType.ROLE && this.isRoleNameCaseSensitive ? granteeName : granteeName.toLowerCase(Locale.ENGLISH), granteeType, grantorType == org.apache.hadoop.hive.metastore.api.PrincipalType.ROLE && this.isRoleNameCaseSensitive ? grantorName : grantorName.toLowerCase(Locale.ENGLISH), grantorType, grantOption);
                    Object var9_9 = null;
                    return var9_9;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOptionFor, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.revokeRole(role, grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), adminOptionFor);
            }
        }
    }

    private void revokeRole(String role, String granteeName, org.apache.hadoop.hive.metastore.api.PrincipalType granteeType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("revokeRole", this.stats.getRevokeRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.revokeRole(this.isRoleNameCaseSensitive ? role : role.toLowerCase(Locale.ENGLISH), granteeType == org.apache.hadoop.hive.metastore.api.PrincipalType.ROLE && this.isRoleNameCaseSensitive ? granteeName : granteeName.toLowerCase(Locale.ENGLISH), granteeType, grantOption);
                    Object var7_7 = null;
                    return var7_7;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal sourcePrincipal) {
        try {
            return this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoleGrants", this.stats.getListRoleGrants().wrap(() -> {
                HivePrincipal principal = ThriftMetastoreUtil.applyRoleNameCaseSensitive(sourcePrincipal, this.isRoleNameCaseSensitive);
                try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Set<RoleGrant> set = ThriftMetastoreUtil.fromRolePrincipalGrants(client.listRoleGrants(principal.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(principal.getType())), this.isRoleNameCaseSensitive);
                    return set;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getGetAllViews().wrap(() -> Optional.of(this.getPrestoViews(databaseName))));
        }
        catch (UnknownDBException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getPrestoViews(String databaseName) throws TException {
        String filterWithEquals = "hive_filter_field_params__presto_view = \"true\"";
        String filterWithLike = "hive_filter_field_params__presto_view LIKE \"true\"";
        if (this.metastoreKnownToSupportTableParamEqualsPredicate) {
            try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                List<String> list = client.getTableNamesByFilter(databaseName, filterWithEquals);
                return list;
            }
        }
        if (this.metastoreKnownToSupportTableParamLikePredicate) {
            try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
                List<String> list = client.getTableNamesByFilter(databaseName, filterWithLike);
                return list;
            }
        }
        try (ThriftMetastoreClient client = this.clientProvider.createMetastoreClient();){
            List<String> views = client.getTableNamesByFilter(databaseName, filterWithEquals);
            this.metastoreKnownToSupportTableParamEqualsPredicate = true;
            List<String> list = views;
            return list;
        }
        catch (RuntimeException | TException firstException) {
            try (ThriftMetastoreClient client2 = this.clientProvider.createMetastoreClient();){
                List<String> views = client2.getTableNamesByFilter(databaseName, filterWithLike);
                this.metastoreKnownToSupportTableParamLikePredicate = true;
                List<String> list = views;
                return list;
            }
            catch (RuntimeException | TException secondException) {
                if (firstException == secondException) throw firstException;
                firstException.addSuppressed(secondException);
                throw firstException;
            }
        }
    }

    @Override
    public void createDatabase(HiveIdentity identity, Database database) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class).stopOnIllegalExceptions().run("createDatabase", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.createDatabase(database);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropDatabase(HiveIdentity identity, String databaseName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidOperationException.class).stopOnIllegalExceptions().run("dropDatabase", this.stats.getDropDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.dropDatabase(databaseName, true, false);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterDatabase(HiveIdentity identity, String databaseName, Database database) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterDatabase", this.stats.getAlterDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.alterDatabase(databaseName, database);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createTable(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.createTable(table);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(table.getDbName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.dropTable(databaseName, tableName, deleteData);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterTable(HiveIdentity identity, String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTable", this.stats.getAlterTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.getTable(identity, databaseName, tableName);
                    if (!source.isPresent()) {
                        throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                    }
                    client.alterTable(databaseName, tableName, table);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNames(HiveIdentity identity, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNames(databaseName, tableName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(HiveIdentity identity, String databaseName, String tableName, List<String> parts) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesPs().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNamesFiltered(databaseName, tableName, parts));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        List partitions = (List)partitionsWithStatistics.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).collect(ImmutableList.toImmutableList());
        this.addPartitionsWithoutStatistics(identity, databaseName, tableName, partitions);
        for (PartitionWithStatistics partitionWithStatistics : partitionsWithStatistics) {
            this.storePartitionColumnStatistics(identity, databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        }
    }

    private void addPartitionsWithoutStatistics(HiveIdentity identity, String databaseName, String tableName, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class, PrestoException.class).stopOnIllegalExceptions().run("addPartitions", this.stats.getAddPartitions().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    int partitionsAdded = client.addPartitions(partitions);
                    if (partitionsAdded != partitions.size()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, String.format("Hive metastore only added %s of %s partitions", partitionsAdded, partitions.size()));
                    }
                    Object var6_7 = null;
                    return var6_7;
                }
            }));
        }
        catch (AlreadyExistsException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("One or more partitions already exist for table '%s.%s'", databaseName, tableName), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("dropPartition", this.stats.getDropPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.dropPartition(databaseName, tableName, parts, deleteData);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        this.alterPartitionWithoutStatistics(identity, databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics));
        this.storePartitionColumnStatistics(identity, databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        this.dropExtraColumnStatisticsAfterAlterPartition(identity, databaseName, tableName, partitionWithStatistics);
    }

    private void alterPartitionWithoutStatistics(HiveIdentity identity, String databaseName, String tableName, Partition partition) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterPartition", this.stats.getAlterPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.alterPartition(databaseName, tableName, partition);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void alterPartitionsWithoutStatistics(String databaseName, String tableName, List<Partition> partitions) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterPartition", this.stats.getAlterPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.alterPartitions(databaseName, tableName, partitions);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), null);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void storePartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, PartitionWithStatistics partitionWithStatistics) {
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        Map<String, HiveColumnStatistics> columnStatistics = statistics.getColumnStatistics();
        if (columnStatistics.isEmpty()) {
            return;
        }
        Map columnTypes = (Map)partitionWithStatistics.getPartition().getColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType));
        this.setPartitionColumnStatistics(identity, databaseName, tableName, partitionName, columnTypes, columnStatistics, statistics.getBasicStatistics().getRowCount());
    }

    private void dropExtraColumnStatisticsAfterAlterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        List dataColumns = (List)partitionWithStatistics.getPartition().getColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        HashSet columnsWithMissingStatistics = new HashSet(dataColumns);
        columnsWithMissingStatistics.removeAll(partitionWithStatistics.getStatistics().getColumnStatistics().keySet());
        if (columnsWithMissingStatistics.isEmpty()) {
            return;
        }
        String partitionName = partitionWithStatistics.getPartitionName();
        List<ColumnStatisticsObj> statisticsToBeRemoved = this.getMetastorePartitionColumnStatistics(identity, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName), (List<String>)ImmutableList.copyOf(columnsWithMissingStatistics)).getOrDefault(partitionName, (List<ColumnStatisticsObj>)ImmutableList.of());
        for (ColumnStatisticsObj statistics : statisticsToBeRemoved) {
            this.deletePartitionColumnStatistics(identity, databaseName, tableName, partitionName, statistics.getColName());
        }
    }

    @Override
    public Optional<Partition> getPartition(HiveIdentity identity, String databaseName, String tableName, List<String> partitionValues) {
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartition", this.stats.getGetPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Optional<Partition> optional = Optional.of(client.getPartition(databaseName, tableName, partitionValues));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<Partition> getPartitionsByNames(HiveIdentity identity, String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    List<Partition> list = client.getPartitionsByNames(databaseName, tableName, partitionNames);
                    return list;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, HivePrincipal sourceGrantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> requestedPrivileges = privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        HivePrincipal grantee = ThriftMetastoreUtil.applyRoleNameCaseSensitive(sourceGrantee, this.isRoleNameCaseSensitive);
        try {
            this.retry().stopOnIllegalExceptions().run("grantTablePrivileges", this.stats.getGrantTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    Set<HivePrivilegeInfo> existingPrivileges = this.listTablePrivileges(databaseName, tableName, grantee);
                    HashSet<PrivilegeGrantInfo> privilegesToGrant = new HashSet<PrivilegeGrantInfo>(requestedPrivileges);
                    Iterator iterator = privilegesToGrant.iterator();
                    while (iterator.hasNext()) {
                        HivePrivilegeInfo requestedPrivilege = (HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege((PrivilegeGrantInfo)iterator.next(), Optional.empty()));
                        for (HivePrivilegeInfo existingPrivilege : existingPrivileges) {
                            if (requestedPrivilege.isContainedIn(existingPrivilege)) {
                                iterator.remove();
                                continue;
                            }
                            if (!existingPrivilege.isContainedIn(requestedPrivilege)) continue;
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Granting %s WITH GRANT OPTION is not supported while %s possesses %s", requestedPrivilege.getHivePrivilege().name(), grantee, requestedPrivilege.getHivePrivilege().name()));
                        }
                    }
                    if (privilegesToGrant.isEmpty()) {
                        Object var10_12 = null;
                        return var10_12;
                    }
                    metastoreClient.grantPrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToGrant));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, HivePrincipal sourceGrantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> requestedPrivileges = privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        HivePrincipal grantee = ThriftMetastoreUtil.applyRoleNameCaseSensitive(sourceGrantee, this.isRoleNameCaseSensitive);
        try {
            this.retry().stopOnIllegalExceptions().run("revokeTablePrivileges", this.stats.getRevokeTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    Set existingHivePrivileges = this.listTablePrivileges(databaseName, tableName, grantee).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(Collectors.toSet());
                    Set<PrivilegeGrantInfo> privilegesToRevoke = requestedPrivileges.stream().filter(privilegeGrantInfo -> existingHivePrivileges.contains((Object)((HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege(privilegeGrantInfo, Optional.empty()))).getHivePrivilege())).collect(Collectors.toSet());
                    if (privilegesToRevoke.isEmpty()) {
                        Object var9_11 = null;
                        return var9_11;
                    }
                    metastoreClient.revokePrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToRevoke));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, HivePrincipal sourcePrincipal) {
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("listTablePrivileges", this.stats.getListTablePrivileges().wrap(() -> {
                org.apache.hadoop.hive.metastore.api.Table table = this.getTableFromMetastore(databaseName, tableName);
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<HiveObjectPrivilege> hiveObjectPrivilegeList;
                    ImmutableSet.Builder privileges = ImmutableSet.builder();
                    HivePrincipal principal = ThriftMetastoreUtil.applyRoleNameCaseSensitive(sourcePrincipal, this.isRoleNameCaseSensitive);
                    if (principal == null) {
                        hiveObjectPrivilegeList = client.listPrivileges(null, null, new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    } else {
                        if (principal.getType() == PrincipalType.USER && table.getOwner().equals(principal.getName())) {
                            privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, principal, principal));
                        }
                        hiveObjectPrivilegeList = client.listPrivileges(principal.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(principal.getType()), new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    }
                    for (HiveObjectPrivilege hiveObjectPrivilege : hiveObjectPrivilegeList) {
                        HivePrincipal grantee = new HivePrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(hiveObjectPrivilege.getPrincipalType()), hiveObjectPrivilege.getPrincipalName());
                        privileges.addAll(ThriftMetastoreUtil.parsePrivilege(hiveObjectPrivilege.getGrantInfo(), Optional.of(ThriftMetastoreUtil.applyRoleNameCaseSensitive(grantee, this.isRoleNameCaseSensitive))));
                    }
                    ImmutableSet immutableSet = privileges.build();
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    @Override
    public long openTransaction(HiveIdentity identity) {
        Preconditions.checkArgument((identity.getUsername().map(String::isEmpty).orElse(true) == false ? 1 : 0) != 0, (Object)"User should be provided to open transaction");
        try {
            return this.retry().stopOnIllegalExceptions().run("openTransaction", this.stats.getOpenTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    Long l = metastoreClient.openTransaction(identity.getUsername().get());
                    return l;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void commitTransaction(HiveIdentity identity, long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().stopOn(TxnAbortedException.class).run("commitTransaction", this.stats.getCommitTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    metastoreClient.commitTransaction(transactionId);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void abortTransaction(HiveIdentity identity, long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().run("abortTransaction", this.stats.getCommitTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    metastoreClient.abortTransaction(transactionId);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().run("sendTransactionHeartbeat", () -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    metastoreClient.sendTransactionHeartbeat(transactionId);
                }
                return null;
            });
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        DataOperationType operationType = DataOperationType.SELECT;
        this.acquireLock(identity, queryId, transactionId, fullTables, partitions, operationType);
    }

    @Override
    public void acquireLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions, DataOperationType operationType) {
        Preconditions.checkArgument((identity.getUsername().map(String::isEmpty).orElse(true) == false ? 1 : 0) != 0, (Object)"User should be provided to acquire locks");
        Objects.requireNonNull(queryId, "queryId is null");
        if (fullTables.isEmpty() && partitions.isEmpty()) {
            return;
        }
        LockRequestBuilder request = new LockRequestBuilder(queryId).setTransactionId(transactionId).setUser(identity.getUsername().get());
        for (SchemaTableName table : fullTables) {
            request.addLockComponent(ThriftHiveMetastore.createLockComponent(table, Optional.empty(), operationType));
        }
        for (HivePartition partition : partitions) {
            request.addLockComponent(ThriftHiveMetastore.createLockComponent(partition.getTableName(), Optional.of(partition.getPartitionId()), operationType));
        }
        LockRequest lockRequest = request.build();
        try {
            LockResponse response = this.retry().stopOn(NoSuchTxnException.class, TxnAbortedException.class, MetaException.class).run("acquireLock", this.stats.getAcquireLock().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    LockResponse lockResponse = metastoreClient.acquireLock(lockRequest);
                    return lockResponse;
                }
            }));
            long waitStart = System.nanoTime();
            while (response.getState() == LockState.WAITING) {
                long lockId = response.getLockid();
                if (Duration.nanosSince((long)waitStart).compareTo(this.maxWaitForLock) > 0) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_LOCK_NOT_ACQUIRED, String.format("Timed out waiting for lock %d in hive transaction %s for query %s", lockId, transactionId, queryId));
                }
                LOGGER.debug("Waiting for lock %d in hive transaction %s for query %s", new Object[]{lockId, transactionId, queryId});
                response = this.retry().stopOn(NoSuchTxnException.class, NoSuchLockException.class, TxnAbortedException.class, MetaException.class).run("checkLock", this.stats.getCheckLock().wrap(() -> {
                    try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                        LockResponse lockResponse = metastoreClient.checkLock(lockId);
                        return lockResponse;
                    }
                }));
            }
            if (response.getState() != LockState.ACQUIRED) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_LOCK_NOT_ACQUIRED, "Could not acquire lock. Lock in state " + response.getState());
            }
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private static LockComponent createLockComponent(SchemaTableName table, Optional<String> partitionName, DataOperationType operationType) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        LockComponentBuilder builder = new LockComponentBuilder();
        builder.setOperationType(operationType);
        switch (operationType) {
            case SELECT: 
            case INSERT: {
                builder.setShared();
                break;
            }
            case DELETE: 
            case UPDATE: {
                builder.setSemiShared();
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, "Unexpected operationType to aquireLock " + operationType);
            }
        }
        builder.setDbName(table.getSchemaName());
        builder.setTableName(table.getTableName());
        Objects.requireNonNull(partitionName, "partitionName is null").ifPresent(arg_0 -> ((LockComponentBuilder)builder).setPartitionName(arg_0));
        builder.setIsTransactional(true);
        return builder.build();
    }

    @Override
    public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId, boolean isVacuum) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getValidWriteIds", this.stats.getValidWriteIds().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    String string = metastoreClient.getValidWriteIds((List)tables.stream().map(table -> String.format("%s.%s", table.getSchemaName(), table.getTableName())).collect(ImmutableList.toImmutableList()), currentTransactionId, isVacuum);
                    return string;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to open transaction. Transactional tables support require Hive metastore version at least 3.0", (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public long getTableWriteId(String dbName, String tableName, long transactionId) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getTableWriteId", this.stats.getTableWriteId().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    Long l = metastoreClient.getTableWriteId(dbName, tableName, transactionId);
                    return l;
                }
            }));
        }
        catch (TException e) {
            if (e.getMessage().contains("Invalid method name")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Transactional tables support require Hive metastore version at least 3.0");
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) {
        try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
            ShowLocksResponse showLocksResponse = metastoreClient.showLocks(rqst);
            return showLocksResponse;
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getConfigValueFromServer", () -> {
                try (ThriftMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    Optional<String> optional = Optional.ofNullable(metastoreClient.get_config_value(name, null));
                    return optional;
                }
            });
        }
        catch (ConfigValSecurityException e) {
            LOGGER.debug((Throwable)e, "Could not fetch value for config '%s' from Hive", new Object[]{name});
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private PrivilegeBag buildPrivilegeBag(String databaseName, String tableName, HivePrincipal grantee, Set<PrivilegeGrantInfo> privilegeGrantInfos) {
        ImmutableList.Builder privilegeBagBuilder = ImmutableList.builder();
        for (PrivilegeGrantInfo privilegeGrantInfo : privilegeGrantInfos) {
            privilegeBagBuilder.add((Object)new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null), grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), privilegeGrantInfo, "SQL"));
        }
        return new PrivilegeBag((List)privilegeBagBuilder.build());
    }

    private boolean containsAllPrivilege(Set<PrivilegeGrantInfo> requestedPrivileges) {
        return requestedPrivileges.stream().anyMatch(privilege -> privilege.getPrivilege().equalsIgnoreCase("all"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeVarargs
    private final <T> T alternativeCall(ClientSupplier clientSupplier, AtomicInteger chosenAlternative, Call<T> ... alternatives) throws TException {
        Preconditions.checkArgument((alternatives.length > 0 ? 1 : 0) != 0, (Object)"No alternatives");
        int chosen = chosenAlternative.get();
        Preconditions.checkArgument((chosen == Integer.MAX_VALUE || 0 <= chosen && chosen < alternatives.length ? 1 : 0) != 0, (String)"Bad chosen alternative value: %s", (int)chosen);
        if (chosen != Integer.MAX_VALUE) {
            try (ThriftMetastoreClient client = clientSupplier.createMetastoreClient();){
                T t = alternatives[chosen].callOn(client);
                return t;
            }
        }
        Throwable firstException = null;
        int i = 0;
        while (true) {
            if (i >= alternatives.length) {
                Verify.verifyNotNull(firstException);
                Throwables.propagateIfPossible(firstException, TException.class);
                throw ThriftHiveMetastore.propagate(firstException);
            }
            int position = i;
            try (ThriftMetastoreClient client = clientSupplier.createMetastoreClient();){
                T result = alternatives[i].callOn(client);
                chosenAlternative.updateAndGet(currentChosen -> Math.min(currentChosen, position));
                T t = result;
                return t;
            }
            catch (RuntimeException | TException exception) {
                if (firstException == null) {
                    firstException = exception;
                } else if (firstException != exception) {
                    firstException.addSuppressed(exception);
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private ThriftMetastoreClient createMetastoreClient() throws TException {
        return this.clientProvider.createMetastoreClient();
    }

    private ThriftMetastoreClient createMetastoreClient(HiveIdentity identity) throws TException {
        ThriftMetastoreClient client = this.createMetastoreClient();
        if (!this.impersonationEnabled) {
            return client;
        }
        ThriftHiveMetastore.setMetastoreUserOrClose(client, identity.getUsername().orElseThrow(() -> new IllegalStateException("End-user name should exist when metastore impersonation is enabled")));
        return client;
    }

    private static void setMetastoreUserOrClose(ThriftMetastoreClient client, String username) throws TException {
        try {
            client.setUGI(username);
        }
        catch (Throwable t) {
            try {
                ThriftMetastoreClient ignored = client;
                Throwable throwable = null;
                try {
                    try {
                        throw t;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException e) {
                LOGGER.error("setMetastoreUserOrClose error : %s", new Object[]{e.getMessage()});
            }
        }
    }

    protected RetryDriver retry() {
        return RetryDriver.retry().exponentialBackoff(this.minBackoffDelay, this.maxBackoffDelay, this.maxRetryTime, this.backoffScaleFactor).maxAttempts(this.maxRetries + 1).stopOn(PrestoException.class);
    }

    protected static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }

    @FunctionalInterface
    private static interface Call<T> {
        public T callOn(ThriftMetastoreClient var1) throws TException;
    }

    @FunctionalInterface
    private static interface ClientSupplier {
        public ThriftMetastoreClient createMetastoreClient() throws TException;
    }

    private class PartitionInfo {
        private final HiveBasicStatistics basicStatistics;
        private final PartitionStatistics currentStatistics;
        private final Partition modifiedPartition;
        private final PartitionStatistics updatedStatistics;

        PartitionInfo(HiveBasicStatistics basicStatistics, PartitionStatistics currentStatistics, Partition modifiedPartition, PartitionStatistics updatedStatistics) {
            this.basicStatistics = basicStatistics;
            this.currentStatistics = currentStatistics;
            this.modifiedPartition = modifiedPartition;
            this.updatedStatistics = updatedStatistics;
        }
    }
}

