/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.hetu.core.common.util.SslSocketUtil;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.prestosql.plugin.hive.metastore.MetastoreClientFactory;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.Transport;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import org.apache.thrift.transport.TTransportException;

public class ThriftMetastoreClientFactory
implements MetastoreClientFactory {
    private Optional<SSLContext> sslContext;
    private Optional<HostAndPort> socksProxy;
    private int timeoutMillis;
    private HiveMetastoreAuthentication metastoreAuthentication;
    private String hostname;

    public ThriftMetastoreClientFactory(Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, Duration timeout, HiveMetastoreAuthentication metastoreAuthentication, String hostname) {
        this.init(sslContext, socksProxy, timeout, metastoreAuthentication, hostname);
    }

    @Inject
    public ThriftMetastoreClientFactory(HiveConfig config, HiveMetastoreAuthentication metastoreAuthentication, NodeManager nodeManager) {
        try {
            this.init(SslSocketUtil.buildSslContext((boolean)config.isTlsEnabled()), Optional.ofNullable(config.getMetastoreSocksProxy()), config.getMetastoreTimeout(), metastoreAuthentication, nodeManager.getCurrentNode().getHost());
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e.getMessage());
        }
    }

    public ThriftMetastoreClientFactory(HiveConfig config, HiveMetastoreAuthentication metastoreAuthentication) {
        try {
            this.init(SslSocketUtil.buildSslContext((boolean)config.isTlsEnabled()), Optional.ofNullable(config.getMetastoreSocksProxy()), config.getMetastoreTimeout(), metastoreAuthentication, "localhost");
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e.getMessage());
        }
    }

    @Override
    public ThriftMetastoreClient create(HostAndPort address) throws TTransportException {
        return new ThriftHiveMetastoreClient(Transport.create(address, this.sslContext, this.socksProxy, this.timeoutMillis, this.metastoreAuthentication), this.hostname);
    }

    private void init(Optional<SSLContext> sslContext, Optional<HostAndPort> socksProxy, Duration timeout, HiveMetastoreAuthentication metastoreAuthentication, String hostname) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext is null");
        this.socksProxy = Objects.requireNonNull(socksProxy, "socksProxy is null");
        this.timeoutMillis = Math.toIntExact(timeout.toMillis());
        this.metastoreAuthentication = Objects.requireNonNull(metastoreAuthentication, "metastoreAuthentication is null");
        this.hostname = Objects.requireNonNull(hostname, "hostname is null");
    }
}

