/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.ForCachingHiveMetastore;
import io.prestosql.plugin.hive.ForRecordingHiveMetastore;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.metastore.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreClientFactory;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.RecordingHiveMetastore;
import io.prestosql.plugin.hive.metastore.WriteHiveMetastoreRecordingProcedure;
import io.prestosql.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.ThriftConstants;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.procedure.Procedure;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftMetastoreModule
extends AbstractConfigurationAwareModule {
    private static final Logger log = Logger.get(ThriftMetastoreModule.class);

    protected void setup(Binder binder) {
        MetastoreConfig config = (MetastoreConfig)this.buildConfigObject(MetastoreConfig.class);
        try {
            if (config.getMetastoreClientFactoryImp().isEmpty()) {
                log.info("Binding default implementation of MetastoreClientFactory.");
                binder.bind(ThriftMetastoreClientFactory.class).in(Scopes.SINGLETON);
                binder.bind(MetastoreClientFactory.class).to(ThriftMetastoreClientFactory.class).in(Scopes.SINGLETON);
            } else {
                if (!ThriftConstants.WHITE_LIST_FOR_METASTORECLIENTFACTORY_CLASS.contains(config.getMetastoreClientFactoryImp().trim())) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Found illegal class when binding MetastoreClientFactory.");
                }
                log.info("Binding MetastoreClientFactory.class to %s", new Object[]{config.getMetastoreClientFactoryImp().trim()});
                binder.bind(MetastoreClientFactory.class).to(Class.forName(config.getMetastoreClientFactoryImp().trim())).in(Scopes.SINGLETON);
            }
            binder.bind(MetastoreLocator.class).to(StaticMetastoreLocator.class).in(Scopes.SINGLETON);
            if (config.getThriftMetastoreImp().isEmpty()) {
                log.info("Binding default implementation of ThriftMetastore.");
                binder.bind(ThriftMetastore.class).to(ThriftHiveMetastore.class).in(Scopes.SINGLETON);
            } else {
                if (!ThriftConstants.WHITE_LIST_FOR_THRIFTMETASTORE_CLASS.contains(config.getThriftMetastoreImp().trim())) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Found illegal class when binding ThriftMetastore.");
                }
                log.info("Binding ThriftMetastore.class to %s", new Object[]{config.getThriftMetastoreImp().trim()});
                binder.bind(ThriftMetastore.class).to(Class.forName(config.getThriftMetastoreImp().trim())).in(Scopes.SINGLETON);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to bind classes which specified in MetaStore configuration. error: %s", new Object[]{e.getLocalizedMessage()});
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to bind classes which specified in MetaStore configuration");
        }
        ConfigBinder.configBinder((Binder)binder).bindConfig(ThriftHiveMetastoreConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticMetastoreConfig.class);
        if (((HiveConfig)this.buildConfigObject(HiveConfig.class)).getRecordingPath() != null) {
            binder.bind(HiveMetastore.class).annotatedWith(ForRecordingHiveMetastore.class).to(BridgingHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(HiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            binder.bind(RecordingHiveMetastore.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(RecordingHiveMetastore.class).withGeneratedName();
            Multibinder procedures = Multibinder.newSetBinder((Binder)binder, Procedure.class);
            procedures.addBinding().toProvider(WriteHiveMetastoreRecordingProcedure.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(HiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(BridgingHiveMetastore.class).in(Scopes.SINGLETON);
        }
        binder.bind(HiveMetastore.class).to(CachingHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ThriftMetastore.class).as(generator -> generator.generatedNameOf(ThriftHiveMetastore.class));
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
    }
}

