/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import java.util.Objects;

public class OrcAcidRowId
implements Comparable {
    private static final int ORIGINAL_TRANSACTION_INDEX = 0;
    private static final int BUCKET_ID_INDEX = 1;
    private static final int ROW_ID_INDEX = 2;
    private long originalTransaction;
    private int bucket;
    private long rowId;

    public OrcAcidRowId(long originalTransaction, int bucket, long rowId) {
        this.set(originalTransaction, bucket, rowId);
    }

    void set(Page page, int position) {
        this.set(BigintType.BIGINT.getLong(page.getBlock(0), position), (int)IntegerType.INTEGER.getLong(page.getBlock(1), position), BigintType.BIGINT.getLong(page.getBlock(2), position));
    }

    void set(long originalTransaction, int bucket, long rowId) {
        this.originalTransaction = originalTransaction;
        this.bucket = bucket;
        this.rowId = rowId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrcAcidRowId other = (OrcAcidRowId)o;
        return this.originalTransaction == other.originalTransaction && this.bucket == other.bucket && this.rowId == other.rowId;
    }

    public long getOriginalTransaction() {
        return this.originalTransaction;
    }

    public int getBucket() {
        return this.bucket;
    }

    public long getRowId() {
        return this.rowId;
    }

    public int hashCode() {
        return Objects.hash(this.originalTransaction, this.bucket, this.rowId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("originalTransaction", this.originalTransaction).add("bucket", this.bucket).add("rowId", this.rowId).toString();
    }

    public int compareTo(Object o) {
        OrcAcidRowId other = (OrcAcidRowId)o;
        if (this.equals(other)) {
            return 0;
        }
        if (this.originalTransaction == other.originalTransaction && this.originalTransaction == 0L) {
            return this.rowId < other.rowId ? -1 : (this.rowId > other.rowId ? 1 : 0);
        }
        if (this.originalTransaction != other.originalTransaction) {
            return Long.compare(this.originalTransaction, other.originalTransaction);
        }
        if (this.bucket != other.bucket) {
            return Integer.compare(this.bucket, other.bucket);
        }
        return Long.compare(this.rowId, other.rowId);
    }
}

