/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import io.airlift.log.Logger;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ConnectorPageSource;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class OrcConcatPageSource
implements ConnectorPageSource {
    private static final Logger log = Logger.get(OrcConcatPageSource.class);
    private final List<ConnectorPageSource> pageSources;
    private final Iterator<Page> concatPageIterator;
    private boolean closed;

    public OrcConcatPageSource(List<ConnectorPageSource> pargeSources) {
        this.pageSources = pargeSources;
        List sourceIterators = this.pageSources.stream().map(source -> new AbstractIterator<Page>(){

            protected Page computeNext() {
                Page nextPage;
                do {
                    if ((nextPage = source.getNextPage()) != null) continue;
                    if (source.isFinished()) {
                        return (Page)this.endOfData();
                    }
                    return null;
                } while (nextPage.getPositionCount() == 0);
                return nextPage;
            }
        }).collect(Collectors.toList());
        this.concatPageIterator = Iterators.concat(sourceIterators.iterator());
        this.closed = false;
    }

    public long getCompletedBytes() {
        return this.pageSources.stream().mapToLong(ConnectorPageSource::getCompletedBytes).sum();
    }

    public long getReadTimeNanos() {
        return this.pageSources.get(0).getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        if (!this.concatPageIterator.hasNext()) {
            this.close();
            return null;
        }
        return this.concatPageIterator.next();
    }

    public long getSystemMemoryUsage() {
        return this.pageSources.get(0).getSystemMemoryUsage();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.pageSources.stream().forEach(ps -> {
            try {
                ps.close();
            }
            catch (IOException | RuntimeException e) {
                log.warn("failed to close page source");
            }
        });
        this.closed = true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    @VisibleForTesting
    public ConnectorPageSource getConnectorPageSource() {
        return this.pageSources.get(0);
    }
}

