/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSource;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class OrcDeleteDeltaPageSourceFactory {
    private final String sessionUser;
    private final Configuration configuration;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final DataSize streamBufferSize;
    private final DataSize maxReadBlockSize;
    private final DataSize tinyStripeThreshold;
    private final boolean lazyReadSmallRanges;
    private final boolean orcBloomFiltersEnabled;

    public OrcDeleteDeltaPageSourceFactory(String sessionUser, Configuration configuration, HdfsEnvironment hdfsEnvironment, DataSize maxMergeDistance, DataSize maxBufferSize, DataSize streamBufferSize, DataSize maxReadBlockSize, DataSize tinyStripeThreshold, boolean lazyReadSmallRanges, boolean orcBloomFiltersEnabled, FileFormatDataSourceStats stats) {
        this.sessionUser = Objects.requireNonNull(sessionUser, "sessionUser is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.streamBufferSize = Objects.requireNonNull(streamBufferSize, "streamBufferSize is null");
        this.maxReadBlockSize = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.lazyReadSmallRanges = Objects.requireNonNull(Boolean.valueOf(lazyReadSmallRanges), "lazyReadSmallRanges is null");
        this.orcBloomFiltersEnabled = Objects.requireNonNull(Boolean.valueOf(orcBloomFiltersEnabled), "orcBloomFiltersEnabled is null");
    }

    public OrcDeleteDeltaPageSource createPageSource(Path path, long fileSize, long lastModifiedTime) {
        return new OrcDeleteDeltaPageSource(path, fileSize, this.sessionUser, this.configuration, this.hdfsEnvironment, this.maxMergeDistance, this.maxBufferSize, this.streamBufferSize, this.maxReadBlockSize, this.tinyStripeThreshold, this.lazyReadSmallRanges, this.orcBloomFiltersEnabled, this.stats, lastModifiedTime);
    }
}

