/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.WriteIdInfo;
import io.prestosql.plugin.hive.orc.OrcAcidRowId;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;

@NotThreadSafe
public class OrcDeletedRows {
    private final String sourceFileName;
    private final DeleteDeltaLocations deleteDeltaLocations;
    private final OrcDeleteDeltaPageSourceFactory pageSourceFactory;
    private final String sessionUser;
    private final Configuration configuration;
    private final HdfsEnvironment hdfsEnvironment;
    Optional<Long> startRowOffsetOfFile;
    private final Pattern originalFilePattern = Pattern.compile("[0-9]+_[0-9]+");
    private final Pattern originalCopyFilePattern = Pattern.compile("[0-9]+_[0-9]+_copy_[0-9]+");
    private final String bucketPrefix = "bucket_";
    private final List<ConnectorPageSource> pageSources = new ArrayList<ConnectorPageSource>();
    private Iterator<Page> sortedRowsIterator;
    private Page currentPage;
    private int currentPageOffset;
    private OrcAcidRowId deletedRowId = new OrcAcidRowId(0L, 0, 0L);

    public OrcDeletedRows(String sourceFileName, Optional<DeleteDeltaLocations> deleteDeltaLocations, OrcDeleteDeltaPageSourceFactory pageSourceFactory, String sessionUser, Configuration configuration, HdfsEnvironment hdfsEnvironment, Optional<Long> startRowOffsetOfFile) {
        this.sourceFileName = sourceFileName;
        this.pageSourceFactory = pageSourceFactory;
        this.sessionUser = sessionUser;
        this.configuration = configuration;
        this.hdfsEnvironment = hdfsEnvironment;
        this.deleteDeltaLocations = deleteDeltaLocations.isPresent() ? deleteDeltaLocations.get() : null;
        this.startRowOffsetOfFile = startRowOffsetOfFile;
    }

    public MaskDeletedRowsFunction getMaskDeletedRowsFunction(Page sourcePage, Optional<Long> pageRowOffset) {
        return new MaskDeletedRowsFunction(sourcePage, pageRowOffset);
    }

    private boolean isDeleted(OrcAcidRowId sourcePageRowId) {
        if (this.sortedRowsIterator == null) {
            for (WriteIdInfo deleteDeltaInfo : this.deleteDeltaLocations.getDeleteDeltas()) {
                Path path = this.createPath(this.deleteDeltaLocations.getPartitionLocation(), deleteDeltaInfo, this.sourceFileName);
                try {
                    FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(this.sessionUser, path, this.configuration);
                    FileStatus fileStatus = this.hdfsEnvironment.doAs(this.sessionUser, () -> fileSystem.getFileStatus(path));
                    this.pageSources.add(this.pageSourceFactory.createPageSource(fileStatus.getPath(), fileStatus.getLen(), fileStatus.getModificationTime()));
                }
                catch (FileNotFoundException ignored) {
                }
                catch (PrestoException e) {
                    throw e;
                }
                catch (OrcCorruptionException e) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Failed to read ORC file: %s", path), (Throwable)e);
                }
                catch (IOException | RuntimeException e) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read ORC file: %s", path), (Throwable)e);
                }
            }
            ImmutableList columnTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT);
            ImmutableList sortFields = ImmutableList.of((Object)0, (Object)1, (Object)2);
            ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST);
            this.sortedRowsIterator = HiveUtil.getMergeSortedPages(this.pageSources, (List<Type>)columnTypes, (List<Integer>)sortFields, (List<SortOrder>)sortOrders);
        }
        do {
            if (this.currentPage == null || this.currentPageOffset >= this.currentPage.getPositionCount()) {
                this.currentPage = null;
                this.currentPageOffset = 0;
                if (this.sortedRowsIterator.hasNext()) {
                    this.currentPage = this.sortedRowsIterator.next();
                } else {
                    return false;
                }
            }
            do {
                this.deletedRowId.set(this.currentPage, this.currentPageOffset);
                if (this.deletedRowId.compareTo(sourcePageRowId) == 0) {
                    return true;
                }
                if (this.deletedRowId.compareTo(sourcePageRowId) > 0) {
                    return false;
                }
                ++this.currentPageOffset;
            } while (this.currentPageOffset < this.currentPage.getPositionCount());
        } while (this.sortedRowsIterator.hasNext());
        return false;
    }

    private int getBucketNumber(String fileName) {
        if (fileName.startsWith("bucket_")) {
            return Integer.parseInt(fileName.substring(fileName.indexOf(95) + 1));
        }
        if (this.originalFilePattern.matcher(fileName).matches() || this.originalCopyFilePattern.matcher(fileName).matches()) {
            return Integer.parseInt(fileName.substring(0, fileName.indexOf(95)));
        }
        return -1;
    }

    private Path createPath(String partitionLocation, WriteIdInfo deleteDeltaInfo, String fileName) {
        Path directory = deleteDeltaInfo.getStatementId() == -1 ? new Path(partitionLocation, AcidUtils.deleteDeltaSubdir((long)deleteDeltaInfo.getMinWriteId(), (long)deleteDeltaInfo.getMaxWriteId())) : new Path(partitionLocation, AcidUtils.deleteDeltaSubdir((long)deleteDeltaInfo.getMinWriteId(), (long)deleteDeltaInfo.getMaxWriteId(), (int)deleteDeltaInfo.getStatementId()));
        String bucketFileName = this.getBucketFileName(fileName);
        return new Path(directory, bucketFileName);
    }

    private String getBucketFileName(String fileName) {
        String bucketDigit = "%05d";
        int bucketNumber = this.getBucketNumber(fileName);
        return "bucket_" + String.format(bucketDigit, bucketNumber);
    }

    void close() {
        this.pageSources.forEach(pageSource -> {
            try {
                pageSource.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @NotThreadSafe
    public class MaskDeletedRowsFunction {
        @Nullable
        private Page sourcePage;
        private int positionCount;
        @Nullable
        private int[] validPositions;
        private Optional<Long> pageRowOffset;

        public MaskDeletedRowsFunction(Page sourcePage, Optional<Long> pageRowOffset) {
            this.sourcePage = sourcePage;
            this.pageRowOffset = pageRowOffset;
        }

        public int getPositionCount() {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            return this.positionCount;
        }

        public Block apply(Block block) {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            if (this.positionCount == block.getPositionCount() || block.getPositionCount() == 0 || this.validPositions == null) {
                return block;
            }
            return new DictionaryBlock(this.positionCount, block, this.validPositions);
        }

        private void loadValidPositions() {
            if (OrcDeletedRows.this.deleteDeltaLocations == null) {
                this.positionCount = this.sourcePage.getPositionCount();
                this.sourcePage = null;
                return;
            }
            int[] localValidPositions = new int[this.sourcePage.getPositionCount()];
            OrcAcidRowId sourcePageRowId = new OrcAcidRowId(0L, 0, 0L);
            int validPositionsIndex = 0;
            for (int pagePosition = 0; pagePosition < this.sourcePage.getPositionCount(); ++pagePosition) {
                if (OrcDeletedRows.this.startRowOffsetOfFile.isPresent() && this.pageRowOffset.isPresent()) {
                    long currRowId = OrcDeletedRows.this.startRowOffsetOfFile.get() + this.pageRowOffset.get() + (long)pagePosition;
                    sourcePageRowId.set(sourcePageRowId.getOriginalTransaction(), sourcePageRowId.getBucket(), currRowId);
                } else {
                    sourcePageRowId.set(this.sourcePage, pagePosition);
                }
                boolean deleted = OrcDeletedRows.this.isDeleted(sourcePageRowId);
                if (deleted) continue;
                localValidPositions[validPositionsIndex] = pagePosition;
                ++validPositionsIndex;
            }
            this.positionCount = validPositionsIndex;
            this.validPositions = localValidPositions;
            this.sourcePage = null;
        }
    }
}

