/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcCacheProperties;
import io.prestosql.orc.OrcCacheStore;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDataSourceIdWithTimeStamp;
import io.prestosql.orc.OrcFileTail;
import io.prestosql.orc.OrcFileTailCacheKey;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.orc.TupleDomainOrcPredicate;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.plugin.hive.orc.OrcDeletedRows;
import io.prestosql.plugin.hive.orc.OrcPageSource;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.dynamicfilter.DynamicFilterSupplier;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.heuristicindex.SplitMetadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.joda.time.DateTimeZone;

public class OrcPageSourceFactory
implements HivePageSourceFactory {
    public static final String ACID_COLUMN_OPERATION = "operation";
    public static final String ACID_COLUMN_ORIGINAL_TRANSACTION = "originalTransaction";
    public static final String ACID_COLUMN_BUCKET = "bucket";
    public static final String ACID_COLUMN_ROW_ID = "rowId";
    public static final String ACID_COLUMN_CURRENT_TRANSACTION = "currentTransaction";
    public static final String ACID_COLUMN_ROW_STRUCT = "row";
    public static final Integer SKIP_ORC_FILE_COLUMNS = 7;
    public static final List<String> EAGER_LOAD_INDEX_ID = ImmutableList.of((Object)"BITMAP");
    private static final Pattern DEFAULT_HIVE_COLUMN_NAME_PATTERN = Pattern.compile("_col\\d+");
    private static final Logger log = Logger.get(OrcPageSourceFactory.class);
    private final TypeManager typeManager;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final OrcCacheStore orcCacheStore;
    private final int domainCompactionThreshold;
    private final DateTimeZone legacyTimeZone;

    @Inject
    public OrcPageSourceFactory(TypeManager typeManager, HiveConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcCacheStore orcCacheStore) {
        this(typeManager, config, hdfsEnvironment, stats, orcCacheStore, Objects.requireNonNull(config, "hiveConfig is null").getDomainCompactionThreshold());
    }

    public OrcPageSourceFactory(TypeManager typeManager, HiveConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcCacheStore orcCacheStore, int domainCompactionThreshold) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(config, "config is null");
        this.useOrcColumnNames = config.isUseOrcColumnNames();
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.orcCacheStore = orcCacheStore;
        this.legacyTimeZone = Objects.requireNonNull(config, "hiveConfig is null").getOrcLegacyDateTimeZone();
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<DynamicFilterSupplier> dynamicFilters, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, Optional<List<IndexMetadata>> indexes, SplitMetadata splitMetadata, boolean splitCacheable, long dataSourceLastModifiedTime) {
        if (!HiveUtil.isDeserializerClass(schema, OrcSerde.class)) {
            return Optional.empty();
        }
        if (fileSize == 0L) {
            return Optional.of(new FixedPageSource((Iterable)ImmutableList.of()));
        }
        OrcCacheProperties orcCacheProperties = new OrcCacheProperties(HiveSessionProperties.isOrcFileTailCacheEnabled(session), HiveSessionProperties.isOrcStripeFooterCacheEnabled(session), HiveSessionProperties.isOrcRowIndexCacheEnabled(session), HiveSessionProperties.isOrcBloomFiltersCacheEnabled(session), HiveSessionProperties.isOrcRowDataCacheEnabled(session) && splitCacheable);
        return Optional.of(OrcPageSourceFactory.createOrcPageSource(this.hdfsEnvironment, session.getUser(), configuration, path, start, length, fileSize, columns, this.useOrcColumnNames, AcidUtils.isFullAcidTable((Map)Maps.fromProperties((Properties)schema)), effectivePredicate, this.legacyTimeZone, this.typeManager, HiveSessionProperties.getOrcMaxMergeDistance(session), HiveSessionProperties.getOrcMaxBufferSize(session), HiveSessionProperties.getOrcStreamBufferSize(session), HiveSessionProperties.getOrcTinyStripeThreshold(session), HiveSessionProperties.getOrcMaxReadBlockSize(session), HiveSessionProperties.getOrcLazyReadSmallRanges(session), HiveSessionProperties.isOrcBloomFiltersEnabled(session), this.stats, dynamicFilters, deleteDeltaLocations, startRowOffsetOfFile, indexes, splitMetadata, this.orcCacheStore, orcCacheProperties, this.domainCompactionThreshold, session.isPageMetadataEnabled(), dataSourceLastModifiedTime));
    }

    public static OrcPageSource createOrcPageSource(HdfsEnvironment hdfsEnvironment, String sessionUser, Configuration configuration, Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, boolean useOrcColumnNames, boolean isFullAcid, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone legacyFileTimeZone, TypeManager typeManager, DataSize maxMergeDistance, DataSize maxBufferSize, DataSize streamBufferSize, DataSize tinyStripeThreshold, DataSize maxReadBlockSize, boolean lazyReadSmallRanges, boolean orcBloomFiltersEnabled, FileFormatDataSourceStats stats, Optional<DynamicFilterSupplier> dynamicFilters, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, Optional<List<IndexMetadata>> indexes, SplitMetadata splitMetadata, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, int domainCompactionThreshold, boolean pageMetadataEnabled, long dataSourceLastModifiedTime) {
        HdfsOrcDataSource orcDataSource;
        for (HiveColumnHandle column : columns) {
            Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR || column.getHiveColumnIndex() == -13 ? 1 : 0) != 0, (String)"column type must be regular: %s", (Object)column);
        }
        Preconditions.checkArgument((!effectivePredicate.isNone() ? 1 : 0) != 0);
        try {
            FSDataInputStream inputStream = new FSDataInputStream((InputStream)new LazyFSInputStream(() -> {
                FileSystem fileSystem = hdfsEnvironment.getFileSystem(sessionUser, path, configuration);
                return hdfsEnvironment.doAs(sessionUser, () -> fileSystem.open(path));
            }));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, maxMergeDistance, maxBufferSize, streamBufferSize, lazyReadSmallRanges, inputStream, stats, dataSourceLastModifiedTime);
        }
        catch (Exception e2) {
            if (Strings.nullToEmpty((String)e2.getMessage()).trim().equals("Filesystem closed") || e2 instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e2);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcPageSourceFactory.splitError(e2, path, start, length), (Throwable)e2);
        }
        AggregatedMemoryContext systemMemoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        try {
            OrcFileTail fileTail;
            OrcDataSource readerLocalDataSource = OrcReader.wrapWithCacheIfTiny((OrcDataSource)orcDataSource, (DataSize)tinyStripeThreshold);
            if (orcCacheProperties.isFileTailCacheEnabled()) {
                try {
                    OrcDataSourceIdWithTimeStamp orcDataSourceIdWithTimeStamp = new OrcDataSourceIdWithTimeStamp(readerLocalDataSource.getId(), readerLocalDataSource.getLastModifiedTime());
                    fileTail = (OrcFileTail)orcCacheStore.getFileTailCache().get((Object)new OrcFileTailCacheKey(orcDataSourceIdWithTimeStamp), () -> OrcPageSourceFactory.lambda$createOrcPageSource$2((OrcDataSource)orcDataSource));
                }
                catch (UncheckedExecutionException | ExecutionException executionException) {
                    OrcReader.handleCacheLoadException((Exception)executionException);
                    log.debug(executionException.getCause(), "Error while caching the Orc file tail. Falling back to default flow");
                    fileTail = OrcPageSourceFactory.createFileTail((OrcDataSource)orcDataSource);
                }
            } else {
                fileTail = OrcPageSourceFactory.createFileTail((OrcDataSource)orcDataSource);
            }
            OrcReader reader = new OrcReader(readerLocalDataSource, fileTail, maxMergeDistance, tinyStripeThreshold, maxReadBlockSize);
            List<Object> fileColumns = reader.getRootColumn().getNestedColumns();
            ArrayList<Object> fileReadColumns = isFullAcid ? new ArrayList<Object>(columns.size() + 5) : new ArrayList(columns.size());
            ArrayList<Object> fileReadTypes = isFullAcid ? new ArrayList<Object>(columns.size() + 5) : new ArrayList(columns.size());
            ImmutableList acidColumnNames = null;
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(columns.size());
            boolean fileNameContainsBucket = path.getName().contains(ACID_COLUMN_BUCKET);
            if (isFullAcid && fileNameContainsBucket) {
                acidColumnNames = ImmutableList.builder().add((Object[])new String[]{ACID_COLUMN_ORIGINAL_TRANSACTION, ACID_COLUMN_BUCKET, ACID_COLUMN_ROW_ID, ACID_COLUMN_CURRENT_TRANSACTION, ACID_COLUMN_OPERATION}).build();
                OrcPageSourceFactory.verifyAcidSchema(reader, path);
                ImmutableMap acidColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
                fileColumns = AcidUtils.isDeleteDelta((Path)path.getParent()) ? ImmutableList.of() : OrcPageSourceFactory.ensureColumnNameConsistency(((OrcColumn)acidColumnsByName.get(ACID_COLUMN_ROW_STRUCT)).getNestedColumns(), columns);
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_ORIGINAL_TRANSACTION.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_BUCKET.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(IntegerType.INTEGER);
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_ROW_ID.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_CURRENT_TRANSACTION.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_OPERATION.toLowerCase(Locale.ENGLISH)));
                fileReadTypes.add(IntegerType.INTEGER);
            }
            ImmutableMap fileColumnsByName = ImmutableMap.of();
            if (useOrcColumnNames || isFullAcid) {
                OrcPageSourceFactory.verifyFileHasColumnNames(fileColumns, path);
                fileColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            }
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(orcBloomFiltersEnabled).setDomainCompactionThreshold(domainCompactionThreshold);
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            for (HiveColumnHandle column : columns) {
                OrcColumn orcColumn2 = null;
                if (useOrcColumnNames || isFullAcid) {
                    orcColumn2 = (OrcColumn)fileColumnsByName.get(column.getName());
                } else if (column.getHiveColumnIndex() >= 0 && column.getHiveColumnIndex() < fileColumns.size()) {
                    orcColumn2 = (OrcColumn)fileColumns.get(column.getHiveColumnIndex());
                }
                Type readType = typeManager.getType(column.getTypeSignature());
                if (orcColumn2 != null) {
                    int sourceIndex = fileReadColumns.size();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn(sourceIndex));
                    fileReadColumns.add(orcColumn2);
                    fileReadTypes.add(readType);
                    Domain domain = (Domain)effectivePredicateDomains.get(column);
                    if (domain == null) continue;
                    predicateBuilder.addColumn(orcColumn2.getColumnId(), domain);
                    continue;
                }
                if (isFullAcid && readType instanceof RowType && column.getName().equalsIgnoreCase("$rowId")) {
                    HiveType hiveType = column.getHiveType();
                    StructTypeInfo structTypeInfo = (StructTypeInfo)hiveType.getTypeInfo();
                    ImmutableList.Builder builder = new ImmutableList.Builder();
                    ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                    List<OrcPageSource.ColumnAdaptation> adaptations = fieldNames.stream().map(arg_0 -> ((ImmutableList)acidColumnNames).indexOf(arg_0)).map(c -> OrcPageSource.ColumnAdaptation.sourceColumn(c, false)).collect(Collectors.toList());
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.structColumn(structTypeInfo, adaptations));
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn(readType));
            }
            Map<String, Domain> domains = ((Map)effectivePredicate.getDomains().get()).entrySet().stream().collect(Collectors.toMap(e -> ((HiveColumnHandle)e.getKey()).getName(), Map.Entry::getValue));
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, (OrcPredicate)predicateBuilder.build(), start, length, legacyFileTimeZone, systemMemoryUsage, 1, arg_0 -> OrcPageSourceFactory.lambda$createOrcPageSource$8((OrcDataSource)orcDataSource, arg_0), indexes, splitMetadata, domains, orcCacheStore, orcCacheProperties, pageMetadataEnabled);
            OrcDeletedRows deletedRows = new OrcDeletedRows(path.getName(), deleteDeltaLocations, new OrcDeleteDeltaPageSourceFactory(sessionUser, configuration, hdfsEnvironment, maxMergeDistance, maxBufferSize, streamBufferSize, maxReadBlockSize, tinyStripeThreshold, lazyReadSmallRanges, orcBloomFiltersEnabled, stats), sessionUser, configuration, hdfsEnvironment, startRowOffsetOfFile);
            boolean eagerload = false;
            if (indexes.isPresent()) {
                eagerload = indexes.get().stream().anyMatch(indexMetadata -> EAGER_LOAD_INDEX_ID.contains(indexMetadata.getIndex().getId()));
            }
            return new OrcPageSource(recordReader, columnAdaptations, (OrcDataSource)orcDataSource, deletedRows, eagerload, systemMemoryUsage, stats);
        }
        catch (Exception e3) {
            try {
                orcDataSource.close();
            }
            catch (IOException fileTail) {
                // empty catch block
            }
            if (e3 instanceof PrestoException) {
                throw (PrestoException)((Object)e3);
            }
            String message = OrcPageSourceFactory.splitError(e3, path, start, length);
            if (e3 instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e3);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e3);
        }
    }

    private static OrcFileTail createFileTail(OrcDataSource orcDataSource) throws IOException {
        return OrcFileTail.readFrom((OrcDataSource)orcDataSource, Optional.empty());
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    private static void verifyFileHasColumnNames(List<OrcColumn> columns, Path path) {
        if (!columns.isEmpty() && columns.stream().map(OrcColumn::getColumnName).allMatch(physicalColumnName -> DEFAULT_HIVE_COLUMN_NAME_PATTERN.matcher((CharSequence)physicalColumnName).matches())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_MISSING_COLUMN_NAMES, "ORC file does not contain column names in the footer: " + path);
        }
    }

    static void verifyAcidSchema(OrcReader orcReader, Path path) {
        OrcColumn rootColumn = orcReader.getRootColumn();
        if (rootColumn.getNestedColumns().size() != 6) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file should have 6 columns: %s", path));
        }
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 0, ACID_COLUMN_OPERATION, OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 1, ACID_COLUMN_ORIGINAL_TRANSACTION, OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 2, ACID_COLUMN_BUCKET, OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 3, ACID_COLUMN_ROW_ID, OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 4, ACID_COLUMN_CURRENT_TRANSACTION, OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 5, ACID_COLUMN_ROW_STRUCT, OrcType.OrcTypeKind.STRUCT, path);
    }

    private static void verifyAcidColumn(OrcReader orcReader, int columnIndex, String columnName, OrcType.OrcTypeKind columnType, Path path) {
        OrcColumn column = (OrcColumn)orcReader.getRootColumn().getNestedColumns().get(columnIndex);
        if (!column.getColumnName().toLowerCase(Locale.ENGLISH).equals(columnName.toLowerCase(Locale.ENGLISH))) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file column %s should be named %s: %s", columnIndex, columnName, path));
        }
        if (column.getColumnType() != columnType) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file %s column should be type %s: %s", columnName, columnType, path));
        }
    }

    private static List<OrcColumn> ensureColumnNameConsistency(List<OrcColumn> fileColumns, List<HiveColumnHandle> desiredColumns) {
        int skipStructColumnCount = 0;
        ArrayList<Integer> skipStructColumnCountList = new ArrayList<Integer>();
        Map desiredColumnsByNumber = (Map)desiredColumns.stream().filter(column -> column.getHiveColumnIndex() >= 0).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getHiveColumnIndex, Function.identity()));
        int columnCount = Math.min(fileColumns.size(), desiredColumnsByNumber.size());
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)columnCount);
        List desiredColumnsIndex = desiredColumnsByNumber.keySet().stream().collect(Collectors.toList());
        HashMap<Integer, OrcColumn> fileColumnsByNumber = new HashMap<Integer, OrcColumn>();
        for (OrcColumn orcColumn : fileColumns) {
            fileColumnsByNumber.put(orcColumn.getColumnId().getId(), orcColumn);
            skipStructColumnCountList.add(skipStructColumnCount);
            skipStructColumnCount += OrcPageSourceFactory.getSkipStructColumnCount(orcColumn);
        }
        for (int index = 0; index < columnCount; ++index) {
            OrcColumn column2 = (OrcColumn)fileColumnsByNumber.get((Integer)desiredColumnsIndex.get(index) + SKIP_ORC_FILE_COLUMNS + (Integer)skipStructColumnCountList.get((Integer)desiredColumnsIndex.get(index)));
            HiveColumnHandle handle = (HiveColumnHandle)desiredColumnsByNumber.get(desiredColumnsIndex.get(index));
            if (handle != null && !column2.getColumnName().equals(handle.getName())) {
                column2 = new OrcColumn(column2.getPath(), column2.getColumnId(), handle.getName(), column2.getColumnType(), column2.getOrcDataSourceId(), column2.getNestedColumns());
            }
            builder.add((Object)column2);
        }
        return builder.build();
    }

    private static int getSkipStructColumnCount(OrcColumn orcColumn) {
        switch (orcColumn.getColumnType()) {
            case LIST: 
            case STRUCT: 
            case MAP: {
                return orcColumn.getNestedColumns().size() + orcColumn.getNestedColumns().stream().map(column -> OrcPageSourceFactory.getSkipStructColumnCount(column)).mapToInt(Integer::valueOf).sum();
            }
        }
        return 0;
    }

    private static /* synthetic */ RuntimeException lambda$createOrcPageSource$8(OrcDataSource orcDataSource, Exception exception) {
        return OrcPageSource.handleException(orcDataSource.getId(), exception);
    }

    private static /* synthetic */ OrcFileTail lambda$createOrcPageSource$2(OrcDataSource orcDataSource) throws Exception {
        return OrcPageSourceFactory.createFileTail(orcDataSource);
    }

    static class LazyFSInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private FSDataInputStreamProvider fsDataInputStreamProvider;
        private FSDataInputStream fsDataInputStream;
        private boolean isStreamAvailable;

        public LazyFSInputStream(FSDataInputStreamProvider fsDataInputStreamProvider) {
            this.fsDataInputStreamProvider = fsDataInputStreamProvider;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.read(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            this.ensureActualStream();
            this.fsDataInputStream.readFully(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.ensureActualStream();
            this.fsDataInputStream.readFully(position, buffer);
        }

        public void seek(long pos) throws IOException {
            this.ensureActualStream();
            this.fsDataInputStream.seek(pos);
        }

        public long getPos() throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.getPos();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.seekToNewSource(targetPos);
        }

        @Override
        public int read() throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.read();
        }

        @Override
        public void close() throws IOException {
            if (this.isStreamAvailable) {
                this.fsDataInputStream.close();
                this.isStreamAvailable = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureActualStream() throws IOException {
            if (this.isStreamAvailable) {
                return;
            }
            LazyFSInputStream lazyFSInputStream = this;
            synchronized (lazyFSInputStream) {
                if (!this.isStreamAvailable) {
                    this.fsDataInputStream = this.fsDataInputStreamProvider.provide();
                }
            }
            this.isStreamAvailable = true;
        }
    }

    static interface FSDataInputStreamProvider {
        public FSDataInputStream provide() throws IOException;
    }
}

