/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcCacheProperties;
import io.prestosql.orc.OrcCacheStore;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDataSourceIdWithTimeStamp;
import io.prestosql.orc.OrcFileTail;
import io.prestosql.orc.OrcFileTailCacheKey;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcSelectiveRecordReader;
import io.prestosql.orc.TupleDomainFilter;
import io.prestosql.orc.TupleDomainFilterUtils;
import io.prestosql.orc.TupleDomainOrcPredicate;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HiveSelectivePageSourceFactory;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.coercions.HiveCoercer;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.plugin.hive.orc.OrcDeletedRows;
import io.prestosql.plugin.hive.orc.OrcPageSource;
import io.prestosql.plugin.hive.orc.OrcSelectivePageSource;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.joda.time.DateTimeZone;

public class OrcSelectivePageSourceFactory
implements HiveSelectivePageSourceFactory {
    public static final String ACID_COLUMN_OPERATION = "operation";
    public static final String ACID_COLUMN_ORIGINAL_TRANSACTION = "originalTransaction";
    public static final String ACID_COLUMN_BUCKET = "bucket";
    public static final String ACID_COLUMN_ROW_ID = "rowId";
    public static final String ACID_COLUMN_CURRENT_TRANSACTION = "currentTransaction";
    public static final String ACID_COLUMN_ROW_STRUCT = "row";
    private static final Pattern DEFAULT_HIVE_COLUMN_NAME_PATTERN = Pattern.compile("_col\\d+");
    private final TypeManager typeManager;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final OrcCacheStore orcCacheStore;
    private final DateTimeZone legacyTimeZone;

    @Inject
    public OrcSelectivePageSourceFactory(TypeManager typeManager, HiveConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcCacheStore orcCacheStore) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(config, "config is null");
        this.useOrcColumnNames = config.isUseOrcColumnNames();
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.orcCacheStore = orcCacheStore;
        this.legacyTimeZone = Objects.requireNonNull(config, "hiveConfig is null").getOrcLegacyDateTimeZone();
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, Map<Integer, String> prefilledValues, List<Integer> outputColumns, TupleDomain<HiveColumnHandle> domainPredicate, Optional<List<TupleDomain<HiveColumnHandle>>> additionPredicates, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, Optional<List<IndexMetadata>> indexes, boolean splitCacheable, List<HivePageSourceProvider.ColumnMapping> columnMappings, Map<Integer, HiveCoercer> coercers, long dataSourceLastModifiedTime) {
        if (!HiveUtil.isDeserializerClass(schema, OrcSerde.class)) {
            return Optional.empty();
        }
        if (fileSize == 0L) {
            return Optional.of(new FixedPageSource((Iterable)ImmutableList.of()));
        }
        OrcCacheProperties orcCacheProperties = new OrcCacheProperties(HiveSessionProperties.isOrcFileTailCacheEnabled(session), HiveSessionProperties.isOrcStripeFooterCacheEnabled(session), HiveSessionProperties.isOrcRowIndexCacheEnabled(session), HiveSessionProperties.isOrcBloomFiltersCacheEnabled(session), HiveSessionProperties.isOrcRowDataCacheEnabled(session) && splitCacheable);
        if (additionPredicates.isPresent() && additionPredicates.get().size() > 0 && !additionPredicates.get().get(0).isAll() && !additionPredicates.get().get(0).isNone()) {
            ArrayList<Integer> positions = new ArrayList<Integer>(10);
            return Optional.of(OrcSelectivePageSourceFactory.createOrcPageSource(this.hdfsEnvironment, session, configuration, path, start, length, fileSize, columns, this.useOrcColumnNames, AcidUtils.isFullAcidTable((Map)Maps.fromProperties((Properties)schema)), prefilledValues, outputColumns, domainPredicate, this.legacyTimeZone, this.typeManager, HiveSessionProperties.getOrcMaxMergeDistance(session), HiveSessionProperties.getOrcMaxBufferSize(session), HiveSessionProperties.getOrcStreamBufferSize(session), HiveSessionProperties.getOrcTinyStripeThreshold(session), HiveSessionProperties.getOrcMaxReadBlockSize(session), HiveSessionProperties.getOrcLazyReadSmallRanges(session), HiveSessionProperties.isOrcBloomFiltersEnabled(session), this.stats, deleteDeltaLocations, startRowOffsetOfFile, indexes, this.orcCacheStore, orcCacheProperties, additionPredicates.orElseGet(() -> ImmutableList.of()), positions, columnMappings, coercers, dataSourceLastModifiedTime));
        }
        return Optional.of(OrcSelectivePageSourceFactory.createOrcPageSource(this.hdfsEnvironment, session, configuration, path, start, length, fileSize, columns, this.useOrcColumnNames, AcidUtils.isFullAcidTable((Map)Maps.fromProperties((Properties)schema)), prefilledValues, outputColumns, domainPredicate, this.legacyTimeZone, this.typeManager, HiveSessionProperties.getOrcMaxMergeDistance(session), HiveSessionProperties.getOrcMaxBufferSize(session), HiveSessionProperties.getOrcStreamBufferSize(session), HiveSessionProperties.getOrcTinyStripeThreshold(session), HiveSessionProperties.getOrcMaxReadBlockSize(session), HiveSessionProperties.getOrcLazyReadSmallRanges(session), HiveSessionProperties.isOrcBloomFiltersEnabled(session), this.stats, deleteDeltaLocations, startRowOffsetOfFile, indexes, this.orcCacheStore, orcCacheProperties, (List<TupleDomain<HiveColumnHandle>>)ImmutableList.of(), null, columnMappings, coercers, dataSourceLastModifiedTime));
    }

    public static OrcSelectivePageSource createOrcPageSource(HdfsEnvironment hdfsEnvironment, ConnectorSession session, Configuration configuration, Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, boolean useOrcColumnNames, boolean isFullAcid, Map<Integer, String> prefilledValues, List<Integer> outputColumns, TupleDomain<HiveColumnHandle> domainPredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, DataSize maxMergeDistance, DataSize maxBufferSize, DataSize streamBufferSize, DataSize tinyStripeThreshold, DataSize maxReadBlockSize, boolean lazyReadSmallRanges, boolean orcBloomFiltersEnabled, FileFormatDataSourceStats stats, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, Optional<List<IndexMetadata>> indexes, OrcCacheStore orcCacheStore, OrcCacheProperties orcCacheProperties, List<TupleDomain<HiveColumnHandle>> disjunctDomains, List<Integer> positions, List<HivePageSourceProvider.ColumnMapping> columnMappings, Map<Integer, HiveCoercer> coercers, long dataSourceLastModifiedTime) {
        HdfsOrcDataSource orcDataSource;
        Preconditions.checkArgument((!domainPredicate.isNone() ? 1 : 0) != 0, (Object)"Unexpected NONE domain");
        String sessionUser = session.getUser();
        try {
            FSDataInputStream inputStream = new FSDataInputStream((InputStream)new LazyFSInputStream(() -> {
                FileSystem fileSystem = hdfsEnvironment.getFileSystem(sessionUser, path, configuration);
                return hdfsEnvironment.doAs(sessionUser, () -> fileSystem.open(path));
            }));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, maxMergeDistance, maxBufferSize, streamBufferSize, lazyReadSmallRanges, inputStream, stats, dataSourceLastModifiedTime);
        }
        catch (Exception e2) {
            if (Strings.nullToEmpty((String)e2.getMessage()).trim().equals("Filesystem closed") || e2 instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e2);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcSelectivePageSourceFactory.splitError(e2, path, start, length), (Throwable)e2);
        }
        AggregatedMemoryContext systemMemoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        try {
            OrcFileTail fileTail;
            OrcDataSource readerLocalDataSource = OrcReader.wrapWithCacheIfTiny((OrcDataSource)orcDataSource, (DataSize)tinyStripeThreshold);
            if (orcCacheProperties.isFileTailCacheEnabled()) {
                OrcDataSourceIdWithTimeStamp orcDataSourceIdWithTimeStamp = new OrcDataSourceIdWithTimeStamp(readerLocalDataSource.getId(), readerLocalDataSource.getLastModifiedTime());
                fileTail = (OrcFileTail)orcCacheStore.getFileTailCache().get((Object)new OrcFileTailCacheKey(orcDataSourceIdWithTimeStamp), () -> OrcSelectivePageSourceFactory.lambda$createOrcPageSource$3((OrcDataSource)orcDataSource));
            } else {
                fileTail = OrcSelectivePageSourceFactory.createFileTail((OrcDataSource)orcDataSource);
            }
            OrcReader reader = new OrcReader(readerLocalDataSource, fileTail, maxMergeDistance, tinyStripeThreshold, maxReadBlockSize);
            List fileColumns = reader.getRootColumn().getNestedColumns();
            ArrayList<Object> fileReadColumns = isFullAcid ? new ArrayList<Object>(columns.size() + 3) : new ArrayList(columns.size());
            ArrayList<Object> fileReadTypes = isFullAcid ? new ArrayList<Object>(columns.size() + 3) : new ArrayList(columns.size());
            ImmutableList acidColumnNames = null;
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(columns.size());
            if (isFullAcid && fileColumns.size() != columns.size()) {
                acidColumnNames = ImmutableList.builder().add((Object[])new String[]{ACID_COLUMN_ORIGINAL_TRANSACTION, ACID_COLUMN_BUCKET, ACID_COLUMN_ROW_ID}).build();
                OrcSelectivePageSourceFactory.verifyAcidSchema(reader, path);
                ImmutableMap acidColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName());
                fileColumns = ((OrcColumn)acidColumnsByName.get(ACID_COLUMN_ROW_STRUCT)).getNestedColumns();
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_ORIGINAL_TRANSACTION));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_BUCKET));
                fileReadTypes.add(IntegerType.INTEGER);
                fileReadColumns.add(acidColumnsByName.get(ACID_COLUMN_ROW_ID));
                fileReadTypes.add(BigintType.BIGINT);
            }
            ImmutableMap fileColumnsByName = ImmutableMap.of();
            if (useOrcColumnNames || isFullAcid) {
                OrcSelectivePageSourceFactory.verifyFileHasColumnNames(fileColumns, path);
                fileColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName());
            }
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(orcBloomFiltersEnabled);
            Map effectivePredicateDomains = (Map)domainPredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            HashMap disjunctPredicateDomains = new HashMap();
            disjunctDomains.stream().forEach(ap -> ((Map)ap.getDomains().get()).forEach((k, v) -> disjunctPredicateDomains.merge(k, v, (v1, v2) -> v1.union(v2))));
            boolean hasParitionKeyORPredicate = disjunctPredicateDomains.keySet().stream().anyMatch(c -> c.isPartitionKey());
            ConcurrentHashMap<String, List> orDomains = new ConcurrentHashMap<String, List>();
            HashSet<Integer> missingColumns = new HashSet<Integer>();
            for (HiveColumnHandle column2 : columns) {
                OrcColumn orcColumn2 = null;
                int missingColumn = -1;
                if (useOrcColumnNames || isFullAcid) {
                    orcColumn2 = (OrcColumn)fileColumnsByName.get(column2.getName());
                } else if (column2.getHiveColumnIndex() >= 0) {
                    if (column2.getHiveColumnIndex() < fileColumns.size()) {
                        orcColumn2 = (OrcColumn)fileColumns.get(column2.getHiveColumnIndex());
                    } else {
                        missingColumn = column2.getHiveColumnIndex();
                    }
                }
                Type readType = typeManager.getType(column2.getTypeSignature());
                if (orcColumn2 != null) {
                    int sourceIndex = fileReadColumns.size();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn(sourceIndex));
                    fileReadColumns.add(orcColumn2);
                    fileReadTypes.add(readType);
                    Domain domain = (Domain)effectivePredicateDomains.get(column2);
                    if (domain != null) {
                        predicateBuilder.addColumn(orcColumn2.getColumnId(), domain);
                    }
                    domain = (Domain)disjunctPredicateDomains.get(column2);
                    if (hasParitionKeyORPredicate || domain == null) continue;
                    predicateBuilder.addOrColumn(orcColumn2.getColumnId(), domain);
                    orDomains.computeIfAbsent(column2.getName(), l -> new ArrayList()).add(domain);
                    continue;
                }
                if (isFullAcid && readType instanceof RowType && column2.getName().equalsIgnoreCase("row__id")) {
                    HiveType hiveType = column2.getHiveType();
                    StructTypeInfo structTypeInfo = (StructTypeInfo)hiveType.getTypeInfo();
                    ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                    List<OrcPageSource.ColumnAdaptation> adaptations = fieldNames.stream().map(arg_0 -> ((ImmutableList)acidColumnNames).indexOf(arg_0)).map(OrcPageSource.ColumnAdaptation::sourceColumn).collect(Collectors.toList());
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.structColumn(structTypeInfo, adaptations));
                    continue;
                }
                if (missingColumn >= 0) {
                    missingColumns.add(missingColumn);
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn(readType));
            }
            predicateBuilder.setMissingColumns(missingColumns);
            Map columnTypes = (Map)columns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getHiveColumnIndex, column -> typeManager.getType(column.getTypeSignature())));
            Map columnNames = (Map)columns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getHiveColumnIndex, HiveColumnHandle::getName));
            HashMap<Integer, Object> typedPrefilledValues = new HashMap<Integer, Object>();
            for (Map.Entry<Integer, String> prefilledValue : prefilledValues.entrySet()) {
                typedPrefilledValues.put(Integer.valueOf(((Object)prefilledValue.getKey()).toString()), HiveUtil.typedPartitionKey(prefilledValue.getValue().toString(), (Type)columnTypes.get(prefilledValue.getKey()), (String)columnNames.get(prefilledValue.getKey())));
            }
            Map<Integer, TupleDomainFilter> tupleDomainFilters = OrcSelectivePageSourceFactory.toTupleDomainFilters(domainPredicate, (Map<String, Integer>)ImmutableBiMap.copyOf((Map)columnNames).inverse());
            HashMap orFilters = new HashMap();
            disjunctDomains.stream().forEach(ap -> OrcSelectivePageSourceFactory.toTupleDomainFilters((TupleDomain<HiveColumnHandle>)ap, (Map<String, Integer>)ImmutableBiMap.copyOf((Map)columnNames).inverse()).entrySet().stream().forEach(td -> orFilters.computeIfAbsent(td.getKey(), list -> new ArrayList()).add(td.getValue())));
            Map<String, Domain> domainMap = effectivePredicateDomains.entrySet().stream().collect(Collectors.toMap(e -> ((HiveColumnHandle)e.getKey()).getName(), Map.Entry::getValue));
            OrcSelectiveRecordReader recordReader = reader.createSelectiveRecordReader(fileColumns, fileReadColumns, fileReadTypes, outputColumns, columnTypes, tupleDomainFilters, typedPrefilledValues, (OrcPredicate)predicateBuilder.build(), start, length, hiveStorageTimeZone, systemMemoryUsage, 1, arg_0 -> OrcSelectivePageSourceFactory.lambda$createOrcPageSource$17((OrcDataSource)orcDataSource, arg_0), indexes, domainMap, orcCacheStore, orcCacheProperties, Optional.empty(), orFilters, positions, HiveSessionProperties.isOrcPushdownDataCacheEnabled(session), Maps.transformValues(coercers, Function.class::cast), orDomains, missingColumns);
            OrcDeletedRows deletedRows = new OrcDeletedRows(path.getName(), deleteDeltaLocations, new OrcDeleteDeltaPageSourceFactory(sessionUser, configuration, hdfsEnvironment, maxMergeDistance, maxBufferSize, streamBufferSize, maxReadBlockSize, tinyStripeThreshold, lazyReadSmallRanges, orcBloomFiltersEnabled, stats), sessionUser, configuration, hdfsEnvironment, startRowOffsetOfFile);
            return new OrcSelectivePageSource(recordReader, (OrcDataSource)orcDataSource, systemMemoryUsage, stats, columnMappings, typeManager);
        }
        catch (Exception e3) {
            try {
                orcDataSource.close();
            }
            catch (IOException fileTail) {
                // empty catch block
            }
            if (e3 instanceof PrestoException) {
                throw (PrestoException)((Object)e3);
            }
            String message = OrcSelectivePageSourceFactory.splitError(e3, path, start, length);
            if (e3 instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e3);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e3);
        }
    }

    private static Map<Integer, TupleDomainFilter> toTupleDomainFilters(TupleDomain<HiveColumnHandle> domainPredicate, Map<String, Integer> columnIndices) {
        HashMap<Integer, TupleDomainFilter> tupleDomainFilterMap = new HashMap<Integer, TupleDomainFilter>();
        ((Map)domainPredicate.transform(columnHandle -> (Integer)columnIndices.get(columnHandle.getColumnName())).getDomains().get()).forEach((k, v) -> tupleDomainFilterMap.put((Integer)k, TupleDomainFilterUtils.toFilter((Domain)v)));
        return tupleDomainFilterMap;
    }

    private static OrcFileTail createFileTail(OrcDataSource orcDataSource) throws IOException {
        return OrcFileTail.readFrom((OrcDataSource)orcDataSource, Optional.empty());
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    private static void verifyFileHasColumnNames(List<OrcColumn> columns, Path path) {
        if (!columns.isEmpty() && columns.stream().map(OrcColumn::getColumnName).allMatch(physicalColumnName -> DEFAULT_HIVE_COLUMN_NAME_PATTERN.matcher((CharSequence)physicalColumnName).matches())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_MISSING_COLUMN_NAMES, "ORC file does not contain column names in the footer: " + path);
        }
    }

    static void verifyAcidSchema(OrcReader orcReader, Path path) {
        OrcColumn rootColumn = orcReader.getRootColumn();
        if (rootColumn.getNestedColumns().size() != 6) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file should have 6 columns: %s", path));
        }
        OrcSelectivePageSourceFactory.verifyAcidColumn(orcReader, 0, ACID_COLUMN_OPERATION, OrcType.OrcTypeKind.INT, path);
        OrcSelectivePageSourceFactory.verifyAcidColumn(orcReader, 1, ACID_COLUMN_ORIGINAL_TRANSACTION, OrcType.OrcTypeKind.LONG, path);
        OrcSelectivePageSourceFactory.verifyAcidColumn(orcReader, 2, ACID_COLUMN_BUCKET, OrcType.OrcTypeKind.INT, path);
        OrcSelectivePageSourceFactory.verifyAcidColumn(orcReader, 3, ACID_COLUMN_ROW_ID, OrcType.OrcTypeKind.LONG, path);
        OrcSelectivePageSourceFactory.verifyAcidColumn(orcReader, 4, ACID_COLUMN_CURRENT_TRANSACTION, OrcType.OrcTypeKind.LONG, path);
        OrcSelectivePageSourceFactory.verifyAcidColumn(orcReader, 5, ACID_COLUMN_ROW_STRUCT, OrcType.OrcTypeKind.STRUCT, path);
    }

    private static void verifyAcidColumn(OrcReader orcReader, int columnIndex, String columnName, OrcType.OrcTypeKind columnType, Path path) {
        OrcColumn column = (OrcColumn)orcReader.getRootColumn().getNestedColumns().get(columnIndex);
        if (!column.getColumnName().toLowerCase(Locale.ENGLISH).equals(columnName.toLowerCase(Locale.ENGLISH))) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file column %s should be named %s: %s", columnIndex, columnName, path));
        }
        if (column.getColumnType() != columnType) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file %s column should be type %s: %s", columnName, columnType, path));
        }
    }

    private static /* synthetic */ RuntimeException lambda$createOrcPageSource$17(OrcDataSource orcDataSource, Exception exception) {
        return OrcPageSource.handleException(orcDataSource.getId(), exception);
    }

    private static /* synthetic */ OrcFileTail lambda$createOrcPageSource$3(OrcDataSource orcDataSource) throws Exception {
        return OrcSelectivePageSourceFactory.createFileTail(orcDataSource);
    }

    static class LazyFSInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private FSDataInputStreamProvider fsDataInputStreamProvider;
        private FSDataInputStream fsDataInputStream;
        private boolean isStreamAvailable;

        public LazyFSInputStream(FSDataInputStreamProvider fsDataInputStreamProvider) {
            this.fsDataInputStreamProvider = fsDataInputStreamProvider;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.read(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            this.ensureActualStream();
            this.fsDataInputStream.readFully(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.ensureActualStream();
            this.fsDataInputStream.readFully(position, buffer);
        }

        public void seek(long pos) throws IOException {
            this.ensureActualStream();
            this.fsDataInputStream.seek(pos);
        }

        public long getPos() throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.getPos();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.seekToNewSource(targetPos);
        }

        @Override
        public int read() throws IOException {
            this.ensureActualStream();
            return this.fsDataInputStream.read();
        }

        @Override
        public void close() throws IOException {
            if (this.isStreamAvailable) {
                this.fsDataInputStream.close();
                this.isStreamAvailable = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureActualStream() throws IOException {
            if (this.isStreamAvailable) {
                return;
            }
            LazyFSInputStream lazyFSInputStream = this;
            synchronized (lazyFSInputStream) {
                if (!this.isStreamAvailable) {
                    this.fsDataInputStream = this.fsDataInputStreamProvider.provide();
                }
            }
            this.isStreamAvailable = true;
        }
    }

    static interface FSDataInputStreamProvider {
        public FSDataInputStream provide() throws IOException;
    }
}

