/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import io.prestosql.parquet.Field;
import io.prestosql.parquet.GroupField;
import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.PrimitiveField;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOUtil;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.Type;

final class ParquetColumnIOConverter {
    private ParquetColumnIOConverter() {
    }

    public static Optional<Field> constructField(Type type, ColumnIO columnIO) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = ColumnIOUtil.columnRepetitionLevel((ColumnIO)columnIO);
        int definitionLevel = ColumnIOUtil.columnDefinitionLevel((ColumnIO)columnIO);
        if ("row".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List parameters = type.getTypeParameters();
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = type.getTypeSignature().getParameters();
            boolean structHasParameters = false;
            for (int i = 0; i < fields.size(); ++i) {
                NamedTypeSignature namedTypeSignature = ((TypeSignatureParameter)fields.get(i)).getNamedTypeSignature();
                String name = ((String)namedTypeSignature.getName().get()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = ParquetColumnIOConverter.constructField((Type)parameters.get(i), ParquetTypeUtils.lookupColumnByName((GroupColumnIO)groupColumnIO, (String)name));
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if ("map".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            MapType mapType = (MapType)type;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn((GroupColumnIO)groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = ParquetColumnIOConverter.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = ParquetColumnIOConverter.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, ImmutableList.of(keyField, valueField)));
        }
        if ("array".equals(type.getTypeSignature().getBase())) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List types = type.getTypeParameters();
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            Optional<Field> field = ParquetColumnIOConverter.constructField((Type)types.get(0), ParquetTypeUtils.getArrayElementColumn((ColumnIO)groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        RichColumnDescriptor column = new RichColumnDescriptor(primitiveColumnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
        return Optional.of(new PrimitiveField(type, repetitionLevel, definitionLevel, required, column, primitiveColumnIO.getId()));
    }
}

