/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rcfile;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.rcfile.HdfsRcFileDataSource;
import io.prestosql.plugin.hive.rcfile.RcFilePageSource;
import io.prestosql.rcfile.AircompressorCodecFactory;
import io.prestosql.rcfile.HadoopCodecFactory;
import io.prestosql.rcfile.RcFileCodecFactory;
import io.prestosql.rcfile.RcFileCorruptionException;
import io.prestosql.rcfile.RcFileDataSource;
import io.prestosql.rcfile.RcFileEncoding;
import io.prestosql.rcfile.RcFileReader;
import io.prestosql.rcfile.binary.BinaryRcFileEncoding;
import io.prestosql.rcfile.text.TextRcFileEncoding;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.dynamicfilter.DynamicFilterSupplier;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.heuristicindex.SplitMetadata;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.joda.time.DateTimeZone;

public class RcFilePageSourceFactory
implements HivePageSourceFactory {
    private static final int TEXT_LEGACY_NESTING_LEVELS = 8;
    private static final int TEXT_EXTENDED_NESTING_LEVELS = 29;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final DateTimeZone timeZone;

    @Inject
    public RcFilePageSourceFactory(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, HiveConfig hiveConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.timeZone = Objects.requireNonNull(hiveConfig, "hiveConfig is null").getRcfileDateTimeZone();
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<DynamicFilterSupplier> dynamicFilters, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, Optional<List<IndexMetadata>> indexes, SplitMetadata splitMetadata, boolean splitCacheable, long dataSourceLastModifiedTime) {
        FSDataInputStream inputStream;
        BinaryRcFileEncoding rcFileEncoding;
        String deserializerClassName = HiveUtil.getDeserializerClassName(schema);
        if (deserializerClassName.equals(LazyBinaryColumnarSerDe.class.getName())) {
            rcFileEncoding = new BinaryRcFileEncoding(this.timeZone);
        } else if (deserializerClassName.equals(ColumnarSerDe.class.getName())) {
            rcFileEncoding = RcFilePageSourceFactory.createTextVectorEncoding(schema);
        } else {
            return Optional.empty();
        }
        Preconditions.checkArgument((!deleteDeltaLocations.isPresent() ? 1 : 0) != 0, (Object)"Delete delta is not supported");
        if (fileSize == 0L) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "RCFile is empty: " + path);
        }
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
            inputStream = this.hdfsEnvironment.doAs(session.getUser(), () -> fileSystem.open(path));
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, RcFilePageSourceFactory.splitError(e, path, start, length), (Throwable)e);
        }
        try {
            ImmutableMap.Builder readColumns = ImmutableMap.builder();
            for (HiveColumnHandle column : columns) {
                readColumns.put((Object)column.getHiveColumnIndex(), (Object)column.getHiveType().getType(this.typeManager));
            }
            RcFileReader rcFileReader = new RcFileReader((RcFileDataSource)new HdfsRcFileDataSource(path.toString(), inputStream, fileSize, this.stats), (RcFileEncoding)rcFileEncoding, (Map)readColumns.build(), (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(configuration.getClassLoader())), start, length, new DataSize(8.0, DataSize.Unit.MEGABYTE));
            return Optional.of(new RcFilePageSource(rcFileReader, columns, this.typeManager));
        }
        catch (Throwable e) {
            try {
                inputStream.close();
            }
            catch (IOException rcFileReader) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = RcFilePageSourceFactory.splitError(e, path, start, length);
            if (e instanceof RcFileCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, message, e);
            }
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    public static TextRcFileEncoding createTextVectorEncoding(Properties schema) {
        int nestingLevels = !"true".equalsIgnoreCase(schema.getProperty("hive.serialization.extend.nesting.levels")) ? 8 : 29;
        byte[] separators = Arrays.copyOf(TextRcFileEncoding.DEFAULT_SEPARATORS, nestingLevels);
        separators[0] = LazyUtils.getByte((String)schema.getProperty("field.delim", schema.getProperty("serialization.format")), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[0]);
        separators[1] = LazyUtils.getByte((String)schema.getProperty("collection.delim"), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[1]);
        separators[2] = LazyUtils.getByte((String)schema.getProperty("mapkey.delim"), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[2]);
        String nullSequenceString = schema.getProperty("serialization.null.format");
        Slice nullSequence = nullSequenceString == null ? TextRcFileEncoding.DEFAULT_NULL_SEQUENCE : Slices.utf8Slice((String)nullSequenceString);
        String lastColumnTakesRestString = schema.getProperty("serialization.last.column.takes.rest");
        boolean lastColumnTakesRest = "true".equalsIgnoreCase(lastColumnTakesRestString);
        String escapeProperty = schema.getProperty("escape.delim");
        Byte escapeByte = null;
        if (escapeProperty != null) {
            escapeByte = LazyUtils.getByte((String)escapeProperty, (byte)92);
        }
        return new TextRcFileEncoding(nullSequence, separators, escapeByte, lastColumnTakesRest);
    }
}

