/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.plugin.hive.security.AccessControlMetadata;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.GrantInfo;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.PrivilegeInfo;
import io.prestosql.spi.security.RoleGrant;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SqlStandardAccessControlMetadata
implements AccessControlMetadata {
    private static final Set<String> RESERVED_ROLES = ImmutableSet.of((Object)"all", (Object)"default", (Object)"none");
    private final SemiTransactionalHiveMetastore metastore;

    public SqlStandardAccessControlMetadata(SemiTransactionalHiveMetastore metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    public void createRole(ConnectorSession session, String role, Optional<HivePrincipal> grantor) {
        SqlStandardAccessControlMetadata.checkRoleIsNotReserved(role);
        this.metastore.createRole(role, null);
    }

    @Override
    public void dropRole(ConnectorSession session, String role) {
        SqlStandardAccessControlMetadata.checkRoleIsNotReserved(role);
        this.metastore.dropRole(role);
    }

    private static void checkRoleIsNotReserved(String role) {
        if (RESERVED_ROLES.contains(role.toLowerCase(Locale.ENGLISH))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Role name cannot be one of the reserved roles (case insensitive): " + RESERVED_ROLES);
        }
    }

    @Override
    public Set<String> listRoles(ConnectorSession session) {
        return ImmutableSet.copyOf(this.metastore.listRoles());
    }

    @Override
    public Set<RoleGrant> listRoleGrants(ConnectorSession session, HivePrincipal principal) {
        return ImmutableSet.copyOf(this.metastore.listRoleGrants(principal));
    }

    @Override
    public void grantRoles(ConnectorSession session, Set<String> roles, Set<HivePrincipal> grantees, boolean withAdminOption, Optional<HivePrincipal> grantor) {
        this.metastore.grantRoles(roles, grantees, withAdminOption, grantor.orElse(new HivePrincipal(PrincipalType.USER, session.getUser())));
    }

    @Override
    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<HivePrincipal> grantees, boolean adminOptionFor, Optional<HivePrincipal> grantor) {
        this.metastore.revokeRoles(roles, grantees, adminOptionFor, grantor.orElse(new HivePrincipal(PrincipalType.USER, session.getUser())));
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, HivePrincipal principal) {
        return (Set)ThriftMetastoreUtil.listApplicableRoles(principal, this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<String> listEnabledRoles(ConnectorSession session) {
        return (Set)ThriftMetastoreUtil.listEnabledRoles(session.getIdentity(), this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, HivePrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set<HivePrivilegeInfo> hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege(privilege), grantOption, new HivePrincipal(PrincipalType.USER, session.getUser()), new HivePrincipal(PrincipalType.USER, session.getUser()))).collect(Collectors.toSet());
        this.metastore.grantTablePrivileges(schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    @Override
    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, HivePrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set<HivePrivilegeInfo> hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege(privilege), grantOption, new HivePrincipal(PrincipalType.USER, session.getUser()), new HivePrincipal(PrincipalType.USER, session.getUser()))).collect(Collectors.toSet());
        this.metastore.revokeTablePrivileges(schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(ConnectorSession session, List<SchemaTableName> tableNames) {
        Set principals = (Set)ThriftMetastoreUtil.listEnabledPrincipals(this.metastore, session.getIdentity()).collect(ImmutableSet.toImmutableSet());
        boolean isAdminRoleSet = SqlStandardAccessControlMetadata.hasAdminRole(principals);
        ImmutableList.Builder result = ImmutableList.builder();
        for (SchemaTableName tableName : tableNames) {
            if (isAdminRoleSet) {
                result.addAll(this.buildGrants(tableName, null));
                continue;
            }
            for (HivePrincipal grantee : principals) {
                result.addAll(this.buildGrants(tableName, grantee));
            }
        }
        return result.build();
    }

    private List<GrantInfo> buildGrants(SchemaTableName tableName, HivePrincipal principal) {
        ImmutableList.Builder result = ImmutableList.builder();
        Set<HivePrivilegeInfo> hivePrivileges = this.metastore.listTablePrivileges(tableName.getSchemaName(), tableName.getTableName(), principal);
        for (HivePrivilegeInfo hivePrivilege : hivePrivileges) {
            Set<PrivilegeInfo> prestoPrivileges = hivePrivilege.toPrivilegeInfo();
            for (PrivilegeInfo prestoPrivilege : prestoPrivileges) {
                GrantInfo grant = new GrantInfo(prestoPrivilege, hivePrivilege.getGrantee().toPrestoPrincipal(), tableName, Optional.of(hivePrivilege.getGrantor().toPrestoPrincipal()), Optional.empty());
                result.add((Object)grant);
            }
        }
        return result.build();
    }

    private static boolean hasAdminRole(Set<HivePrincipal> roles) {
        return roles.stream().anyMatch(principal -> principal.getName().equalsIgnoreCase("admin"));
    }
}

