/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.security.AccessControlMetadata;
import io.prestosql.plugin.hive.security.AccessControlMetadataFactory;
import io.prestosql.plugin.hive.security.SecurityConstants;
import io.prestosql.plugin.hive.security.SqlStandardAccessControl;
import io.prestosql.plugin.hive.security.SqlStandardAccessControlMetadata;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorAccessControl;

public class SqlStandardSecurityModule
implements Module {
    private static final Logger log = Logger.get(SqlStandardSecurityModule.class);
    private String sqlStandardAccessControlImp;

    public SqlStandardSecurityModule(String sqlStandardAccessControlImp) {
        this.sqlStandardAccessControlImp = sqlStandardAccessControlImp;
    }

    public void configure(Binder binder) {
        if (this.sqlStandardAccessControlImp.isEmpty()) {
            binder.bind(ConnectorAccessControl.class).to(SqlStandardAccessControl.class).in(Scopes.SINGLETON);
        } else {
            try {
                if (!SecurityConstants.WHITE_LIST_SQLSTANDARDACCESSCONTROL_IMPL.contains(this.sqlStandardAccessControlImp)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Found illegal class when binding ConnectorAccessControl.");
                }
                log.info("Binding ConnectorAccessControl.class to %s", new Object[]{this.sqlStandardAccessControlImp});
                binder.bind(ConnectorAccessControl.class).to(Class.forName(this.sqlStandardAccessControlImp)).in(Scopes.SINGLETON);
            }
            catch (ClassNotFoundException e) {
                log.error("Failed to bind ConnectorAccessControl to a specified class. Error: %s", new Object[]{e.getLocalizedMessage()});
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Class not found when binding ConnectorAccessControl.");
            }
        }
        binder.bind(AccessControlMetadataFactory.class).to(SqlStandardAccessControlMetadataFactory.class);
    }

    private static final class SqlStandardAccessControlMetadataFactory
    implements AccessControlMetadataFactory {
        @Override
        public AccessControlMetadata create(SemiTransactionalHiveMetastore metastore) {
            return new SqlStandardAccessControlMetadata(metastore);
        }
    }
}

