/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.joda.time.DateTimeZone;

public final class FieldSetterFactory {
    private final DateTimeZone timeZone;

    public FieldSetterFactory(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    public FieldSetter create(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanFieldSetter(rowInspector, row, field);
        }
        if (type.equals(BigintType.BIGINT)) {
            return new BigintFieldBuilder(rowInspector, row, field);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new IntFieldSetter(rowInspector, row, field);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new SmallintFieldSetter(rowInspector, row, field);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return new TinyintFieldSetter(rowInspector, row, field);
        }
        if (type.equals(RealType.REAL)) {
            return new FloatFieldSetter(rowInspector, row, field);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new DoubleFieldSetter(rowInspector, row, field);
        }
        if (type instanceof VarcharType) {
            return new VarcharFieldSetter(rowInspector, row, field, type);
        }
        if (type instanceof CharType) {
            return new CharFieldSetter(rowInspector, row, field, type);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return new BinaryFieldSetter(rowInspector, row, field);
        }
        if (type.equals(DateType.DATE)) {
            return new DateFieldSetter(rowInspector, row, field);
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return new TimestampFieldSetter(rowInspector, row, field, this.timeZone);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalFieldSetter(rowInspector, row, field, decimalType);
        }
        if (HiveUtil.isArrayType(type)) {
            return new ArrayFieldSetter(rowInspector, row, field, (Type)type.getTypeParameters().get(0));
        }
        if (HiveUtil.isMapType(type)) {
            return new MapFieldSetter(rowInspector, row, field, (Type)type.getTypeParameters().get(0), (Type)type.getTypeParameters().get(1));
        }
        if (HiveUtil.isRowType(type)) {
            return new RowFieldSetter(rowInspector, row, field, type.getTypeParameters());
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static class RowFieldSetter
    extends FieldSetter {
        private final List<Type> fieldTypes;

        public RowFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, List<Type> fieldTypes) {
            super(rowInspector, row, field);
            this.fieldTypes = ImmutableList.copyOf(fieldTypes);
        }

        @Override
        public void setField(Block block, int position) {
            Block rowBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> value = new ArrayList<Object>(this.fieldTypes.size());
            for (int i = 0; i < this.fieldTypes.size(); ++i) {
                Object element = HiveWriteUtils.getField(this.fieldTypes.get(i), rowBlock, i);
                value.add(element);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, value);
        }
    }

    private static class MapFieldSetter
    extends FieldSetter {
        private final Type keyType;
        private final Type valueType;

        public MapFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type keyType, Type valueType) {
            super(rowInspector, row, field);
            this.keyType = Objects.requireNonNull(keyType, "keyType is null");
            this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block mapBlock = (Block)block.getObject(position, Block.class);
            HashMap<Object, Object> map = new HashMap<Object, Object>(mapBlock.getPositionCount() * 2);
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                Object key = HiveWriteUtils.getField(this.keyType, mapBlock, i);
                Object value = HiveWriteUtils.getField(this.valueType, mapBlock, i + 1);
                map.put(key, value);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, map);
        }
    }

    private static class ArrayFieldSetter
    extends FieldSetter {
        private final Type elementType;

        public ArrayFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type elementType) {
            super(rowInspector, row, field);
            this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block arrayBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = HiveWriteUtils.getField(this.elementType, arrayBlock, i);
                list.add(element);
            }
            this.rowInspector.setStructFieldData(this.row, this.field, list);
        }
    }

    private static class DecimalFieldSetter
    extends FieldSetter {
        private final HiveDecimalWritable value = new HiveDecimalWritable();
        private final DecimalType decimalType;

        public DecimalFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, DecimalType decimalType) {
            super(rowInspector, row, field);
            this.decimalType = decimalType;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(HiveWriteUtils.getHiveDecimal(this.decimalType, block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class TimestampFieldSetter
    extends FieldSetter {
        private final DateTimeZone timeZone;
        private final TimestampWritableV2 value = new TimestampWritableV2();

        public TimestampFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, DateTimeZone timeZone) {
            super(rowInspector, row, field);
            this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        }

        @Override
        public void setField(Block block, int position) {
            long epochMilli = TimestampType.TIMESTAMP.getLong(block, position);
            epochMilli = this.timeZone.convertLocalToUTC(epochMilli, false);
            this.value.set(Timestamp.ofEpochMilli((long)epochMilli));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class DateFieldSetter
    extends FieldSetter {
        private final DateWritableV2 value = new DateWritableV2();

        public DateFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Math.toIntExact(DateType.DATE.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BinaryFieldSetter
    extends FieldSetter {
        private final BytesWritable value = new BytesWritable();

        public BinaryFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            byte[] bytes = VarbinaryType.VARBINARY.getSlice(block, position).getBytes();
            this.value.set(bytes, 0, bytes.length);
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class CharFieldSetter
    extends FieldSetter {
        private final Text value = new Text();
        private final Type type;

        public CharFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
            super(rowInspector, row, field);
            this.type = type;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(this.type.getSlice(block, position).getBytes());
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class VarcharFieldSetter
    extends FieldSetter {
        private final Text value = new Text();
        private final Type type;

        public VarcharFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
            super(rowInspector, row, field);
            this.type = type;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(this.type.getSlice(block, position).getBytes());
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.unescapeText(this.value.toString()));
        }

        private Text unescapeText(String text) {
            return new Text(StringEscapeUtils.unescapeJava((String)text));
        }
    }

    private static class FloatFieldSetter
    extends FieldSetter {
        private final FloatWritable value = new FloatWritable();

        public FloatFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Float.intBitsToFloat((int)RealType.REAL.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class DoubleFieldSetter
    extends FieldSetter {
        private final DoubleWritable value = new DoubleWritable();

        public DoubleFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(DoubleType.DOUBLE.getDouble(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class TinyintFieldSetter
    extends FieldSetter {
        private final ByteWritable value = new ByteWritable();

        public TinyintFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(SignedBytes.checkedCast((long)TinyintType.TINYINT.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class SmallintFieldSetter
    extends FieldSetter {
        private final ShortWritable value = new ShortWritable();

        public SmallintFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Shorts.checkedCast((long)SmallintType.SMALLINT.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class IntFieldSetter
    extends FieldSetter {
        private final IntWritable value = new IntWritable();

        public IntFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Math.toIntExact(IntegerType.INTEGER.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BigintFieldBuilder
    extends FieldSetter {
        private final LongWritable value = new LongWritable();

        public BigintFieldBuilder(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BigintType.BIGINT.getLong(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BooleanFieldSetter
    extends FieldSetter {
        private final BooleanWritable value = new BooleanWritable();

        public BooleanFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BooleanType.BOOLEAN.getBoolean(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    public static abstract class FieldSetter {
        protected final SettableStructObjectInspector rowInspector;
        protected final Object row;
        protected final StructField field;

        private FieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            this.rowInspector = Objects.requireNonNull(rowInspector, "rowInspector is null");
            this.row = Objects.requireNonNull(row, "row is null");
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public abstract void setField(Block var1, int var2);
    }
}

