/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.stats.TimeStat;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;

public class HiveFileIterator
extends AbstractIterator<LocatedFileStatus> {
    private final Deque<Path> paths = new ArrayDeque<Path>();
    private final Table table;
    private final FileSystem fileSystem;
    private final DirectoryLister directoryLister;
    private final NamenodeStats namenodeStats;
    private final NestedDirectoryPolicy nestedDirectoryPolicy;
    private final PathFilter pathFilter;
    private Iterator<LocatedFileStatus> remoteIterator = Collections.emptyIterator();

    public HiveFileIterator(Table table, Path path, FileSystem fileSystem, DirectoryLister directoryLister, NamenodeStats namenodeStats, NestedDirectoryPolicy nestedDirectoryPolicy, PathFilter pathFilter) {
        this.paths.addLast(Objects.requireNonNull(path, "path is null"));
        this.table = Objects.requireNonNull(table, "table is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.nestedDirectoryPolicy = Objects.requireNonNull(nestedDirectoryPolicy, "nestedDirectoryPolicy is null");
        this.pathFilter = Objects.requireNonNull(pathFilter, "pathFilter is null");
    }

    protected LocatedFileStatus computeNext() {
        block5: while (true) {
            if (this.remoteIterator.hasNext()) {
                LocatedFileStatus status = this.getLocatedFileStatus(this.remoteIterator);
                String fileName = status.getPath().getName();
                if (fileName.startsWith("_") || fileName.startsWith(".")) continue;
                if (status.isDirectory()) {
                    switch (this.nestedDirectoryPolicy) {
                        case IGNORED: {
                            continue block5;
                        }
                        case RECURSE: {
                            this.paths.add(status.getPath());
                            continue block5;
                        }
                        case FAIL: {
                            throw new NestedDirectoryNotAllowedException();
                        }
                    }
                }
                return status;
            }
            if (this.paths.isEmpty()) {
                return (LocatedFileStatus)this.endOfData();
            }
            this.remoteIterator = this.getLocatedFileStatusRemoteIterator(this.paths.removeFirst(), this.pathFilter);
        }
    }

    private Iterator<LocatedFileStatus> getLocatedFileStatusRemoteIterator(Path path, PathFilter pathFilter) {
        try (TimeStat.BlockTimer ignored = this.namenodeStats.getListLocatedStatus().time();){
            UnmodifiableIterator unmodifiableIterator = Iterators.filter((Iterator)new FileStatusIterator(this.table, path, this.fileSystem, this.directoryLister, this.namenodeStats), input -> pathFilter.accept(input.getPath()));
            return unmodifiableIterator;
        }
    }

    private LocatedFileStatus getLocatedFileStatus(Iterator<LocatedFileStatus> iterator) {
        try (TimeStat.BlockTimer ignored = this.namenodeStats.getRemoteIteratorNext().time();){
            LocatedFileStatus locatedFileStatus = iterator.next();
            return locatedFileStatus;
        }
    }

    public static class NestedDirectoryNotAllowedException
    extends RuntimeException {
        public NestedDirectoryNotAllowedException() {
            super("Nested sub-directories are not allowed");
        }
    }

    private static class FileStatusIterator
    implements Iterator<LocatedFileStatus> {
        private final Path path;
        private final NamenodeStats namenodeStats;
        private final RemoteIterator<LocatedFileStatus> fileStatusIterator;

        private FileStatusIterator(Table table, Path path, FileSystem fileSystem, DirectoryLister directoryLister, NamenodeStats namenodeStats) {
            this.path = path;
            this.namenodeStats = namenodeStats;
            try {
                this.fileStatusIterator = directoryLister.list(fileSystem, table, path);
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.fileStatusIterator.hasNext();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public LocatedFileStatus next() {
            try {
                return (LocatedFileStatus)this.fileStatusIterator.next();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        private PrestoException processException(IOException exception) {
            this.namenodeStats.getRemoteIteratorNext().recordException(exception);
            if (exception instanceof FileNotFoundException) {
                return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Partition location does not exist: " + this.path);
            }
            return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to list directory: " + this.path, (Throwable)exception);
        }
    }

    public static enum NestedDirectoryPolicy {
        IGNORED,
        RECURSE,
        FAIL;

    }
}

