/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.spi.heuristicindex.IndexCacheKey;
import io.prestosql.spi.heuristicindex.IndexClient;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.heuristicindex.IndexNotCreatedException;
import io.prestosql.spi.heuristicindex.IndexRecord;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.service.PropertyService;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.eclipse.jetty.util.URIUtil;

public class IndexCache {
    private static final Logger LOG = Logger.get(IndexCache.class);
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Hive-IndexCache-pool-%d").setDaemon(true).build();
    protected static final List<String> INDEX_TYPES = ImmutableList.of((Object)"MINMAX", (Object)"BLOOM", (Object)"BITMAP");
    private static ScheduledExecutorService executor;
    private Long loadDelay;
    private LoadingCache<IndexCacheKey, List<IndexMetadata>> cache;
    private List<IndexRecord> indexRecords;

    @Inject
    public IndexCache(CacheLoader loader, IndexClient indexClient) {
        if (PropertyService.getBooleanProperty((String)"hetu.heuristicindex.filter.enabled").booleanValue()) {
            this.loadDelay = PropertyService.getDurationProperty((String)"hetu.heuristicindex.filter.cache.loading-delay").toMillis();
            long refreshRate = Math.max(this.loadDelay / 2L, 5000L);
            int numThreads = Math.min(Runtime.getRuntime().availableProcessors(), PropertyService.getLongProperty((String)"hetu.heuristicindex.filter.cache.loading-threads").intValue());
            executor = Executors.newScheduledThreadPool(numThreads, threadFactory);
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().removalListener(e -> ((List)e.getValue()).forEach(i -> {
                try {
                    i.getIndex().close();
                }
                catch (IOException ioException) {
                    LOG.debug((Throwable)ioException, "Failed to close index " + i);
                }
            })).expireAfterWrite(PropertyService.getDurationProperty((String)"hetu.heuristicindex.filter.cache.ttl").toMillis(), TimeUnit.MILLISECONDS).maximumWeight(PropertyService.getLongProperty((String)"hetu.heuristicindex.filter.cache.max-memory").longValue()).weigher((indexCacheKey, indices) -> {
                int memorySize = 0;
                for (IndexMetadata indexMetadata : indices) {
                    memorySize = (int)((long)memorySize + indexMetadata.getIndex().getMemoryUsage() / 1024L);
                }
                return memorySize;
            });
            if (PropertyService.getBooleanProperty((String)"hetu.heuristicindex.filter.cache.soft-reference").booleanValue()) {
                cacheBuilder.softValues();
            }
            executor.scheduleAtFixedRate(() -> {
                try {
                    if (this.cache.size() > 0L) {
                        List newRecords = indexClient.getAllIndexRecords();
                        if (this.indexRecords != null) {
                            for (IndexRecord old : this.indexRecords) {
                                boolean found = false;
                                for (IndexRecord now : newRecords) {
                                    if (!now.name.equals(old.name)) continue;
                                    found = true;
                                    if (now.lastModifiedTime == old.lastModifiedTime) continue;
                                    this.evictFromCache(old);
                                    LOG.debug("Index for {%s} has been evicted from cache because the index has been updated.", new Object[]{old});
                                }
                                if (found) continue;
                                this.evictFromCache(old);
                                LOG.debug("Index for {%s} has been evicted from cache because the index has been dropped.", new Object[]{old});
                            }
                        }
                        this.indexRecords = newRecords;
                    }
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e, "Error using index records to refresh cache");
                }
            }, this.loadDelay, refreshRate, TimeUnit.MILLISECONDS);
            this.cache = cacheBuilder.build(loader);
        }
    }

    public IndexCache(CacheLoader<IndexCacheKey, List<IndexMetadata>> loader, Long loadDelay, IndexClient indexClient) {
        this(loader, indexClient);
        this.loadDelay = loadDelay;
    }

    public List<IndexMetadata> getIndices(String catalog, String table, HiveSplit hiveSplit, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> partitions) {
        if (this.cache == null || catalog == null || table == null || hiveSplit == null || effectivePredicate == null) {
            return Collections.emptyList();
        }
        long lastModifiedTime = hiveSplit.getLastModifiedTime();
        Path path = new Path(hiveSplit.getPath());
        URI pathUri = URI.create(URIUtil.encodePath((String)path.toString()));
        String tableFqn = catalog + "." + table;
        LinkedList<IndexMetadata> splitIndexes = new LinkedList<IndexMetadata>();
        ((Map)effectivePredicate.getDomains().get()).keySet().stream().filter(key -> partitions == null || !partitions.contains(key)).map(HiveColumnHandle::getName).map(String::toLowerCase).forEach(column -> {
            if (!tableFqn.matches("([\\p{Alnum}_]+\\.){2,3}[\\p{Alnum}_]+")) {
                LOG.warn("Invalid table name " + tableFqn);
                return;
            }
            if (!column.matches("[\\p{Alnum}_]+")) {
                LOG.warn("Invalid column name " + column);
                return;
            }
            for (String indexType : INDEX_TYPES) {
                String indexCacheKeyPath = Paths.get(tableFqn, column, indexType, pathUri.getRawPath()).toString();
                IndexCacheKey indexCacheKey = new IndexCacheKey(indexCacheKeyPath, lastModifiedTime);
                List<IndexMetadata> predicateIndexes = (List<IndexMetadata>)this.cache.getIfPresent((Object)indexCacheKey);
                if (predicateIndexes == null) {
                    executor.schedule(() -> {
                        block2: {
                            try {
                                this.cache.get((Object)indexCacheKey);
                                LOG.debug("Loaded index for %s.", new Object[]{indexCacheKeyPath});
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() instanceof IndexNotCreatedException || !LOG.isDebugEnabled()) break block2;
                                LOG.debug((Throwable)e, "Unable to load index for %s. ", new Object[]{indexCacheKeyPath});
                            }
                        }
                    }, (long)this.loadDelay, TimeUnit.MILLISECONDS);
                    continue;
                }
                for (IndexMetadata index : predicateIndexes) {
                    if (index.getLastModifiedTime() == lastModifiedTime) continue;
                    this.cache.invalidate((Object)indexCacheKey);
                    predicateIndexes = Collections.emptyList();
                    break;
                }
                splitIndexes.addAll(predicateIndexes);
            }
        });
        return splitIndexes;
    }

    @VisibleForTesting
    protected long getCacheSize() {
        return this.cache.size();
    }

    private void evictFromCache(IndexRecord record) {
        String recordInCacheKey = String.format("%s/%s/%s", record.qualifiedTable, String.join((CharSequence)",", record.columns), record.indexType);
        for (IndexCacheKey key : this.cache.asMap().keySet()) {
            if (!key.getPath().startsWith(recordInCacheKey)) continue;
            this.cache.invalidate((Object)key);
        }
    }
}

