/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import io.prestosql.spi.heuristicindex.IndexCacheKey;
import io.prestosql.spi.heuristicindex.IndexClient;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.heuristicindex.IndexNotCreatedException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class IndexCacheLoader
extends CacheLoader<IndexCacheKey, List<IndexMetadata>> {
    private final IndexClient indexClient;

    @Inject
    public IndexCacheLoader(IndexClient indexClient) {
        this.indexClient = indexClient;
    }

    public List<IndexMetadata> load(IndexCacheKey key) throws Exception {
        List indices;
        long lastModified;
        Objects.requireNonNull(key);
        Objects.requireNonNull(this.indexClient);
        try {
            lastModified = this.indexClient.getLastModifiedTime(key.getPath());
        }
        catch (Exception e) {
            throw new IndexNotCreatedException();
        }
        if (lastModified != key.getLastModifiedTime()) {
            throw new Exception("Index files are expired for key " + key);
        }
        try {
            indices = this.indexClient.readSplitIndex(key.getPath());
        }
        catch (Exception e) {
            throw new Exception("No valid index files found for key " + key, e);
        }
        if (indices == null) {
            throw new IndexNotCreatedException();
        }
        if (indices.isEmpty()) {
            throw new Exception("No index files found for key " + key);
        }
        return indices.stream().sorted(Comparator.comparingLong(IndexMetadata::getSplitStart)).collect(Collectors.toList());
    }
}

