/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcDataSink;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.OrcWriter;
import io.prestosql.orc.OrcWriterOptions;
import io.prestosql.orc.OrcWriterStats;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;

public class TempFileWriter
implements Closeable {
    private final OrcWriter orcWriter;

    public TempFileWriter(List<Type> types, OrcDataSink sink) {
        this.orcWriter = TempFileWriter.createOrcFileWriter(sink, types);
    }

    public void writePage(Page page) {
        try {
            this.orcWriter.write(page);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.orcWriter.close();
    }

    public long getWrittenBytes() {
        return this.orcWriter.getWrittenBytes();
    }

    public long getRetainedBytes() {
        return this.orcWriter.getRetainedBytes();
    }

    private static OrcWriter createOrcFileWriter(OrcDataSink sink, List<Type> types) {
        List columnNames = (List)IntStream.range(0, types.size()).mapToObj(String::valueOf).collect(ImmutableList.toImmutableList());
        return new OrcWriter(sink, columnNames, types, CompressionKind.LZ4, new OrcWriterOptions().withMaxStringStatisticsLimit(new DataSize(0.0, DataSize.Unit.BYTE)).withStripeMinSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).withDictionaryMaxMemory(new DataSize(1.0, DataSize.Unit.MEGABYTE)), false, (Map)ImmutableMap.of(), false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats(), Optional.empty(), Optional.empty());
    }
}

