/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.ChunkRowIterator;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.carbondata.hive.CarbonHiveInputSplit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

class CarbonHiveRecordReader
extends CarbonRecordReader<ArrayWritable>
implements RecordReader<Void, ArrayWritable> {
    private ArrayWritable valueObj = null;
    private long recordReaderCounter = 0L;
    private int[] columnIds;

    public CarbonHiveRecordReader(QueryModel queryModel, CarbonReadSupport<ArrayWritable> readSupport, InputSplit inputSplit, JobConf jobConf) throws IOException {
        super(queryModel, readSupport, (Configuration)jobConf);
        this.initialize(inputSplit, (Configuration)jobConf);
    }

    private void initialize(InputSplit inputSplit, Configuration conf) throws IOException {
        if (!(inputSplit instanceof CarbonHiveInputSplit)) {
            throw new RuntimeException("unsupported input split type: " + inputSplit);
        }
        ArrayList<CarbonHiveInputSplit> splitList = new ArrayList<CarbonHiveInputSplit>(1);
        splitList.add((CarbonHiveInputSplit)inputSplit);
        List<TableBlockInfo> tableBlockInfoList = CarbonHiveInputSplit.createBlocks(splitList);
        this.queryModel.setTableBlockInfos(tableBlockInfoList);
        this.readSupport.initialize(this.queryModel.getProjectionColumns(), this.queryModel.getTable());
        this.carbonIterator = new ChunkRowIterator(this.queryExecutor.execute(this.queryModel));
        String colIds = conf.get("hive.io.file.readcolumn.ids");
        String columnTypeProperty = conf.get("columns.types");
        ArrayList columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        if (this.valueObj == null) {
            this.valueObj = new ArrayWritable(Writable.class, new Writable[columnTypes.size()]);
        }
        if (null != colIds && !colIds.equals("")) {
            String[] arraySelectedColId = colIds.split(",");
            this.columnIds = new int[arraySelectedColId.length];
            for (int j = 0; j < arraySelectedColId.length; ++j) {
                this.columnIds[j] = Integer.parseInt(arraySelectedColId[j]);
            }
        }
    }

    public boolean next(Void aVoid, ArrayWritable value) {
        if (this.carbonIterator.hasNext()) {
            Object obj = this.readSupport.readRow((Object[])this.carbonIterator.next());
            ++this.recordReaderCounter;
            Writable[] objArray = (Writable[])obj;
            Writable[] sysArray = new Writable[value.get().length];
            if (this.columnIds != null && this.columnIds.length > 0 && objArray.length == this.columnIds.length) {
                for (int i = 0; i < this.columnIds.length; ++i) {
                    sysArray[this.columnIds[i]] = objArray[i];
                }
                value.set(sysArray);
            } else {
                value.set(objArray);
            }
            return true;
        }
        try {
            this.queryExecutor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public Void createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() {
        return this.recordReaderCounter;
    }

    public float getProgress() {
        return 0.0f;
    }
}

