/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hive.CarbonHiveRow;
import org.apache.carbondata.hive.HiveDataTypeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

@SerDeSpec(schemaProps={"columns", "columns.types"})
public class CarbonHiveSerDe
extends AbstractSerDe {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonHiveSerDe.class.getCanonicalName());
    private final SerDeStats stats = new SerDeStats();
    private ObjectInspector objInspector;
    private LAST_OPERATION status;
    private long serializedSize;
    private long deserializedSize;

    public void initialize(@Nullable Configuration configuration, Properties tbl) throws SerDeException {
        assert (configuration != null);
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
        ArrayList<TypeInfo> columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        this.inferSchema(tbl, columnNames, columnTypes);
        TypeInfo rowTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        this.objInspector = new ArrayWritableObjectInspector((StructTypeInfo)rowTypeInfo);
        this.serializedSize = 0L;
        this.deserializedSize = 0L;
        this.status = LAST_OPERATION.UNKNOWN;
    }

    private void inferSchema(Properties tbl, List<String> columnNames, List<TypeInfo> columnTypes) {
        if (columnNames.size() == 0 && columnTypes.size() == 0) {
            String[] names;
            String external = tbl.getProperty("EXTERNAL");
            String location = CarbonUtil.checkAndAppendFileSystemURIScheme((String)tbl.getProperty("location"));
            if (external != null && "TRUE".equals(external) && location != null && (names = tbl.getProperty("name").split("\\.")).length == 2) {
                AbsoluteTableIdentifier identifier = AbsoluteTableIdentifier.from((String)location, (String)names[0], (String)names[1]);
                String schemaPath = CarbonTablePath.getSchemaFilePath((String)identifier.getTablePath());
                try {
                    TableInfo tableInfo = null;
                    tableInfo = !FileFactory.isFileExist((String)schemaPath) ? SchemaReader.inferSchema((AbsoluteTableIdentifier)identifier, (boolean)false) : SchemaReader.getTableInfo((AbsoluteTableIdentifier)identifier);
                    if (tableInfo != null) {
                        CarbonTable carbonTable = CarbonTable.buildFromTableInfo((TableInfo)tableInfo);
                        List columns = carbonTable.getCreateOrderColumn();
                        for (CarbonColumn column : columns) {
                            columnNames.add(column.getColName());
                            columnTypes.add(HiveDataTypeUtils.convertCarbonDataTypeToHive(column));
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)("Failed to infer schema: " + ex.getMessage()));
                }
            }
        }
    }

    public Class<? extends Writable> getSerializedClass() {
        return ArrayWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objectInspector) throws SerDeException {
        if (!this.objInspector.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            throw new SerDeException("Cannot serializeStartKey " + this.objInspector.getCategory() + ". Can only serializeStartKey a struct");
        }
        this.serializedSize += (long)((StructObjectInspector)this.objInspector).getAllStructFieldRefs().size();
        this.status = LAST_OPERATION.SERIALIZE;
        return this.createCarbonRow(obj, (StructObjectInspector)objectInspector);
    }

    private CarbonHiveRow createCarbonRow(Object obj, StructObjectInspector inspector) throws SerDeException {
        List fields = inspector.getAllStructFieldRefs();
        CarbonHiveRow carbonHiveRow = new CarbonHiveRow();
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = (StructField)fields.get(i);
            Object subObj = inspector.getStructFieldData(obj, field);
            ObjectInspector subInspector = field.getFieldObjectInspector();
            carbonHiveRow.addToRow(this.createObject(subObj, subInspector));
        }
        return carbonHiveRow;
    }

    private Object[] createStruct(Object obj, StructObjectInspector inspector) throws SerDeException {
        List fields = inspector.getAllStructFieldRefs();
        Object[] arr = new Object[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = (StructField)fields.get(i);
            Object subObj = inspector.getStructFieldData(obj, field);
            ObjectInspector subInspector = field.getFieldObjectInspector();
            arr[i] = this.createObject(subObj, subInspector);
        }
        return arr;
    }

    private Object[] createArray(Object obj, ListObjectInspector inspector) throws SerDeException {
        List sourceArray = inspector.getList(obj);
        ObjectInspector subInspector = inspector.getListElementObjectInspector();
        ArrayList<Object> array = new ArrayList<Object>();
        if (sourceArray != null) {
            for (Object curObj : sourceArray) {
                Object newObj = this.createObject(curObj, subInspector);
                if (newObj == null) continue;
                array.add(newObj);
            }
        }
        return array.toArray();
    }

    private Object createPrimitive(Object obj, PrimitiveObjectInspector inspector) throws SerDeException {
        if (obj == null) {
            return null;
        }
        return inspector.getPrimitiveWritableObject(obj).toString();
    }

    private Object createObject(Object obj, ObjectInspector inspector) throws SerDeException {
        switch (inspector.getCategory()) {
            case STRUCT: {
                return this.createStruct(obj, (StructObjectInspector)inspector);
            }
            case LIST: {
                return this.createArray(obj, (ListObjectInspector)inspector);
            }
            case PRIMITIVE: {
                return this.createPrimitive(obj, (PrimitiveObjectInspector)inspector);
            }
            case MAP: {
                return this.createMap(obj, (MapObjectInspector)inspector);
            }
        }
        throw new SerDeException("Unknown data type" + inspector.getCategory());
    }

    private Object[] createMap(Object obj, MapObjectInspector inspector) throws SerDeException {
        Map map = inspector.getMap(obj);
        Object[] result = new Object[map.size()];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            result[i++] = new Object[]{this.createObject(entry.getKey(), inspector.getMapKeyObjectInspector()), this.createObject(entry.getValue(), inspector.getMapValueObjectInspector())};
        }
        return result;
    }

    public SerDeStats getSerDeStats() {
        assert (this.status != LAST_OPERATION.UNKNOWN);
        if (this.status == LAST_OPERATION.SERIALIZE) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.deserializedSize);
        }
        return this.stats;
    }

    public Object deserialize(Writable writable) {
        this.status = LAST_OPERATION.DESERIALIZE;
        if (writable instanceof ArrayWritable) {
            this.deserializedSize += (long)((StructObjectInspector)this.objInspector).getAllStructFieldRefs().size();
            return writable;
        }
        return null;
    }

    public ObjectInspector getObjectInspector() {
        return this.objInspector;
    }

    private static enum LAST_OPERATION {
        SERIALIZE,
        DESERIALIZE,
        UNKNOWN;

    }
}

