/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.ListExpression;
import org.apache.carbondata.core.scan.expression.conditional.NotEqualsExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.carbondata.hive.util.DataTypeUtil;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.log4j.Logger;

public class Hive2CarbonExpression {
    public static final int left = 0;
    public static final int right = 1;
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbonInputFormat.class.getName());

    private static String getExpressionValue(ExprNodeDesc exprNodeDesc) {
        if (exprNodeDesc instanceof ExprNodeConstantDesc) {
            return ((ExprNodeConstantDesc)exprNodeDesc).getValue().toString();
        }
        return exprNodeDesc.getExprString().replace("'", "");
    }

    public static Expression convertExprHive2Carbon(ExprNodeDesc exprNodeDesc) {
        if (exprNodeDesc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)exprNodeDesc;
            GenericUDF udf = exprNodeGenericFuncDesc.getGenericUDF();
            List l1 = exprNodeGenericFuncDesc.getChildren();
            if (udf instanceof GenericUDFIn) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                ArrayList<LiteralExpression> listExpr = new ArrayList<LiteralExpression>();
                for (int i = 1; i < l1.size(); ++i) {
                    LiteralExpression literalExpression = new LiteralExpression((Object)Hive2CarbonExpression.getExpressionValue((ExprNodeDesc)l1.get(i)), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                    listExpr.add(literalExpression);
                }
                ListExpression listExpression = new ListExpression(listExpr);
                return new InExpression((Expression)columnExpression, (Expression)listExpression);
            }
            if (udf instanceof GenericUDFOPOr) {
                Expression leftExpression = Hive2CarbonExpression.convertExprHive2Carbon((ExprNodeDesc)exprNodeGenericFuncDesc.getChildren().get(0));
                Expression rightExpression = Hive2CarbonExpression.convertExprHive2Carbon((ExprNodeDesc)exprNodeGenericFuncDesc.getChildren().get(1));
                return new OrExpression(leftExpression, rightExpression);
            }
            if (udf instanceof GenericUDFOPAnd) {
                Expression leftExpression = Hive2CarbonExpression.convertExprHive2Carbon((ExprNodeDesc)exprNodeGenericFuncDesc.getChildren().get(0));
                Expression rightExpression = Hive2CarbonExpression.convertExprHive2Carbon((ExprNodeDesc)exprNodeGenericFuncDesc.getChildren().get(1));
                return new AndExpression(leftExpression, rightExpression);
            }
            if (udf instanceof GenericUDFOPEqual) {
                ColumnExpression columnExpression = null;
                if (l1.get(0) instanceof ExprNodeFieldDesc) {
                    throw new UnsupportedOperationException("Complex types are not supported for PPD");
                }
                columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression((Object)Hive2CarbonExpression.getExpressionValue((ExprNodeDesc)l1.get(1)), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(1)).getTypeString()));
                return new EqualToExpression((Expression)columnExpression, (Expression)literalExpression);
            }
            if (udf instanceof GenericUDFOPEqualOrGreaterThan) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression((Object)Hive2CarbonExpression.getExpressionValue((ExprNodeDesc)l1.get(1)), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                return new GreaterThanEqualToExpression((Expression)columnExpression, (Expression)literalExpression);
            }
            if (udf instanceof GenericUDFOPGreaterThan) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression((Object)Hive2CarbonExpression.getExpressionValue((ExprNodeDesc)l1.get(1)), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                return new GreaterThanExpression((Expression)columnExpression, (Expression)literalExpression);
            }
            if (udf instanceof GenericUDFOPNotEqual) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression((Object)Hive2CarbonExpression.getExpressionValue((ExprNodeDesc)l1.get(1)), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                return new NotEqualsExpression((Expression)columnExpression, (Expression)literalExpression);
            }
            if (udf instanceof GenericUDFOPEqualOrLessThan) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression((Object)Hive2CarbonExpression.getExpressionValue((ExprNodeDesc)l1.get(1)), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                return new LessThanEqualToExpression((Expression)columnExpression, (Expression)literalExpression);
            }
            if (udf instanceof GenericUDFOPLessThan) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression((Object)Hive2CarbonExpression.getExpressionValue((ExprNodeDesc)l1.get(1)), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                return new LessThanExpression((Expression)columnExpression, (Expression)literalExpression);
            }
            if (udf instanceof GenericUDFOPNull) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression(null, null);
                return new EqualToExpression((Expression)columnExpression, (Expression)literalExpression, true);
            }
            if (udf instanceof GenericUDFOPNotNull) {
                ColumnExpression columnExpression = new ColumnExpression((String)((ExprNodeDesc)l1.get(0)).getCols().get(0), Hive2CarbonExpression.getDateType(((ExprNodeDesc)l1.get(0)).getTypeString()));
                LiteralExpression literalExpression = new LiteralExpression(null, null);
                return new NotEqualsExpression((Expression)columnExpression, (Expression)literalExpression, true);
            }
            LOG.error((Object)("error:not find type" + udf.toString()));
        }
        return null;
    }

    public static DataType getDateType(String type) {
        try {
            return DataTypeUtil.convertHiveTypeToCarbon(type);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

