/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveDataTypeUtils {
    public static TypeInfo convertCarbonDataTypeToHive(CarbonColumn column) {
        int id = column.getDataType().getId();
        if (id == DataTypes.STRING.getId()) {
            return TypeInfoFactory.stringTypeInfo;
        }
        if (id == DataTypes.DATE.getId()) {
            return TypeInfoFactory.dateTypeInfo;
        }
        if (id == DataTypes.TIMESTAMP.getId()) {
            return TypeInfoFactory.timestampTypeInfo;
        }
        if (id == DataTypes.BOOLEAN.getId()) {
            return TypeInfoFactory.booleanTypeInfo;
        }
        if (id == DataTypes.BYTE.getId()) {
            return TypeInfoFactory.byteTypeInfo;
        }
        if (id == DataTypes.SHORT.getId()) {
            return TypeInfoFactory.shortTypeInfo;
        }
        if (id == DataTypes.INT.getId()) {
            return TypeInfoFactory.intTypeInfo;
        }
        if (id == DataTypes.LONG.getId()) {
            return TypeInfoFactory.longTypeInfo;
        }
        if (id == DataTypes.FLOAT.getId()) {
            return TypeInfoFactory.floatTypeInfo;
        }
        if (id == DataTypes.DOUBLE.getId()) {
            return TypeInfoFactory.doubleTypeInfo;
        }
        if (id == 10) {
            DecimalType type = (DecimalType)column.getDataType();
            return new DecimalTypeInfo(type.getPrecision(), type.getScale());
        }
        if (id == DataTypes.BINARY.getId()) {
            return TypeInfoFactory.binaryTypeInfo;
        }
        if (id == 11) {
            ListTypeInfo typeInfo = new ListTypeInfo();
            if (!(column instanceof CarbonDimension)) {
                throw new RuntimeException("Failed to get child columns of column: " + column.getColName());
            }
            typeInfo.setListElementTypeInfo(HiveDataTypeUtils.convertCarbonDataTypeToHive((CarbonColumn)((CarbonDimension)column).getListOfChildDimensions().get(0)));
            return typeInfo;
        }
        if (id == 12) {
            StructTypeInfo typeInfo = new StructTypeInfo();
            if (!(column instanceof CarbonDimension)) {
                throw new RuntimeException("Failed to get child columns of column: " + column.getColName());
            }
            List listOfChildDimensions = ((CarbonDimension)column).getListOfChildDimensions();
            ArrayList<String> allStructFieldNames = new ArrayList<String>(listOfChildDimensions.size());
            ArrayList<TypeInfo> allStructFieldTypeInfos = new ArrayList<TypeInfo>(listOfChildDimensions.size());
            typeInfo.setAllStructFieldNames(allStructFieldNames);
            typeInfo.setAllStructFieldTypeInfos(allStructFieldTypeInfos);
            for (CarbonDimension dimension : listOfChildDimensions) {
                String[] columnsNames = dimension.getColName().split("\\.");
                allStructFieldNames.add(columnsNames[columnsNames.length - 1]);
                allStructFieldTypeInfos.add(HiveDataTypeUtils.convertCarbonDataTypeToHive((CarbonColumn)dimension));
            }
            return typeInfo;
        }
        if (id == 13) {
            MapTypeInfo typeInfo = new MapTypeInfo();
            List listOfChildDimensions = ((CarbonDimension)((CarbonDimension)column).getListOfChildDimensions().get(0)).getListOfChildDimensions();
            typeInfo.setMapKeyTypeInfo(HiveDataTypeUtils.convertCarbonDataTypeToHive((CarbonColumn)listOfChildDimensions.get(0)));
            typeInfo.setMapValueTypeInfo(HiveDataTypeUtils.convertCarbonDataTypeToHive((CarbonColumn)listOfChildDimensions.get(1)));
            return typeInfo;
        }
        if (id == DataTypes.VARCHAR.getId()) {
            return TypeInfoFactory.varcharTypeInfo;
        }
        throw new RuntimeException("convert DataType with invalid id: " + id);
    }
}

