/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.model.QueryModelBuilder;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonFileInputFormat;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.hive.CarbonHiveInputSplit;
import org.apache.carbondata.hive.CarbonHiveRecordReader;
import org.apache.carbondata.hive.Hive2CarbonExpression;
import org.apache.carbondata.hive.WritableReadSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.log4j.Logger;

public class MapredCarbonInputFormat
extends CarbonTableInputFormat<ArrayWritable>
implements InputFormat<Void, ArrayWritable>,
CombineHiveInputFormat.AvoidSplitCombination {
    private static final String CARBON_TABLE = "mapreduce.input.carboninputformat.table";
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)MapredCarbonInputFormat.class.getCanonicalName());

    private static void populateCarbonTable(Configuration configuration, String paths) throws IOException, InvalidConfigurationException {
        CarbonTable carbonTable;
        if (null != paths) {
            AbsoluteTableIdentifier absoluteTableIdentifier = AbsoluteTableIdentifier.from((String)configuration.get("location"), (String)MapredCarbonInputFormat.getDatabaseName((Configuration)configuration), (String)MapredCarbonInputFormat.getTableName((Configuration)configuration));
            String schemaPath = CarbonTablePath.getSchemaFilePath((String)absoluteTableIdentifier.getTablePath(), (Configuration)configuration);
            if (FileFactory.getCarbonFile((String)schemaPath).exists()) {
                carbonTable = SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)absoluteTableIdentifier);
            } else {
                carbonTable = CarbonTable.buildFromTableInfo((TableInfo)SchemaReader.inferSchema((AbsoluteTableIdentifier)absoluteTableIdentifier, (boolean)false));
                carbonTable.setTransactionalTable(false);
            }
        } else {
            throw new InvalidPathException("No input paths specified in job");
        }
        configuration.set(CARBON_TABLE, ObjectSerializationUtil.convertObjectToString((Object)carbonTable));
        MapredCarbonInputFormat.setTableInfo((Configuration)configuration, (TableInfo)carbonTable.getTableInfo());
    }

    private static CarbonTable getCarbonTable(Configuration configuration, String path) throws IOException, InvalidConfigurationException {
        MapredCarbonInputFormat.populateCarbonTable(configuration, path);
        String carbonTableStr = configuration.get(CARBON_TABLE);
        return (CarbonTable)ObjectSerializationUtil.convertStringToObject((String)carbonTableStr);
    }

    public InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        CarbonTableInputFormat carbonInputFormat;
        CarbonTable carbonTable;
        jobConf.set("mapreduce.input.carboninputformat.databaseName", "_dummyDb_" + UUID.randomUUID().toString());
        jobConf.set("mapreduce.input.carboninputformat.tableName", "_dummyTable_" + UUID.randomUUID().toString());
        Job jobContext = Job.getInstance((Configuration)jobConf);
        try {
            carbonTable = MapredCarbonInputFormat.getCarbonTable(jobContext.getConfiguration(), jobContext.getConfiguration().get("location"));
        }
        catch (Exception e) {
            throw new IOException("Unable read Carbon Schema: ", e);
        }
        ArrayList<String> partitionNames = new ArrayList<String>();
        if (carbonTable.isHivePartitionTable()) {
            String partitionPath = FileFactory.getCarbonFile((String)jobContext.getConfiguration().get("mapreduce.input.fileinputformat.inputdir")).getAbsolutePath();
            partitionNames.add(partitionPath.substring(carbonTable.getTablePath().length()));
            ArrayList<PartitionSpec> partitionSpec = new ArrayList<PartitionSpec>();
            partitionSpec.add(new PartitionSpec(partitionNames, partitionPath));
            MapredCarbonInputFormat.setPartitionsToPrune((Configuration)jobContext.getConfiguration(), partitionSpec);
        }
        try {
            this.setFilterPredicates(jobContext.getConfiguration(), carbonTable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (carbonTable.isTransactionalTable()) {
            carbonInputFormat = new CarbonTableInputFormat();
            jobContext.getConfiguration().set("mapreduce.input.carboninputformat.transactional", "true");
        } else {
            carbonInputFormat = new CarbonFileInputFormat();
        }
        List splitList = carbonInputFormat.getSplits((JobContext)jobContext);
        InputSplit[] splits = new InputSplit[splitList.size()];
        for (int i = 0; i < splitList.size(); ++i) {
            CarbonInputSplit split = (CarbonInputSplit)splitList.get(i);
            CarbonHiveInputSplit inputSplit = new CarbonHiveInputSplit(split.getSegmentId(), split.getPath(), split.getStart(), split.getLength(), split.getLocations(), split.getNumberOfBlocklets(), split.getVersion(), split.getBlockStorageIdMap(), split.getDetailInfo());
            splits[i] = inputSplit;
        }
        return splits;
    }

    protected void setFilterPredicates(Configuration configuration, CarbonTable carbonTable) {
        try {
            String expr = configuration.get("hive.io.filter.expr.serialized");
            if (expr == null) {
                return;
            }
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)SerializationUtilities.deserializeObject((String)expr, ExprNodeGenericFuncDesc.class);
            LOGGER.debug((Object)("hive expression:" + exprNodeGenericFuncDesc.getGenericUDF()));
            LOGGER.debug((Object)("hive expression string:" + exprNodeGenericFuncDesc.getExprString()));
            Expression expression = Hive2CarbonExpression.convertExprHive2Carbon((ExprNodeDesc)exprNodeGenericFuncDesc);
            if (expression == null) {
                return;
            }
            LOGGER.debug((Object)("carbon expression:" + expression.getString()));
            IndexFilter filter = new IndexFilter(carbonTable, expression, true);
            CarbonInputFormat.setFilterPredicates((Configuration)configuration, (IndexFilter)filter);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading filter expression", e);
        }
    }

    public RecordReader<Void, ArrayWritable> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        QueryModel queryModel;
        String path = null;
        if (inputSplit instanceof CarbonHiveInputSplit) {
            path = ((CarbonHiveInputSplit)inputSplit).getPath().toString();
        }
        try {
            jobConf.set("mapreduce.input.carboninputformat.databaseName", "_dummyDb_" + UUID.randomUUID().toString());
            jobConf.set("mapreduce.input.carboninputformat.tableName", "_dummyTable_" + UUID.randomUUID().toString());
            queryModel = this.getQueryModel((Configuration)jobConf, path);
        }
        catch (InvalidConfigurationException e) {
            LOGGER.error((Object)("Failed to create record reader: " + e.getMessage()), (Throwable)e);
            return null;
        }
        WritableReadSupport<ArrayWritable> readSupport = new WritableReadSupport<ArrayWritable>();
        return new CarbonHiveRecordReader(queryModel, readSupport, inputSplit, jobConf);
    }

    private QueryModel getQueryModel(Configuration configuration, String path) throws IOException, InvalidConfigurationException {
        CarbonTable carbonTable = MapredCarbonInputFormat.getCarbonTable(configuration, path);
        String projectionString = this.getProjection(configuration, carbonTable);
        String[] projectionColumns = projectionString.split(",");
        return new QueryModelBuilder(carbonTable).projectColumns(projectionColumns).filterExpression(this.getFilterPredicates(configuration)).dataConverter((DataTypeConverter)new DataTypeConverterImpl()).build();
    }

    private String getProjection(Configuration configuration, CarbonTable carbonTable) {
        String projection = MapredCarbonInputFormat.getColumnProjection((Configuration)configuration);
        if (projection == null) {
            projection = configuration.get("hive.io.file.readcolumn.names");
        }
        List carbonColumns = carbonTable.getCreateOrderColumn();
        ArrayList<String> carbonColumnNames = new ArrayList<String>();
        StringBuilder allColumns = new StringBuilder();
        StringBuilder projectionColumns = new StringBuilder();
        for (CarbonColumn column : carbonColumns) {
            carbonColumnNames.add(column.getColName().toLowerCase());
            allColumns.append(column.getColName()).append(",");
        }
        if (null != projection && !projection.equals("")) {
            String[] columnNames;
            for (String col : columnNames = projection.split(",")) {
                if (!carbonColumnNames.contains(col.toLowerCase())) continue;
                projectionColumns.append(col).append(",");
            }
            return projectionColumns.substring(0, projectionColumns.lastIndexOf(","));
        }
        return allColumns.substring(0, allColumns.lastIndexOf(","));
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) {
        return true;
    }
}

