/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.hadoop.api.CarbonOutputCommitter;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hive.MapredCarbonOutputFormat;
import org.apache.carbondata.hive.util.HiveCarbonUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;

public class MapredCarbonOutputCommitter
extends OutputCommitter {
    private CarbonOutputCommitter carbonOutputCommitter;
    private final Logger LOGGER = LogServiceFactory.getLogService((String)((Object)((Object)this)).getClass().getName());

    public void setupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)jobContext.getConfiguration());
        String a = jobContext.getJobConf().get("mapreduce.map.env");
        Random random = new Random();
        JobID jobId = new JobID(UUID.randomUUID().toString(), 0);
        TaskID task = new TaskID(jobId, TaskType.MAP, random.nextInt());
        TaskAttemptID attemptID = new TaskAttemptID(task, random.nextInt());
        TaskAttemptContextImpl context = new TaskAttemptContextImpl((Configuration)jobContext.getJobConf(), attemptID);
        CarbonLoadModel carbonLoadModel = HiveCarbonUtil.getCarbonLoadModel(jobContext.getConfiguration());
        CarbonTableOutputFormat.setLoadModel((Configuration)jobContext.getConfiguration(), (CarbonLoadModel)carbonLoadModel);
        this.carbonOutputCommitter = new CarbonOutputCommitter(new Path(carbonLoadModel.getTablePath()), (TaskAttemptContext)context);
        this.carbonOutputCommitter.setupJob((JobContext)jobContext);
        String loadModelStr = jobContext.getConfiguration().get("mapreduce.carbontable.load.model");
        jobContext.getJobConf().set("mapreduce.map.env", a + ",carbon=" + loadModelStr);
        jobContext.getJobConf().set("mapreduce.reduce.env", a + ",carbon=" + loadModelStr);
    }

    public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
    }

    public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
        return false;
    }

    public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
    }

    public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext) throws IOException {
    }

    public void abortJob(org.apache.hadoop.mapred.JobContext jobContext, int status) throws IOException {
        if (this.carbonOutputCommitter != null) {
            this.carbonOutputCommitter.abortJob((JobContext)jobContext, JobStatus.State.FAILED);
            throw new RuntimeException("Failed to commit Job");
        }
    }

    public void commitJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        try {
            Configuration configuration = jobContext.getConfiguration();
            CarbonLoadModel carbonLoadModel = MapredCarbonOutputFormat.getLoadModel((Configuration)configuration);
            ThreadLocalSessionInfo.unsetAll();
            SegmentFileStore.writeSegmentFile((CarbonTable)carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable(), (String)carbonLoadModel.getSegmentId(), (String)String.valueOf(carbonLoadModel.getFactTimeStamp()));
            SegmentFileStore.mergeIndexAndWriteSegmentFile((CarbonTable)carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable(), (String)carbonLoadModel.getSegmentId(), (String)String.valueOf(carbonLoadModel.getFactTimeStamp()));
            CarbonTableOutputFormat.setLoadModel((Configuration)configuration, (CarbonLoadModel)carbonLoadModel);
            this.carbonOutputCommitter.commitJob((JobContext)jobContext);
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e);
            throw e;
        }
    }
}

