/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.hive.CarbonHiveRow;
import org.apache.carbondata.hive.util.HiveCarbonUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.Progressable;

public class MapredCarbonOutputFormat<T>
extends CarbonTableOutputFormat
implements HiveOutputFormat<Void, T>,
OutputFormat<Void, T> {
    public RecordWriter<Void, T> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s, Progressable progressable) throws IOException {
        throw new RuntimeException("Should never be used");
    }

    public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) throws IOException {
    }

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)jc);
        CarbonLoadModel carbonLoadModel = null;
        String encodedString = jc.get("mapreduce.carbontable.load.model");
        carbonLoadModel = encodedString != null ? (CarbonLoadModel)ObjectSerializationUtil.convertStringToObject((String)encodedString) : ((encodedString = System.getenv("carbon")) != null ? (CarbonLoadModel)ObjectSerializationUtil.convertStringToObject((String)encodedString) : HiveCarbonUtil.getCarbonLoadModel(tableProperties, (Configuration)jc));
        for (Map.Entry<Object, Object> entry : tableProperties.entrySet()) {
            carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getTableInfo().getFactTable().getTableProperties().put(entry.getKey().toString().toLowerCase(), entry.getValue().toString().toLowerCase());
        }
        final String tablePath = FileFactory.getCarbonFile((String)carbonLoadModel.getTablePath()).getAbsolutePath();
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)jc.get("mapred.task.id"));
        final TaskAttemptContextImpl context = new TaskAttemptContextImpl((Configuration)jc, taskAttemptID);
        carbonLoadModel.setTaskNo("" + taskAttemptID.getTaskID().getId());
        final boolean isHivePartitionedTable = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().isHivePartitionTable();
        PartitionInfo partitionInfo = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getPartitionInfo();
        final int partitionColumn = partitionInfo != null ? partitionInfo.getColumnSchemaList().size() : 0;
        final String finalOutputPath = FileFactory.getCarbonFile((String)finalOutPath.toString()).getAbsolutePath();
        if (carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().isHivePartitionTable()) {
            carbonLoadModel.getMetrics().addToPartitionPath(finalOutputPath);
            context.getConfiguration().set("carbon.outputformat.writepath", finalOutputPath);
        }
        CarbonTableOutputFormat.setLoadModel((Configuration)jc, (CarbonLoadModel)carbonLoadModel);
        final org.apache.hadoop.mapreduce.RecordWriter re = super.getRecordWriter((TaskAttemptContext)context);
        return new FileSinkOperator.RecordWriter(){

            public void write(Writable writable) throws IOException {
                try {
                    ObjectArrayWritable objectArrayWritable = new ObjectArrayWritable();
                    if (isHivePartitionedTable) {
                        Object[] actualRow = ((CarbonHiveRow)writable).getData();
                        Object[] newData = Arrays.copyOf(actualRow, actualRow.length + partitionColumn);
                        String[] partitionValues = finalOutputPath.substring(tablePath.length()).split("/");
                        int i = actualRow.length;
                        for (int j = 0; j < partitionValues.length; ++j) {
                            if (!partitionValues[j].contains("=")) continue;
                            newData[i++] = partitionValues[j].split("=")[1];
                        }
                        objectArrayWritable.set(newData);
                    } else {
                        objectArrayWritable.set(((CarbonHiveRow)writable).getData());
                    }
                    re.write((Object)NullWritable.get(), (Object)objectArrayWritable);
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getCause());
                }
            }

            public void close(boolean b) throws IOException {
                try {
                    re.close((TaskAttemptContext)context);
                    ThreadLocalSessionInfo.setConfigurationToCurrentThread((Configuration)context.getConfiguration());
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    static {
        CarbonProperties.getInstance().addProperty("carbon.writtenby.app.name", "hive");
    }
}

