/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class WritableReadSupport<T>
implements CarbonReadSupport<T> {
    protected CarbonColumn[] carbonColumns;
    protected Writable[] writableArr;

    public void initialize(CarbonColumn[] carbonColumns, CarbonTable carbonTable) {
        this.carbonColumns = carbonColumns;
    }

    public T readRow(Object[] data) {
        this.writableArr = new Writable[data.length];
        for (int i = 0; i < data.length; ++i) {
            try {
                this.writableArr[i] = this.createWritableObject(data[i], this.carbonColumns[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)this.writableArr;
    }

    private Writable createWritableObject(Object obj, CarbonColumn carbonColumn) throws IOException {
        DataType dataType = carbonColumn.getDataType();
        if (DataTypes.isStructType((DataType)dataType)) {
            return this.createStruct(obj, carbonColumn);
        }
        if (DataTypes.isArrayType((DataType)dataType)) {
            return this.createArray(obj, carbonColumn);
        }
        if (DataTypes.isMapType((DataType)dataType)) {
            return this.createMap(obj, carbonColumn);
        }
        return this.createWritablePrimitive(obj, carbonColumn);
    }

    private ArrayWritable createArray(Object obj, CarbonColumn carbonColumn) throws IOException {
        Object[] objArray = (Object[])obj;
        List childCarbonDimensions = null;
        CarbonDimension arrayDimension = null;
        if (carbonColumn.isDimension().booleanValue() && carbonColumn.getColumnSchema().getNumberOfChild() > 0) {
            childCarbonDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            arrayDimension = (CarbonDimension)childCarbonDimensions.get(0);
        }
        ArrayList<Writable> array = new ArrayList<Writable>();
        if (objArray != null) {
            for (int i = 0; i < objArray.length; ++i) {
                Object curObj = objArray[i];
                Writable newObj = this.createWritableObject(curObj, (CarbonColumn)arrayDimension);
                array.add(newObj);
            }
        }
        if (array.size() > 0) {
            return new ArrayWritable(Writable.class, array.toArray(new Writable[array.size()]));
        }
        return null;
    }

    private ArrayWritable createStruct(Object obj, CarbonColumn carbonColumn) throws IOException {
        Object[] objArray = (Object[])obj;
        List childCarbonDimensions = null;
        if (carbonColumn.isDimension().booleanValue() && carbonColumn.getColumnSchema().getNumberOfChild() > 0) {
            childCarbonDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
        }
        if (null != childCarbonDimensions) {
            Writable[] arr = new Writable[objArray.length];
            for (int i = 0; i < objArray.length; ++i) {
                arr[i] = this.createWritableObject(objArray[i], (CarbonColumn)childCarbonDimensions.get(i));
            }
            return new ArrayWritable(Writable.class, arr);
        }
        return null;
    }

    private Writable createMap(Object obj, CarbonColumn carbonColumn) throws IOException {
        Object[] objArray = (Object[])obj;
        List childCarbonDimensions = null;
        CarbonDimension mapDimension = null;
        if (carbonColumn.isDimension().booleanValue() && carbonColumn.getColumnSchema().getNumberOfChild() > 0 && null != (mapDimension = (CarbonDimension)(childCarbonDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions()).get(0))) {
            childCarbonDimensions = mapDimension.getListOfChildDimensions();
        }
        HashMap<Writable, Writable> rawMap = new HashMap<Writable, Writable>();
        if (null != childCarbonDimensions && childCarbonDimensions.size() == 2) {
            Object[] keyObjects = (Object[])objArray[0];
            Object[] valObjects = (Object[])objArray[1];
            for (int i = 0; i < keyObjects.length; ++i) {
                Writable keyWritable = this.createWritableObject(keyObjects[i], (CarbonColumn)childCarbonDimensions.get(0));
                Writable valWritable = this.createWritableObject(valObjects[i], (CarbonColumn)childCarbonDimensions.get(1));
                rawMap.put(keyWritable, valWritable);
            }
        }
        MapWritable mapWritable = new MapWritable();
        mapWritable.putAll(rawMap);
        return mapWritable;
    }

    private Writable createWritablePrimitive(Object obj, CarbonColumn carbonColumn) throws IOException {
        DataType dataType = carbonColumn.getDataType();
        if (obj == null) {
            return null;
        }
        if (dataType == DataTypes.NULL) {
            return null;
        }
        if (dataType == DataTypes.DOUBLE) {
            return new DoubleWritable(((Double)obj).doubleValue());
        }
        if (dataType == DataTypes.INT) {
            return new IntWritable(((Integer)obj).intValue());
        }
        if (dataType == DataTypes.LONG) {
            return new LongWritable(((Long)obj).longValue());
        }
        if (dataType == DataTypes.SHORT) {
            return new ShortWritable(((Short)obj).shortValue());
        }
        if (dataType == DataTypes.BOOLEAN) {
            return new BooleanWritable(((Boolean)obj).booleanValue());
        }
        if (dataType == DataTypes.VARCHAR) {
            return new Text(obj.toString());
        }
        if (dataType == DataTypes.BINARY) {
            return new BytesWritable((byte[])obj);
        }
        if (dataType == DataTypes.DATE) {
            return new DateWritableV2(((Integer)obj).intValue());
        }
        if (dataType == DataTypes.TIMESTAMP) {
            WritableTimestampObjectInspector ins = new WritableTimestampObjectInspector();
            return ins.getPrimitiveWritableObject(ins.create(new Timestamp((Long)obj / 1000L)));
        }
        if (dataType == DataTypes.STRING) {
            return new Text(obj.toString());
        }
        if (DataTypes.isArrayType((DataType)dataType)) {
            return this.createArray(obj, carbonColumn);
        }
        if (DataTypes.isStructType((DataType)dataType)) {
            return this.createStruct(obj, carbonColumn);
        }
        if (DataTypes.isMapType((DataType)dataType)) {
            return this.createMap(obj, carbonColumn);
        }
        if (DataTypes.isDecimal((DataType)dataType)) {
            return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)new BigDecimal(obj.toString())));
        }
        if (dataType == DataTypes.FLOAT) {
            return new FloatWritable(((Float)obj).floatValue());
        }
        throw new IOException("unsupported data type:" + dataType);
    }
}

