/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive.util;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;

public class DataTypeUtil {
    public static DataType convertHiveTypeToCarbon(String type) throws SQLException {
        if ("string".equalsIgnoreCase(type) || type.startsWith("char")) {
            return DataTypes.STRING;
        }
        if ("varchar".equalsIgnoreCase(type)) {
            return DataTypes.VARCHAR;
        }
        if ("float".equalsIgnoreCase(type)) {
            return DataTypes.FLOAT;
        }
        if ("double".equalsIgnoreCase(type)) {
            return DataTypes.DOUBLE;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return DataTypes.BOOLEAN;
        }
        if ("tinyint".equalsIgnoreCase(type) || "smallint".equalsIgnoreCase(type)) {
            return DataTypes.SHORT;
        }
        if ("int".equalsIgnoreCase(type)) {
            return DataTypes.INT;
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return DataTypes.LONG;
        }
        if ("date".equalsIgnoreCase(type)) {
            return DataTypes.DATE;
        }
        if ("timestamp".equalsIgnoreCase(type)) {
            return DataTypes.TIMESTAMP;
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return DataTypes.createDefaultDecimalType();
        }
        if ("binary".equalsIgnoreCase(type)) {
            return DataTypes.BINARY;
        }
        if ("map".equalsIgnoreCase(type)) {
            return DataTypes.createDefaultMapType();
        }
        if (type.startsWith("decimal")) {
            String[] precisionScale = type.substring(type.indexOf("(") + 1, type.lastIndexOf(")")).split(",");
            return DataTypes.createDecimalType((int)Integer.parseInt(precisionScale[0]), (int)Integer.parseInt(precisionScale[1]));
        }
        if (type.startsWith("array<")) {
            String subType = type.substring(type.indexOf("<") + 1, type.indexOf(">"));
            return DataTypes.createArrayType((DataType)DataTypeUtil.convertHiveTypeToCarbon(subType));
        }
        if (type.startsWith("map<")) {
            String[] subType = type.substring(type.indexOf("<") + 1, type.indexOf(">")).split(",");
            return DataTypes.createMapType((DataType)DataTypeUtil.convertHiveTypeToCarbon(subType[0]), (DataType)DataTypeUtil.convertHiveTypeToCarbon(subType[1]));
        }
        if (type.startsWith("struct<")) {
            String[] subTypes = type.substring(type.indexOf("<") + 1, type.indexOf(">")).split(",");
            ArrayList<StructField> structFieldList = new ArrayList<StructField>();
            for (String subType : subTypes) {
                String[] nameAndType = subType.split(":");
                structFieldList.add(new StructField(nameAndType[0], DataTypeUtil.convertHiveTypeToCarbon(nameAndType[1])));
            }
            return DataTypes.createStructType(structFieldList);
        }
        throw new SQLException("Unrecognized column type: " + type);
    }
}

