/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hive.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.common.Strings;
import org.apache.carbondata.common.exceptions.sql.InvalidLoadOptionException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.Field;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.SchemaEvolution;
import org.apache.carbondata.core.metadata.schema.SchemaEvolutionEntry;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.TableSchemaBuilder;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataLoadMetrics;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.ThriftWriter;
import org.apache.carbondata.hive.util.DataTypeUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.model.CarbonLoadModelBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class HiveCarbonUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)HiveCarbonUtil.class.getName());

    public static CarbonLoadModel getCarbonLoadModel(Configuration tableProperties) {
        String[] tableUniqueName = tableProperties.get("name").split("\\.");
        String databaseName = tableUniqueName[0];
        String tableName = tableUniqueName[1];
        String tablePath = tableProperties.get("location");
        String columns = tableProperties.get("columns");
        String sortColumns = tableProperties.get("sort_columns");
        String columnTypes = tableProperties.get("columns.types");
        String partitionColumns = tableProperties.get("partition_columns");
        String partitionColumnTypes = tableProperties.get("partition_columns.types");
        if (partitionColumns != null) {
            columns = columns + "," + partitionColumns;
            columnTypes = columnTypes + ":" + partitionColumnTypes;
        }
        String[] columnTypeArray = HiveCarbonUtil.splitSchemaStringToArray(columnTypes);
        String complexDelim = tableProperties.get("complex_delimiter", "");
        CarbonLoadModel carbonLoadModel = HiveCarbonUtil.getCarbonLoadModel(tableName, databaseName, tablePath, sortColumns, columns.split(","), columnTypeArray, tableProperties);
        carbonLoadModel.setCarbonTransactionalTable(true);
        carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().setTransactionalTable(true);
        for (String delim : complexDelim.split(",")) {
            carbonLoadModel.setComplexDelimiter(delim);
        }
        return carbonLoadModel;
    }

    public static CarbonLoadModel getCarbonLoadModel(Properties tableProperties, Configuration configuration) {
        String[] tableUniqueName = tableProperties.getProperty("name").split("\\.");
        String databaseName = tableUniqueName[0];
        String tableName = tableUniqueName[1];
        String tablePath = tableProperties.getProperty("location");
        String columns = tableProperties.getProperty("columns");
        String sortColumns = tableProperties.getProperty("sort_columns");
        String[] columnTypes = HiveCarbonUtil.splitSchemaStringToArray(tableProperties.getProperty("columns.types"));
        String complexDelim = tableProperties.getProperty("complex_delimiter", "");
        CarbonLoadModel carbonLoadModel = HiveCarbonUtil.getCarbonLoadModel(tableName, databaseName, tablePath, sortColumns, columns.split(","), columnTypes, configuration);
        for (String delim : complexDelim.split(",")) {
            carbonLoadModel.setComplexDelimiter(delim);
        }
        return carbonLoadModel;
    }

    public static CarbonLoadModel getCarbonLoadModel(String tableName, String databaseName, String location, String sortColumnsString, String[] columns, String[] columnTypes, Configuration configuration) {
        CarbonLoadModel loadModel;
        CarbonTable carbonTable;
        try {
            String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)location);
            AbsoluteTableIdentifier absoluteTableIdentifier = AbsoluteTableIdentifier.from((String)location, (String)databaseName, (String)tableName, (String)"");
            if (FileFactory.getCarbonFile((String)schemaFilePath).exists()) {
                carbonTable = SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)absoluteTableIdentifier);
            } else {
                String carbonDataFile = CarbonUtil.getFilePathExternalFilePath((String)location, (Configuration)configuration);
                carbonTable = carbonDataFile == null ? CarbonTable.buildFromTableInfo((TableInfo)HiveCarbonUtil.getTableInfo(tableName, databaseName, location, sortColumnsString, columns, columnTypes, new ArrayList<String>())) : CarbonTable.buildFromTableInfo((TableInfo)SchemaReader.inferSchema((AbsoluteTableIdentifier)absoluteTableIdentifier, (boolean)false, (Configuration)configuration));
                carbonTable.setTransactionalTable(false);
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Unable to fetch schema for the table: " + tableName, e);
        }
        CarbonLoadModelBuilder carbonLoadModelBuilder = new CarbonLoadModelBuilder(carbonTable);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("fileheader", Strings.mkString((String[])columns, (String)","));
        try {
            loadModel = carbonLoadModelBuilder.build(options, System.currentTimeMillis(), "");
        }
        catch (IOException | InvalidLoadOptionException e) {
            throw new RuntimeException(e);
        }
        loadModel.setSkipParsers();
        loadModel.setMetrics(new DataLoadMetrics());
        return loadModel;
    }

    private static TableInfo getTableInfo(String tableName, String databaseName, String location, String sortColumnsString, String[] columns, String[] columnTypes, List<String> partitionColumns) throws SQLException {
        TableInfo tableInfo = new TableInfo();
        TableSchemaBuilder builder = new TableSchemaBuilder();
        builder.tableName(tableName);
        List<Object> sortColumns = new ArrayList();
        if (sortColumnsString != null) {
            sortColumns = Arrays.asList(sortColumnsString.toLowerCase().split("\\,"));
        }
        PartitionInfo partitionInfo = null;
        AtomicInteger integer = new AtomicInteger();
        ArrayList<StructField> partitionStructFields = new ArrayList<StructField>();
        for (int i = 0; i < columns.length; ++i) {
            DataType dataType = DataTypeUtil.convertHiveTypeToCarbon(columnTypes[i]);
            Field field = new Field(columns[i].toLowerCase(), dataType);
            if (partitionColumns.contains(columns[i])) {
                partitionStructFields.add(new StructField(columns[i].toLowerCase(), dataType, field.getChildren()));
                continue;
            }
            builder.addColumn(new StructField(columns[i].toLowerCase(), dataType, field.getChildren()), integer, sortColumns.contains(columns[i]), false);
        }
        if (!partitionStructFields.isEmpty()) {
            ArrayList<ColumnSchema> partitionColumnSchemas = new ArrayList<ColumnSchema>();
            for (StructField partitionStructField : partitionStructFields) {
                partitionColumnSchemas.add(builder.addColumn(partitionStructField, integer, sortColumns.contains(partitionStructField.getFieldName()), false));
            }
            partitionInfo = new PartitionInfo(partitionColumnSchemas, PartitionType.NATIVE_HIVE);
        }
        TableSchema tableSchema = builder.build();
        SchemaEvolution schemaEvol = new SchemaEvolution();
        ArrayList<SchemaEvolutionEntry> schemaEvolutionEntry = new ArrayList<SchemaEvolutionEntry>();
        schemaEvolutionEntry.add(new SchemaEvolutionEntry());
        schemaEvol.setSchemaEvolutionEntryList(schemaEvolutionEntry);
        tableSchema.setSchemaEvolution(schemaEvol);
        tableSchema.setPartitionInfo(partitionInfo);
        tableInfo.setDatabaseName(databaseName);
        tableInfo.setTablePath(location);
        tableInfo.setFactTable(tableSchema);
        return tableInfo;
    }

    private static void writeSchemaFile(TableInfo tableInfo) throws IOException {
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        String schemaFilePath = CarbonTablePath.getSchemaFilePath((String)tableInfo.getTablePath());
        String metadataPath = CarbonTablePath.getMetadataPath((String)tableInfo.getTablePath());
        FileFactory.mkdirs((String)metadataPath);
        ThriftWriter thriftWriter = new ThriftWriter(schemaFilePath, false);
        thriftWriter.open(FileWriteOperation.OVERWRITE);
        thriftWriter.write((TBase)schemaConverter.fromWrapperToExternalTableInfo(tableInfo, tableInfo.getDatabaseName(), tableInfo.getFactTable().getTableName()));
        thriftWriter.close();
        FileFactory.getCarbonFile((String)schemaFilePath).setLastModifiedTime(System.currentTimeMillis());
    }

    public static HiveMetaHook getMetaHook() {
        return new HiveMetaHook(){

            public void preCreateTable(Table table) throws MetaException {
            }

            public void rollbackCreateTable(Table table) throws MetaException {
                this.commitDropTable(table, false);
            }

            public void commitCreateTable(Table table) throws MetaException {
                try {
                    List fieldSchemas = table.getSd().getCols();
                    String[] columns = new String[fieldSchemas.size() + table.getPartitionKeys().size()];
                    String[] columnTypes = new String[fieldSchemas.size() + table.getPartitionKeys().size()];
                    int i = 0;
                    for (Object fieldSchema : table.getSd().getCols()) {
                        columns[i] = fieldSchema.getName();
                        columnTypes[i++] = fieldSchema.getType();
                    }
                    ArrayList<String> partitionColumns = new ArrayList<String>();
                    for (FieldSchema partitionCol : table.getPartitionKeys()) {
                        columns[i] = partitionCol.getName().toLowerCase();
                        columnTypes[i++] = partitionCol.getType();
                        partitionColumns.add(partitionCol.getName().toLowerCase());
                    }
                    TableInfo tableInfo = HiveCarbonUtil.getTableInfo(table.getTableName(), table.getDbName(), table.getSd().getLocation(), table.getParameters().getOrDefault("sort_columns", ""), columns, columnTypes, partitionColumns);
                    tableInfo.getFactTable().getTableProperties().putAll(table.getParameters());
                    HiveCarbonUtil.writeSchemaFile(tableInfo);
                }
                catch (IOException | SQLException e) {
                    LOGGER.error((Object)e);
                    throw new MetaException("Problem while writing schema file: " + e.getMessage());
                }
            }

            public void preDropTable(Table table) throws MetaException {
            }

            public void rollbackDropTable(Table table) throws MetaException {
            }

            public void commitDropTable(Table table, boolean b) throws MetaException {
                FileFactory.deleteAllFilesOfDir((File)new File(table.getSd().getLocation()));
            }
        };
    }

    public static String[] splitSchemaStringToArray(String schema) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder stack = new StringBuilder();
        int openingCount = 0;
        for (int i = 0; i < schema.length(); ++i) {
            if (schema.charAt(i) == '<') {
                ++openingCount;
                stack.append(schema.charAt(i));
                continue;
            }
            if (schema.charAt(i) == '>') {
                --openingCount;
                if (i == schema.length() - 1) {
                    stack.append(schema.charAt(i));
                    tokens.add(stack.toString());
                    stack = new StringBuilder();
                    openingCount = 0;
                    continue;
                }
                stack.append(schema.charAt(i));
                continue;
            }
            if (schema.charAt(i) == ':' && openingCount > 0) {
                stack.append(schema.charAt(i));
                continue;
            }
            if (schema.charAt(i) == ':' && openingCount == 0) {
                tokens.add(stack.toString());
                stack = new StringBuilder();
                openingCount = 0;
                continue;
            }
            if (i == schema.length() - 1) {
                stack.append(schema.charAt(i));
                tokens.add(stack.toString());
                stack = new StringBuilder();
                openingCount = 0;
                continue;
            }
            stack.append(schema.charAt(i));
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

