/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.common.algorithm;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class SequenceUtils {
    private SequenceUtils() {
    }

    public static <T extends Comparable<T>> Iterator<T> union(List<Iterator<T>> iterators) {
        return SequenceUtils.merge(iterators, false);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Iterator<T> union(Iterator<T> ... iterators) {
        return SequenceUtils.union(Arrays.asList(iterators));
    }

    public static <T extends Comparable<T>> Iterator<T> merge(List<Iterator<T>> iterators, final boolean keepDuplication) {
        final PriorityQueue<PeekingIterator> pq = new PriorityQueue<PeekingIterator>(Comparator.comparing(PeekingIterator::peek));
        for (Iterator<T> itr : iterators) {
            if (!itr.hasNext()) continue;
            pq.add(Iterators.peekingIterator(itr));
        }
        return new Iterator<T>(){
            T next;

            @Override
            public boolean hasNext() {
                if (pq.isEmpty()) {
                    return false;
                }
                if (keepDuplication) {
                    PeekingIterator curr = (PeekingIterator)pq.poll();
                    this.next = (Comparable)curr.next();
                    if (curr.hasNext()) {
                        pq.add(curr);
                    }
                    return true;
                }
                PeekingIterator curr = (PeekingIterator)pq.poll();
                this.next = (Comparable)curr.next();
                if (curr.hasNext()) {
                    pq.add(curr);
                }
                while (!pq.isEmpty()) {
                    PeekingIterator it = (PeekingIterator)pq.poll();
                    if (((Comparable)it.peek()).equals(this.next)) {
                        it.next();
                        if (!it.hasNext()) continue;
                        pq.add(it);
                        continue;
                    }
                    pq.add(it);
                    return true;
                }
                return true;
            }

            @Override
            public T next() {
                return this.next;
            }
        };
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Iterator<T> merge(boolean keepDuplication, Iterator<T> ... iterators) {
        return SequenceUtils.merge(Arrays.asList(iterators), keepDuplication);
    }

    public static <T extends Comparable<T>> Iterator<T> intersect(final List<Iterator<T>> iterators) {
        return new Iterator<T>(){
            T nextVal;
            {
                this.search();
            }

            @Override
            public boolean hasNext() {
                return this.nextVal != null;
            }

            @Override
            public T next() {
                Object commonValToReturn = this.nextVal;
                this.search();
                return commonValToReturn;
            }

            void search() {
                int i;
                this.nextVal = null;
                Object[] heads = new Comparable[iterators.size()];
                Object min = null;
                int minIn = -1;
                for (i = 0; i < iterators.size(); ++i) {
                    if (!((Iterator)iterators.get(i)).hasNext()) {
                        return;
                    }
                    heads[i] = (Comparable)((Iterator)iterators.get(i)).next();
                    if (min != null && heads[i].compareTo(min) >= 0) continue;
                    min = heads[i];
                    minIn = i;
                }
                block1: while (true) {
                    this.nextVal = (Comparable)SequenceUtils.allEquals(heads);
                    if (this.nextVal != null || !((Iterator)iterators.get(minIn)).hasNext()) break;
                    heads[minIn] = (Comparable)((Iterator)iterators.get(minIn)).next();
                    min = heads[minIn];
                    i = 0;
                    while (true) {
                        if (i >= heads.length) continue block1;
                        if (heads[i].compareTo(min) < 0) {
                            min = heads[i];
                            minIn = i;
                        }
                        ++i;
                    }
                    break;
                }
            }
        };
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Iterator<T> intersect(Iterator<T> ... iterators) {
        return SequenceUtils.intersect(Arrays.asList(iterators));
    }

    private static <T> T allEquals(T[] arr) {
        if (arr.length < 1) {
            return null;
        }
        T current = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i].equals(current)) continue;
            return null;
        }
        return current;
    }
}

