/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.common.filesystem;

import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.UUID;

public class TempFolder
implements AutoCloseable {
    private static final Logger LOG = Logger.get(TempFolder.class);
    private final String prefix;
    private File root;

    public TempFolder() {
        this("");
    }

    public TempFolder(String user) {
        this.prefix = "hetu-tmp-folder-" + user;
    }

    public TempFolder create() throws IOException {
        this.root = Files.createTempDirectory(this.prefix, new FileAttribute[0]).toFile();
        return this;
    }

    public File getRoot() {
        return this.root;
    }

    public File newFile() throws IOException {
        return this.newFile("file-" + UUID.randomUUID().toString());
    }

    public File newFile(String relativePath) throws IOException {
        File newFile = this.root.toPath().resolve(relativePath).toFile();
        if (newFile.createNewFile()) {
            return newFile;
        }
        throw new IOException("Not able to create file " + relativePath);
    }

    public File newFolder() throws IOException {
        return this.newFolder("folder-" + UUID.randomUUID().toString());
    }

    public File newFolder(String relativePath) throws IOException {
        File newFolder = this.root.toPath().resolve(relativePath).toFile();
        if (newFolder.mkdir()) {
            return newFolder;
        }
        throw new IOException("Not able to create folder " + relativePath);
    }

    @Override
    public void close() {
        if (this.root != null && this.root.exists()) {
            for (int i = 0; i < 3; ++i) {
                if (!this.deleteRecursively(this.root)) continue;
                return;
            }
            if (!this.root.exists()) {
                return;
            }
            LOG.warn("Temporary folder can not be deleted. Shutdown hook added: " + this.root.toPath().toAbsolutePath());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.walk(this.root.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException e) {
                    LOG.warn("Temporary folder not deleted. Manual deletion required: " + this.root.toPath().toAbsolutePath());
                }
            }));
        }
    }

    private boolean deleteRecursively(File fileToDelete) {
        if (fileToDelete.delete()) {
            return true;
        }
        File[] files = fileToDelete.listFiles();
        if (files != null) {
            for (File fileInDir : files) {
                if (this.deleteRecursively(fileInDir)) continue;
                return false;
            }
        }
        return fileToDelete.delete();
    }
}

