/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public final class SecureObjectInputStream
extends ObjectInputStream {
    private String[] acceptedClasses;

    public SecureObjectInputStream(InputStream in, String ... acceptedClasses) throws IOException {
        super(in);
        this.acceptedClasses = acceptedClasses;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.acceptedClasses != null && this.acceptedClasses.length != 0) {
            boolean matchFound = false;
            String className = desc.getName();
            for (String acceptedClass : this.acceptedClasses) {
                if (!className.equals(acceptedClass)) continue;
                matchFound = true;
                break;
            }
            if (!matchFound) {
                throw new InvalidClassException(desc.getName() + " not supported.");
            }
        }
        return super.resolveClass(desc);
    }
}

