/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SecurePathWhiteList {
    private static Set<String> securePathwhiteList = new HashSet<String>(Arrays.asList("/tmp", "/opt/hetu", "/opt/openlookeng", "/etc/hetu", "/etc/openlookeng", System.getProperty("java.io.tmpdir")));

    private SecurePathWhiteList() {
    }

    public static Set<String> getSecurePathWhiteList() throws IOException {
        if (new File(".").getCanonicalPath().equals("/")) {
            throw new IllegalArgumentException("Current workspace can't be root directory,please make sure you have config node.data-dir in node.properties or don't put your bin directory under root directory");
        }
        securePathwhiteList.add(new File("..").getCanonicalPath());
        return securePathwhiteList;
    }

    public static boolean isSecurePath(Path absolutePath) throws IOException {
        return SecurePathWhiteList.isSecurePath(absolutePath.toString());
    }

    public static boolean isSecurePath(String absolutePath) throws IOException {
        if (absolutePath.startsWith("/")) {
            return SecurePathWhiteList.getSecurePathWhiteList().stream().filter(securePath -> absolutePath.startsWith((String)securePath)).findAny().isPresent();
        }
        return true;
    }
}

