/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.common.util;

import io.airlift.log.Logger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SslSocketUtil {
    private static final Logger log = Logger.get(SslSocketUtil.class);
    private static final int MIN_PORT_NUMBER = 1100;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final AtomicInteger nextPortToTry = new AtomicInteger(60000);

    private SslSocketUtil() {
    }

    public static Optional<SSLContext> buildSslContext(boolean tlsEnabled) throws GeneralSecurityException {
        if (!tlsEnabled) {
            return Optional.empty();
        }
        return Optional.of(SSLContext.getDefault());
    }

    public static int getAvailablePort() {
        while (!SslSocketUtil.isPortAvailable(nextPortToTry.get())) {
            nextPortToTry.getAndIncrement();
        }
        return nextPortToTry.getAndIncrement();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortAvailable(int port) {
        if (port < 1100 || port > 65535) {
            throw new IllegalArgumentException(String.format("Invalid port: %s, the port number must range from %s to %s", port, 1100, 65535));
        }
        ServerSocketFactory sslServerSocketFactory = SSLServerSocketFactory.getDefault();
        try (SSLServerSocket socket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Port " + port + " was unavailable.");
            return false;
        }
    }
}

