/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.common.util;

import io.airlift.log.Logger;
import io.airlift.security.pem.PemReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.security.auth.x500.X500Principal;

public class TrustStore {
    private static final Logger LOGGER = Logger.get(TrustStore.class);

    private TrustStore() {
    }

    public static KeyStore loadTrustStore(File trustStorePath, Optional<String> trustStorePassword) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            List certificateChain = PemReader.readCertificateChain((File)trustStorePath);
            if (!certificateChain.isEmpty()) {
                trustStore.load(null, null);
                for (X509Certificate certificate : certificateChain) {
                    X500Principal principal = certificate.getSubjectX500Principal();
                    trustStore.setCertificateEntry(principal.getName(), certificate);
                }
                return trustStore;
            }
        }
        catch (IOException | GeneralSecurityException ignored) {
            LOGGER.error("loadTrustStore error : %s", new Object[]{ignored.getMessage()});
        }
        try (FileInputStream in = new FileInputStream(trustStorePath);){
            trustStore.load(in, trustStorePassword.map(String::toCharArray).orElse(null));
        }
        return trustStore;
    }
}

