/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.cache;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.CarbonLRUCache;
import org.apache.carbondata.core.indexstore.BlockletIndexStore;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public class CacheProvider {
    private static CacheProvider cacheProvider = new CacheProvider();
    private Map<CacheType, Cache> cacheTypeToCacheMap = new HashMap<CacheType, Cache>(16);
    private final Object lock = new Object();
    private CarbonLRUCache carbonLRUCache;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CacheProvider.class.getName());

    private CacheProvider() {
    }

    public static CacheProvider getInstance() {
        return cacheProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> createCache(CacheType cacheType) {
        if (!this.isCacheExists(cacheType)) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isCacheExists(cacheType)) {
                    if (null == this.carbonLRUCache) {
                        this.createLRULevelCacheInstance();
                    }
                    this.createBlockletIndexCache(cacheType);
                }
            }
        }
        return this.cacheTypeToCacheMap.get(cacheType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> createCache(CacheType cacheType, String cacheClassName) throws Exception {
        if (!this.isCacheExists(cacheType)) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isCacheExists(cacheType)) {
                    if (null == this.carbonLRUCache) {
                        this.createLRULevelCacheInstance();
                    }
                    Class<?> clazz = Class.forName(cacheClassName);
                    Constructor<?> constructor = clazz.getConstructors()[0];
                    constructor.setAccessible(true);
                    Cache cacheObject = (Cache)constructor.newInstance(this.carbonLRUCache);
                    this.cacheTypeToCacheMap.put(cacheType, cacheObject);
                }
            }
        }
        return this.cacheTypeToCacheMap.get(cacheType);
    }

    private void createBlockletIndexCache(CacheType cacheType) {
        BlockletIndexStore cacheObject = null;
        if (cacheType.equals(CacheType.DRIVER_BLOCKLET_INDEX)) {
            cacheObject = new BlockletIndexStore(this.carbonLRUCache);
        }
        this.cacheTypeToCacheMap.put(cacheType, cacheObject);
    }

    private void createLRULevelCacheInstance() {
        boolean isDriver = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("is.driver.instance", "false"));
        if (isDriver) {
            this.carbonLRUCache = new CarbonLRUCache("carbon.max.driver.lru.cache.size", "-1");
        } else {
            String executorCacheSize = CarbonProperties.getInstance().getProperty("carbon.max.executor.lru.cache.size");
            if (null != executorCacheSize) {
                this.carbonLRUCache = new CarbonLRUCache("carbon.max.executor.lru.cache.size", "-1");
            } else {
                LOGGER.info((Object)"Executor LRU cache size not configured. Initializing with driver LRU cache size.");
                this.carbonLRUCache = new CarbonLRUCache("carbon.max.driver.lru.cache.size", "-1");
            }
        }
    }

    private boolean isCacheExists(CacheType cacheType) {
        return null != this.cacheTypeToCacheMap.get(cacheType);
    }

    public CarbonLRUCache getCarbonCache() {
        return this.carbonLRUCache;
    }
}

