/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.Cacheable;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public final class CarbonLRUCache {
    private static final int BYTE_CONVERSION_CONSTANT = 0x100000;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonLRUCache.class.getName());
    private ExpiringMap<String, Cacheable> expiringMap;
    private long lruCacheMemorySize;
    private long currentSize;

    public CarbonLRUCache(String propertyName, String defaultPropertyName) {
        try {
            this.lruCacheMemorySize = Long.parseLong(CarbonProperties.getInstance().getProperty(propertyName, defaultPropertyName));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"carbon.max.driver.lru.cache.size is not in a valid format. Falling back to default value: -1");
            this.lruCacheMemorySize = Long.parseLong(defaultPropertyName);
        }
        if (this.isBeyondMaxMemory()) {
            double changeSize = this.getPartOfXmx();
            LOGGER.warn((Object)("Configured LRU size " + this.lruCacheMemorySize + "MB exceeds the max size of JVM heap. Carbon will fallback to use " + changeSize + " MB instead"));
            this.lruCacheMemorySize = (long)changeSize;
        }
        this.initCache();
        if (this.lruCacheMemorySize > 0L) {
            LOGGER.info((Object)("Configured LRU cache size is " + this.lruCacheMemorySize + " MB"));
            this.lruCacheMemorySize *= 0x100000L;
        } else {
            LOGGER.info((Object)"LRU cache size not configured. Therefore default behavior will be considered and no LRU based eviction of columns will be done");
        }
    }

    private void initCache() {
        this.expiringMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.ACCESSED).variableExpiration().build();
    }

    private List<String> getKeysToBeRemoved(long size) {
        ArrayList<String> toBeDeletedKeys = new ArrayList<String>(16);
        long removedSize = 0L;
        for (Map.Entry entry : this.expiringMap.entrySet()) {
            String key = (String)entry.getKey();
            Cacheable cacheInfo = (Cacheable)entry.getValue();
            long memorySize = cacheInfo.getMemorySize();
            if (!this.canBeRemoved(cacheInfo)) continue;
            removedSize += memorySize;
            toBeDeletedKeys.add(key);
            if (this.lruCacheMemorySize >= this.currentSize - memorySize + size) {
                toBeDeletedKeys.clear();
                toBeDeletedKeys.add(key);
                removedSize = memorySize;
                break;
            }
            if (this.lruCacheMemorySize < this.currentSize - removedSize + size) continue;
            break;
        }
        if (this.currentSize - removedSize + size > this.lruCacheMemorySize) {
            toBeDeletedKeys.clear();
        }
        return toBeDeletedKeys;
    }

    private boolean canBeRemoved(Cacheable cacheInfo) {
        return cacheInfo.getAccessCount() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        ExpiringMap<String, Cacheable> expiringMap = this.expiringMap;
        synchronized (expiringMap) {
            this.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<String> keys) {
        ExpiringMap<String, Cacheable> expiringMap = this.expiringMap;
        synchronized (expiringMap) {
            for (String key : keys) {
                this.removeKey(key);
            }
        }
    }

    private void removeKey(String key) {
        Cacheable cacheable = (Cacheable)this.expiringMap.get((Object)key);
        if (null != cacheable) {
            long memorySize = cacheable.getMemorySize();
            cacheable.invalidate();
            this.expiringMap.remove((Object)key);
            this.currentSize -= memorySize;
            LOGGER.info((Object)("Removed entry from InMemory lru cache :: " + key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String columnIdentifier, Cacheable cacheInfo, long requiredSize, long expiration_time) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Required size for entry " + columnIdentifier + " :: " + requiredSize + " Current cache size :: " + this.currentSize));
        }
        boolean columnKeyAddedSuccessfully = false;
        if (this.isLRUCacheSizeConfigured()) {
            ExpiringMap<String, Cacheable> expiringMap = this.expiringMap;
            synchronized (expiringMap) {
                if (this.freeMemorySizeForAddingCache(requiredSize)) {
                    this.currentSize += requiredSize;
                    this.addEntryToLRUCacheMap(columnIdentifier, cacheInfo, expiration_time);
                    columnKeyAddedSuccessfully = true;
                } else {
                    LOGGER.error((Object)("Size not available. Entry cannot be added to lru cache :: " + columnIdentifier + " .Required Size = " + requiredSize + " Size available " + (this.lruCacheMemorySize - this.currentSize)));
                }
            }
        }
        ExpiringMap<String, Cacheable> expiringMap = this.expiringMap;
        synchronized (expiringMap) {
            this.addEntryToLRUCacheMap(columnIdentifier, cacheInfo, expiration_time);
            this.currentSize += requiredSize;
        }
        columnKeyAddedSuccessfully = true;
        return columnKeyAddedSuccessfully;
    }

    private void addEntryToLRUCacheMap(String columnIdentifier, Cacheable cacheInfo, long expirationTimeSeconds) {
        if (null == this.expiringMap.get((Object)columnIdentifier) && expirationTimeSeconds != 0L) {
            this.expiringMap.put((Object)columnIdentifier, (Object)cacheInfo, ExpirationPolicy.ACCESSED, expirationTimeSeconds, TimeUnit.SECONDS);
        } else {
            this.expiringMap.putIfAbsent((Object)columnIdentifier, (Object)cacheInfo);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added entry to InMemory lru cache :: " + columnIdentifier));
        }
    }

    private boolean isLRUCacheSizeConfigured() {
        return this.lruCacheMemorySize > 0L;
    }

    private boolean freeMemorySizeForAddingCache(long requiredSize) {
        boolean memoryAvailable = false;
        if (this.isSizeAvailableToLoadColumnDictionary(requiredSize)) {
            memoryAvailable = true;
        } else {
            List<String> keysToBeRemoved = this.getKeysToBeRemoved(requiredSize);
            for (String cacheKey : keysToBeRemoved) {
                this.removeKey(cacheKey);
            }
            if (this.isSizeAvailableToLoadColumnDictionary(requiredSize)) {
                memoryAvailable = true;
            }
        }
        return memoryAvailable;
    }

    private boolean isSizeAvailableToLoadColumnDictionary(long requiredSize) {
        return this.lruCacheMemorySize >= this.currentSize + requiredSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable get(String key) {
        ExpiringMap<String, Cacheable> expiringMap = this.expiringMap;
        synchronized (expiringMap) {
            return (Cacheable)this.expiringMap.get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ExpiringMap<String, Cacheable> expiringMap = this.expiringMap;
        synchronized (expiringMap) {
            for (Cacheable cachebleObj : this.expiringMap.values()) {
                cachebleObj.invalidate();
            }
            this.expiringMap.clear();
        }
    }

    public Map<String, Cacheable> getCacheMap() {
        return this.expiringMap;
    }

    private boolean isBeyondMaxMemory() {
        long lruSize = this.lruCacheMemorySize * 0x100000L;
        long mSize = Runtime.getRuntime().maxMemory();
        return lruSize >= mSize;
    }

    private double getPartOfXmx() {
        long mSizeMB = Runtime.getRuntime().maxMemory() / 0x100000L;
        return (double)mSizeMB * 0.6;
    }

    public long getCurrentSize() {
        return this.currentSize;
    }
}

