/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.cache.dictionary;

import java.util.Arrays;
import net.jpountz.xxhash.XXHash32;
import org.apache.carbondata.core.util.ByteUtil;

public class DictionaryByteArrayWrapper {
    private byte[] data;
    private XXHash32 xxHash32;

    public DictionaryByteArrayWrapper(byte[] data) {
        this.data = data;
    }

    public DictionaryByteArrayWrapper(byte[] data, XXHash32 xxHash32) {
        this(data);
        this.xxHash32 = xxHash32;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DictionaryByteArrayWrapper otherObjectToCompare = (DictionaryByteArrayWrapper)other;
        if (this.data.length != otherObjectToCompare.data.length) {
            return false;
        }
        return ByteUtil.UnsafeComparer.INSTANCE.equals(this.data, otherObjectToCompare.data);
    }

    public int hashCode() {
        if (null != this.xxHash32) {
            return this.xxHash32.hash(this.data, 0, this.data.length, 0);
        }
        int result = Arrays.hashCode(this.data);
        result = 31 * result;
        return result;
    }

    public byte[] getData() {
        return this.data;
    }
}

