/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.constants;

import java.io.InputStream;
import java.util.Properties;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.log4j.Logger;

public final class CarbonVersionConstants {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonVersionConstants.class.getName());
    private static final String CARBONDATA_VERSION_INFO_FILE = "carbondata-version-info.properties";
    public static final String CARBONDATA_VERSION;
    public static final String CARBONDATA_BRANCH;
    public static final String CARBONDATA_REVISION;
    public static final String CARBONDATA_BUILD_DATE;

    static {
        InputStream resourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(CARBONDATA_VERSION_INFO_FILE);
        Properties props = new Properties();
        try {
            props.load(resourceStream);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error loading properties from carbondata-version-info.properties", (Throwable)e);
        }
        finally {
            if (resourceStream != null) {
                try {
                    resourceStream.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error closing CarbonData build info resource stream", (Throwable)e);
                }
            }
        }
        CARBONDATA_VERSION = props.getProperty("version");
        CARBONDATA_BRANCH = props.getProperty("branch");
        CARBONDATA_REVISION = props.getProperty("revision");
        CARBONDATA_BUILD_DATE = props.getProperty("date");
    }
}

