/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore;

import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;

public class TableSegmentUniqueIdentifier {
    private AbsoluteTableIdentifier absoluteTableIdentifier;
    private String segmentId;

    public TableSegmentUniqueIdentifier(AbsoluteTableIdentifier absoluteTableIdentifier, String segmentId) {
        this.absoluteTableIdentifier = absoluteTableIdentifier;
        this.segmentId = segmentId;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public String getUniqueTableSegmentIdentifier() {
        CarbonTableIdentifier carbonTableIdentifier = this.absoluteTableIdentifier.getCarbonTableIdentifier();
        return carbonTableIdentifier.getDatabaseName() + "/" + carbonTableIdentifier.getTableName() + "_" + carbonTableIdentifier.getTableId() + "/" + this.segmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSegmentUniqueIdentifier that = (TableSegmentUniqueIdentifier)o;
        if (!this.absoluteTableIdentifier.equals(that.absoluteTableIdentifier)) {
            return false;
        }
        return this.segmentId.equals(that.segmentId);
    }

    public int hashCode() {
        int result = this.absoluteTableIdentifier.hashCode();
        result = 31 * result + this.segmentId.hashCode();
        return result;
    }
}

