/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

public class TableSpec {
    private DimensionSpec[] dimensionSpec;
    private MeasureSpec[] measureSpec;
    private List<DimensionSpec> noDictionaryDimensionSpec;
    private int numSimpleDimensions;
    private CarbonTable carbonTable;
    private boolean isUpdateDictDim;
    private boolean isUpdateNoDictDims;
    private int[] dictDimActualPosition;
    private int[] noDictDimActualPosition;

    public TableSpec(CarbonTable carbonTable, boolean keepPartitionColumnsToEnd) {
        this.carbonTable = carbonTable;
        List<CarbonDimension> dimensions = carbonTable.getVisibleDimensions();
        List<CarbonMeasure> measures = carbonTable.getVisibleMeasures();
        if (keepPartitionColumnsToEnd && carbonTable.getPartitionInfo() != null) {
            ArrayList<CarbonDimension> reArrangedDimensions = new ArrayList<CarbonDimension>();
            ArrayList<CarbonMeasure> reArrangedMeasures = new ArrayList<CarbonMeasure>();
            ArrayList<CarbonDimension> partitionDimensions = new ArrayList<CarbonDimension>();
            ArrayList<CarbonMeasure> partitionMeasures = new ArrayList<CarbonMeasure>();
            List<ColumnSchema> columnSchemaList = carbonTable.getPartitionInfo().getColumnSchemaList();
            for (CarbonDimension dim : dimensions) {
                if (columnSchemaList.contains(dim.getColumnSchema())) {
                    partitionDimensions.add(dim);
                    continue;
                }
                reArrangedDimensions.add(dim);
            }
            if (partitionDimensions.size() != 0) {
                reArrangedDimensions.addAll(partitionDimensions);
            }
            for (CarbonMeasure measure : measures) {
                if (columnSchemaList.contains(measure.getColumnSchema())) {
                    partitionMeasures.add(measure);
                    continue;
                }
                reArrangedMeasures.add(measure);
            }
            if (partitionMeasures.size() != 0) {
                reArrangedMeasures.addAll(partitionMeasures);
            }
            dimensions = reArrangedDimensions;
            measures = reArrangedMeasures;
        }
        this.numSimpleDimensions = 0;
        for (CarbonDimension dimension : dimensions) {
            if (dimension.isComplex().booleanValue()) continue;
            ++this.numSimpleDimensions;
        }
        this.dimensionSpec = new DimensionSpec[dimensions.size()];
        this.measureSpec = new MeasureSpec[measures.size()];
        this.noDictionaryDimensionSpec = new ArrayList<DimensionSpec>();
        this.addDimensions(dimensions);
        this.addMeasures(measures);
    }

    private void addDimensions(List<CarbonDimension> dimensions) {
        int i;
        ArrayList<DimensionSpec> dictSortDimSpec = new ArrayList<DimensionSpec>();
        ArrayList<DimensionSpec> noSortDictDimSpec = new ArrayList<DimensionSpec>();
        ArrayList<DimensionSpec> noSortNoDictDimSpec = new ArrayList<DimensionSpec>();
        ArrayList<DimensionSpec> noDictSortDimSpec = new ArrayList<DimensionSpec>();
        ArrayList<DimensionSpec> dictDimensionSpec = new ArrayList<DimensionSpec>();
        int dimIndex = 0;
        short dictActualPosition = 0;
        short noDictActualPosition = 0;
        for (i = 0; i < dimensions.size(); ++i) {
            DimensionSpec spec;
            CarbonDimension dimension = dimensions.get(i);
            if (dimension.isComplex().booleanValue()) {
                short s = noDictActualPosition;
                noDictActualPosition = (short)(noDictActualPosition + 1);
                spec = new DimensionSpec(ColumnType.COMPLEX, dimension, s);
                this.dimensionSpec[dimIndex++] = spec;
                this.noDictionaryDimensionSpec.add(spec);
                noSortNoDictDimSpec.add(spec);
                continue;
            }
            if (dimension.getDataType() == DataTypes.TIMESTAMP) {
                short s = noDictActualPosition;
                noDictActualPosition = (short)(noDictActualPosition + 1);
                spec = new DimensionSpec(ColumnType.PLAIN_VALUE, dimension, s);
                this.dimensionSpec[dimIndex++] = spec;
                this.noDictionaryDimensionSpec.add(spec);
                if (dimension.isSortColumn()) {
                    noDictSortDimSpec.add(spec);
                    continue;
                }
                noSortNoDictDimSpec.add(spec);
                continue;
            }
            if (dimension.getDataType() == DataTypes.DATE) {
                short s = dictActualPosition;
                dictActualPosition = (short)(dictActualPosition + 1);
                spec = new DimensionSpec(ColumnType.DIRECT_DICTIONARY, dimension, s);
                this.dimensionSpec[dimIndex++] = spec;
                dictDimensionSpec.add(spec);
                if (dimension.isSortColumn()) {
                    dictSortDimSpec.add(spec);
                    continue;
                }
                noSortDictDimSpec.add(spec);
                continue;
            }
            short s = noDictActualPosition;
            noDictActualPosition = (short)(noDictActualPosition + 1);
            spec = new DimensionSpec(ColumnType.PLAIN_VALUE, dimension, s);
            this.dimensionSpec[dimIndex++] = spec;
            this.noDictionaryDimensionSpec.add(spec);
            if (dimension.isSortColumn()) {
                noDictSortDimSpec.add(spec);
                continue;
            }
            noSortNoDictDimSpec.add(spec);
        }
        noDictSortDimSpec.addAll(noSortNoDictDimSpec);
        dictSortDimSpec.addAll(noSortDictDimSpec);
        this.dictDimActualPosition = new int[dictSortDimSpec.size()];
        this.noDictDimActualPosition = new int[noDictSortDimSpec.size()];
        for (i = 0; i < this.dictDimActualPosition.length; ++i) {
            this.dictDimActualPosition[i] = ((DimensionSpec)dictSortDimSpec.get(i)).getActualPostion();
        }
        for (i = 0; i < this.noDictDimActualPosition.length; ++i) {
            this.noDictDimActualPosition[i] = ((DimensionSpec)noDictSortDimSpec.get(i)).getActualPostion();
        }
        this.isUpdateNoDictDims = !noDictSortDimSpec.equals(this.noDictionaryDimensionSpec);
        this.isUpdateDictDim = !dictSortDimSpec.equals(dictDimensionSpec);
    }

    private void addMeasures(List<CarbonMeasure> measures) {
        for (int i = 0; i < measures.size(); ++i) {
            CarbonMeasure measure = measures.get(i);
            this.measureSpec[i] = new MeasureSpec(measure.getColName(), measure.getDataType());
        }
    }

    public int[] getDictDimActualPosition() {
        return this.dictDimActualPosition;
    }

    public int[] getNoDictDimActualPosition() {
        return this.noDictDimActualPosition;
    }

    public boolean isUpdateDictDim() {
        return this.isUpdateDictDim;
    }

    public boolean isUpdateNoDictDims() {
        return this.isUpdateNoDictDims;
    }

    public DimensionSpec[] getNoDictAndComplexDimensions() {
        ArrayList<DimensionSpec> noDictAndComplexDimensions = new ArrayList<DimensionSpec>();
        for (int i = 0; i < this.dimensionSpec.length; ++i) {
            if (this.dimensionSpec[i].getColumnType() != ColumnType.PLAIN_VALUE && this.dimensionSpec[i].getColumnType() != ColumnType.COMPLEX_PRIMITIVE && this.dimensionSpec[i].getColumnType() != ColumnType.COMPLEX) continue;
            noDictAndComplexDimensions.add(this.dimensionSpec[i]);
        }
        return noDictAndComplexDimensions.toArray(new DimensionSpec[noDictAndComplexDimensions.size()]);
    }

    public DimensionSpec getDimensionSpec(int dimensionIndex) {
        return this.dimensionSpec[dimensionIndex];
    }

    public List<DimensionSpec> getNoDictionaryDimensionSpec() {
        return this.noDictionaryDimensionSpec;
    }

    public MeasureSpec getMeasureSpec(int measureIndex) {
        return this.measureSpec[measureIndex];
    }

    public int getNumSimpleDimensions() {
        return this.numSimpleDimensions;
    }

    public int getNumDimensions() {
        return this.dimensionSpec.length;
    }

    public int getNumMeasures() {
        return this.measureSpec.length;
    }

    public CarbonTable getCarbonTable() {
        return this.carbonTable;
    }

    public class MeasureSpec
    extends ColumnSpec
    implements Writable {
        MeasureSpec(String fieldName, DataType dataType) {
            super(fieldName, dataType, ColumnType.MEASURE);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
        }
    }

    public class DimensionSpec
    extends ColumnSpec
    implements Writable {
        private boolean inSortColumns;
        private boolean doInvertedIndex;
        private short actualPostion;

        DimensionSpec(ColumnType columnType, CarbonDimension dimension, short actualPostion) {
            super(dimension.getColName(), dimension.getDataType(), columnType);
            this.inSortColumns = dimension.isSortColumn();
            this.doInvertedIndex = dimension.isUseInvertedIndex();
            this.actualPostion = actualPostion;
        }

        public boolean isInSortColumns() {
            return this.inSortColumns;
        }

        public boolean isDoInvertedIndex() {
            return this.doInvertedIndex;
        }

        public short getActualPostion() {
            return this.actualPostion;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
        }
    }

    public static class ColumnSpec
    implements Writable {
        private String fieldName;
        private DataType schemaDataType;
        private ColumnType columnType;

        public ColumnSpec() {
        }

        private ColumnSpec(String fieldName, DataType schemaDataType, ColumnType columnType) {
            this.fieldName = fieldName;
            this.schemaDataType = schemaDataType;
            this.columnType = columnType;
        }

        public static ColumnSpec newInstance(String fieldName, DataType schemaDataType, ColumnType columnType) {
            return new ColumnSpec(fieldName, schemaDataType, columnType);
        }

        public static ColumnSpec newInstanceLegacy(String fieldName, DataType schemaDataType, ColumnType columnType) {
            if (schemaDataType instanceof DecimalType) {
                ((DecimalType)schemaDataType).setPrecision(-1);
                ((DecimalType)schemaDataType).setScale(-1);
            }
            return new ColumnSpec(fieldName, schemaDataType, columnType);
        }

        public DataType getSchemaDataType() {
            return this.schemaDataType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public ColumnType getColumnType() {
            return this.columnType;
        }

        public int getScale() {
            if (DataTypes.isDecimal(this.schemaDataType)) {
                return ((DecimalType)this.schemaDataType).getScale();
            }
            if (this.schemaDataType == DataTypes.BYTE_ARRAY) {
                return -1;
            }
            throw new UnsupportedOperationException();
        }

        public int getPrecision() {
            if (DataTypes.isDecimal(this.schemaDataType)) {
                return ((DecimalType)this.schemaDataType).getPrecision();
            }
            if (this.schemaDataType == DataTypes.BYTE_ARRAY) {
                return -1;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.fieldName);
            out.writeByte(this.schemaDataType.getId());
            out.writeByte(this.columnType.ordinal());
            if (DataTypes.isDecimal(this.schemaDataType)) {
                DecimalType decimalType = (DecimalType)this.schemaDataType;
                out.writeInt(decimalType.getScale());
                out.writeInt(decimalType.getPrecision());
            } else {
                out.writeInt(-1);
                out.writeInt(-1);
            }
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.fieldName = in.readUTF();
            this.schemaDataType = DataTypes.valueOf(in.readByte());
            this.columnType = ColumnType.valueOf(in.readByte());
            int scale = in.readInt();
            int precision = in.readInt();
            if (DataTypes.isDecimal(this.schemaDataType)) {
                DecimalType decimalType = (DecimalType)this.schemaDataType;
                decimalType.setPrecision(precision);
                decimalType.setScale(scale);
            }
        }
    }
}

