/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.block;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.core.cache.Cacheable;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.mutate.DeleteDeltaVo;

public abstract class AbstractIndex
implements Cacheable {
    protected SegmentProperties segmentProperties;
    protected DataRefNode dataRefNode;
    protected AtomicInteger accessCount = new AtomicInteger();
    protected long memorySize;
    private long deleteDeltaTimestamp;
    private Map<String, DeleteDeltaVo> deletedRowsMap;

    public SegmentProperties getSegmentProperties() {
        return this.segmentProperties;
    }

    public DataRefNode getDataRefNode() {
        return this.dataRefNode;
    }

    @Override
    public int getAccessCount() {
        return this.accessCount.get();
    }

    @Override
    public long getMemorySize() {
        return this.memorySize;
    }

    @Override
    public void invalidate() {
    }

    public void incrementAccessCount() {
        this.accessCount.incrementAndGet();
    }

    public void clear() {
        this.decrementAccessCount();
    }

    private void decrementAccessCount() {
        if (this.accessCount.get() > 0) {
            this.accessCount.decrementAndGet();
        }
    }

    public void setMemorySize(long memorySize) {
        this.memorySize = memorySize;
    }

    public long getDeleteDeltaTimestamp() {
        return this.deleteDeltaTimestamp;
    }

    public void setDeleteDeltaTimestamp(long deleteDeltaTimestamp) {
        this.deleteDeltaTimestamp = deleteDeltaTimestamp;
    }

    public Map<String, DeleteDeltaVo> getDeletedRowsMap() {
        return this.deletedRowsMap;
    }

    public void setDeletedRowsMap(Map<String, DeleteDeltaVo> deletedRowsMap) {
        this.deletedRowsMap = deletedRowsMap;
    }
}

