/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.log4j.Logger;

public class SegmentProperties {
    private static final Logger LOG = LogServiceFactory.getLogService((String)SegmentProperties.class.getName());
    private static final int DIMENSIONS_FINGER_PRINTER_SHIFT = 1;
    private static final int MEASURES_FINGER_PRINTER_SHIFT = 2;
    private static final int COMPLEX_FINGER_PRINTER_SHIFT = 3;
    private List<CarbonDimension> dimensions;
    private List<CarbonDimension> complexDimensions;
    private List<CarbonMeasure> measures;
    private Map<Integer, Integer> dimensionOrdinalToChunkMapping;
    private Map<Integer, Set<Integer>> blockTodimensionOrdinalMapping;
    private Map<Integer, Integer> measuresOrdinalToChunkMapping;
    private int numberOfNoDictionaryDimension;
    private int numberOfSortColumns;
    private int numberOfDictDimensions;
    private int numberOfColumnsAfterFlatten;
    private int lastDimensionColOrdinal;
    private long fingerprinter = Long.MAX_VALUE;

    public SegmentProperties(List<ColumnSchema> columnsInTable) {
        this.dimensions = new ArrayList<CarbonDimension>(16);
        this.complexDimensions = new ArrayList<CarbonDimension>(16);
        this.measures = new ArrayList<CarbonMeasure>(16);
        this.fillDimensionAndMeasureDetails(columnsInTable);
        this.dimensionOrdinalToChunkMapping = new HashMap<Integer, Integer>(16);
        this.blockTodimensionOrdinalMapping = new HashMap<Integer, Set<Integer>>(16);
        this.measuresOrdinalToChunkMapping = new HashMap<Integer, Integer>(16);
        this.fillOrdinalToBlockMappingForDimension();
        this.fillOrdinalToChunkIndexMappingForMeasureColumns();
    }

    private void fillOrdinalToBlockMappingForDimension() {
        int index;
        int blockOrdinal = -1;
        CarbonDimension dimension = null;
        for (index = 0; index < this.dimensions.size(); ++index) {
            dimension = this.dimensions.get(index);
            this.dimensionOrdinalToChunkMapping.put(dimension.getOrdinal(), ++blockOrdinal);
        }
        for (index = 0; index < this.complexDimensions.size(); ++index) {
            dimension = this.complexDimensions.get(index);
            this.dimensionOrdinalToChunkMapping.put(dimension.getOrdinal(), ++blockOrdinal);
            blockOrdinal = this.fillComplexDimensionChildBlockIndex(blockOrdinal, dimension);
        }
        this.fillBlockToDimensionOrdinalMapping();
    }

    private void fillBlockToDimensionOrdinalMapping() {
        Set<Map.Entry<Integer, Integer>> blocks = this.dimensionOrdinalToChunkMapping.entrySet();
        for (Map.Entry<Integer, Integer> block : blocks) {
            Set<Integer> dimensionOrdinals = this.blockTodimensionOrdinalMapping.get(block.getValue());
            if (dimensionOrdinals == null) {
                dimensionOrdinals = new HashSet<Integer>(16);
                this.blockTodimensionOrdinalMapping.put(block.getValue(), dimensionOrdinals);
            }
            dimensionOrdinals.add(block.getKey());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SegmentProperties)) {
            return false;
        }
        SegmentProperties segmentProperties = (SegmentProperties)obj;
        if (this.getNumberOfColumns() != segmentProperties.getNumberOfColumns()) {
            return false;
        }
        return this.getFingerprinter() != Long.MIN_VALUE && segmentProperties.getFingerprinter() != Long.MIN_VALUE && this.getFingerprinter() == segmentProperties.getFingerprinter();
    }

    public int hashCode() {
        return super.hashCode();
    }

    private int fillComplexDimensionChildBlockIndex(int blockOrdinal, CarbonDimension dimension) {
        for (int i = 0; i < dimension.getNumberOfChild(); ++i) {
            this.dimensionOrdinalToChunkMapping.put(dimension.getListOfChildDimensions().get(i).getOrdinal(), ++blockOrdinal);
            if (dimension.getListOfChildDimensions().get(i).getNumberOfChild() <= 0) continue;
            blockOrdinal = this.fillComplexDimensionChildBlockIndex(blockOrdinal, dimension.getListOfChildDimensions().get(i));
        }
        return blockOrdinal;
    }

    private void fillOrdinalToChunkIndexMappingForMeasureColumns() {
        int blockOrdinal = 0;
        for (int index = 0; index < this.measures.size(); ++index) {
            this.measuresOrdinalToChunkMapping.put(this.measures.get(index).getOrdinal(), blockOrdinal);
            ++blockOrdinal;
        }
    }

    protected long getFingerprinter() {
        if (this.fingerprinter == Long.MAX_VALUE) {
            long dimensionsFingerPrinter = this.getFingerprinter(this.dimensions.stream().map(t -> t.getColumnSchema()).collect(Collectors.toList()));
            long measuresFingerPrinter = this.getFingerprinter(this.measures.stream().map(t -> t.getColumnSchema()).collect(Collectors.toList()));
            long complexFingerPrinter = this.getFingerprinter(this.complexDimensions.stream().map(t -> t.getColumnSchema()).collect(Collectors.toList()));
            this.fingerprinter = dimensionsFingerPrinter >> 1 ^ measuresFingerPrinter >> 2 ^ complexFingerPrinter >> 3;
        }
        return this.fingerprinter;
    }

    private long getFingerprinter(List<ColumnSchema> columns) {
        ColumnSchema columnSchema = null;
        long fingerprint = Long.MAX_VALUE;
        for (int counter = 0; counter < columns.size(); ++counter) {
            columnSchema = columns.get(counter);
            UUID columnUUID = null;
            try {
                columnUUID = UUID.fromString(columnSchema.getColumnUniqueId());
            }
            catch (Exception e) {
                LOG.error((Object)("Invalid UUID string: " + columnSchema.getColumnUniqueId()));
                return Long.MIN_VALUE;
            }
            long columnUUIDToBits = columnUUID.getMostSignificantBits();
            fingerprint ^= columnUUIDToBits;
        }
        return fingerprint;
    }

    private void fillDimensionAndMeasureDetails(List<ColumnSchema> columnsInTable) {
        ColumnSchema columnSchema = null;
        int dimensionOrdinal = 0;
        int measureOrdinal = -1;
        boolean isComplexDimensionStarted = false;
        CarbonDimension carbonDimension = null;
        int keyOrdinal = 0;
        int counter = 0;
        int complexTypeOrdinal = -1;
        while (counter < columnsInTable.size()) {
            columnSchema = columnsInTable.get(counter);
            if (columnSchema.isDimensionColumn()) {
                if (CarbonUtil.hasEncoding(columnSchema.getEncodingList(), Encoding.DICTIONARY) && !isComplexDimensionStarted && columnSchema.getNumberOfChild() == 0) {
                    ++this.numberOfDictDimensions;
                    ++this.numberOfColumnsAfterFlatten;
                    if (columnSchema.isSortColumn()) {
                        ++this.numberOfSortColumns;
                    }
                    carbonDimension = new CarbonDimension(columnSchema, dimensionOrdinal++, keyOrdinal++, -1);
                } else {
                    if (isComplexDimensionStarted || columnSchema.getDataType().isComplexType()) {
                        carbonDimension = new CarbonDimension(columnSchema, dimensionOrdinal++, -1, ++complexTypeOrdinal);
                        carbonDimension.initializeChildDimensionsList(columnSchema.getNumberOfChild());
                        this.complexDimensions.add(carbonDimension);
                        isComplexDimensionStarted = true;
                        counter = dimensionOrdinal = this.readAllComplexTypeChildren(dimensionOrdinal, columnSchema.getNumberOfChild(), columnsInTable, carbonDimension, complexTypeOrdinal);
                        complexTypeOrdinal = this.assignComplexOrdinal(carbonDimension, complexTypeOrdinal);
                        this.numberOfColumnsAfterFlatten += this.getNumColumnsAfterFlatten(carbonDimension);
                        continue;
                    }
                    carbonDimension = new CarbonDimension(columnSchema, dimensionOrdinal++, -1, -1);
                    ++this.numberOfColumnsAfterFlatten;
                    ++this.numberOfNoDictionaryDimension;
                    if (columnSchema.isSortColumn()) {
                        ++this.numberOfSortColumns;
                    }
                }
                this.dimensions.add(carbonDimension);
            } else {
                ++this.numberOfColumnsAfterFlatten;
                this.measures.add(new CarbonMeasure(columnSchema, ++measureOrdinal));
            }
            ++counter;
        }
        this.lastDimensionColOrdinal = dimensionOrdinal;
    }

    private int readAllComplexTypeChildren(int dimensionOrdinal, int childCount, List<ColumnSchema> listOfColumns, CarbonDimension parentDimension, int complexDimensionOrdinal) {
        for (int i = 0; i < childCount; ++i) {
            ColumnSchema columnSchema = listOfColumns.get(dimensionOrdinal);
            if (!columnSchema.isDimensionColumn()) continue;
            if (columnSchema.getNumberOfChild() > 0) {
                CarbonDimension complexDimension = new CarbonDimension(columnSchema, dimensionOrdinal++, -1, complexDimensionOrdinal++);
                complexDimension.initializeChildDimensionsList(columnSchema.getNumberOfChild());
                parentDimension.getListOfChildDimensions().add(complexDimension);
                dimensionOrdinal = this.readAllComplexTypeChildren(dimensionOrdinal, columnSchema.getNumberOfChild(), listOfColumns, complexDimension, complexDimensionOrdinal);
                continue;
            }
            parentDimension.getListOfChildDimensions().add(new CarbonDimension(columnSchema, dimensionOrdinal++, -1, complexDimensionOrdinal++));
        }
        return dimensionOrdinal;
    }

    private int assignComplexOrdinal(CarbonDimension parentDimension, int complexDimensionOrdinal) {
        for (int i = 0; i < parentDimension.getNumberOfChild(); ++i) {
            CarbonDimension dimension = parentDimension.getListOfChildDimensions().get(i);
            if (dimension.getNumberOfChild() > 0) {
                dimension.setComplexTypeOridnal(++complexDimensionOrdinal);
                complexDimensionOrdinal = this.assignComplexOrdinal(dimension, complexDimensionOrdinal);
                continue;
            }
            parentDimension.getListOfChildDimensions().get(i).setComplexTypeOridnal(++complexDimensionOrdinal);
        }
        return complexDimensionOrdinal;
    }

    public List<CarbonDimension> getDimensions() {
        return this.dimensions;
    }

    public List<CarbonDimension> getComplexDimensions() {
        return this.complexDimensions;
    }

    public List<CarbonMeasure> getMeasures() {
        return this.measures;
    }

    public Map<Integer, Integer> getDimensionOrdinalToChunkMapping() {
        return this.dimensionOrdinalToChunkMapping;
    }

    public Map<Integer, Integer> getMeasuresOrdinalToChunkMapping() {
        return this.measuresOrdinalToChunkMapping;
    }

    public int getNumberOfNoDictionaryDimension() {
        return this.numberOfNoDictionaryDimension;
    }

    public Map<Integer, Set<Integer>> getBlockTodimensionOrdinalMapping() {
        return this.blockTodimensionOrdinalMapping;
    }

    public CarbonDimension getDimensionFromCurrentBlock(CarbonDimension queryDimension) {
        return CarbonUtil.getDimensionFromCurrentBlock(this.dimensions, queryDimension);
    }

    public CarbonMeasure getMeasureFromCurrentBlock(CarbonMeasure measureToBeSearched) {
        return CarbonUtil.getMeasureFromCurrentBlock(this.measures, measureToBeSearched);
    }

    public int getNumberOfSortColumns() {
        return this.numberOfSortColumns;
    }

    public int getLastDimensionColOrdinal() {
        return this.lastDimensionColOrdinal;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumnsAfterFlatten;
    }

    public int getNumberOfDictDimensions() {
        return this.numberOfDictDimensions;
    }

    public int getNumberOfPrimitiveDimensions() {
        return this.numberOfDictDimensions + this.numberOfNoDictionaryDimension;
    }

    public int getNumberOfComplexDimensions() {
        return this.complexDimensions.size();
    }

    public int getNumberOfMeasures() {
        return this.measures.size();
    }

    public int[] createDimColumnValueLength() {
        int[] length = new int[this.dimensions.size()];
        int index = 0;
        for (CarbonDimension dimension : this.dimensions) {
            DataType dataType = dimension.getDataType();
            length[index] = dataType == DataTypes.DATE ? 4 : -1;
            ++index;
        }
        return length;
    }

    public int[] createColumnValueLength() {
        int[] length = new int[this.numberOfColumnsAfterFlatten];
        int index = 0;
        for (CarbonDimension dimension : this.dimensions) {
            DataType dataType = dimension.getDataType();
            length[index] = dataType == DataTypes.DATE ? 4 : -1;
            ++index;
        }
        for (CarbonDimension complexDimension : this.complexDimensions) {
            int depth = this.getNumColumnsAfterFlatten(complexDimension);
            for (int i = 0; i < depth; ++i) {
                length[index++] = -1;
            }
        }
        for (CarbonMeasure measure : this.measures) {
            DataType dataType = measure.getDataType();
            if (DataTypes.isDecimal(dataType)) {
                length[index++] = -1;
                continue;
            }
            length[index++] = 8;
        }
        return length;
    }

    private int getNumColumnsAfterFlatten(CarbonDimension dimension) {
        int count = 1;
        if (dimension.isComplex().booleanValue()) {
            List<CarbonDimension> children = dimension.getListOfChildDimensions();
            for (CarbonDimension child : children) {
                count += this.getNumColumnsAfterFlatten(child);
            }
        }
        return count;
    }
}

