/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.indexstore.schema.CarbonRowSchema;
import org.apache.carbondata.core.indexstore.schema.SchemaGenerator;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.log4j.Logger;

public class SegmentPropertiesAndSchemaHolder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SegmentPropertiesAndSchemaHolder.class.getName());
    private static final SegmentPropertiesAndSchemaHolder INSTANCE = new SegmentPropertiesAndSchemaHolder();
    private static final Object lock = new Object();
    private static final AtomicInteger segmentPropertiesIndexCounter = new AtomicInteger(0);
    private Map<SegmentPropertiesWrapper, SegmentIdAndSegmentPropertiesIndexWrapper> segmentPropWrapperToSegmentSetMap = new ConcurrentHashMap<SegmentPropertiesWrapper, SegmentIdAndSegmentPropertiesIndexWrapper>();
    private static Map<Integer, SegmentPropertiesWrapper> indexToSegmentPropertiesWrapperMapping = new ConcurrentHashMap<Integer, SegmentPropertiesWrapper>();
    private Map<String, Object> absoluteTableIdentifierByteMap = new ConcurrentHashMap<String, Object>();

    private SegmentPropertiesAndSchemaHolder() {
    }

    public static SegmentPropertiesAndSchemaHolder getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentPropertiesWrapper addSegmentProperties(CarbonTable carbonTable, List<ColumnSchema> columnsInTable, String segmentId) {
        SegmentPropertiesWrapper segmentPropertiesWrapper = new SegmentPropertiesWrapper(carbonTable, columnsInTable);
        SegmentIdAndSegmentPropertiesIndexWrapper segmentIdSetAndIndexWrapper = this.segmentPropWrapperToSegmentSetMap.get(segmentPropertiesWrapper);
        if (null == segmentIdSetAndIndexWrapper) {
            Object object = this.getOrCreateTableLock(carbonTable.getAbsoluteTableIdentifier());
            synchronized (object) {
                segmentIdSetAndIndexWrapper = this.segmentPropWrapperToSegmentSetMap.get(segmentPropertiesWrapper);
                if (null == segmentIdSetAndIndexWrapper) {
                    segmentPropertiesWrapper.initSegmentProperties();
                    segmentPropertiesWrapper.addMinMaxColumns(carbonTable);
                    int segmentPropertiesIndex = segmentPropertiesIndexCounter.incrementAndGet();
                    indexToSegmentPropertiesWrapperMapping.put(segmentPropertiesIndex, segmentPropertiesWrapper);
                    LOGGER.info((Object)("Constructing new SegmentProperties for table: " + carbonTable.getCarbonTableIdentifier().getTableUniqueName() + ". Current size of segment properties holder list is: " + indexToSegmentPropertiesWrapperMapping.size()));
                    segmentIdSetAndIndexWrapper = new SegmentIdAndSegmentPropertiesIndexWrapper(segmentId, segmentPropertiesIndex);
                    this.segmentPropWrapperToSegmentSetMap.put(segmentPropertiesWrapper, segmentIdSetAndIndexWrapper);
                }
            }
        }
        Object object = this.getOrCreateTableLock(carbonTable.getAbsoluteTableIdentifier());
        synchronized (object) {
            segmentIdSetAndIndexWrapper.addSegmentId(segmentId);
            indexToSegmentPropertiesWrapperMapping.get(segmentIdSetAndIndexWrapper.getSegmentPropertiesIndex()).addMinMaxColumns(carbonTable);
        }
        return this.getSegmentPropertiesWrapper(segmentIdSetAndIndexWrapper.getSegmentPropertiesIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOrCreateTableLock(AbsoluteTableIdentifier absoluteTableIdentifier) {
        Object tableLock = this.absoluteTableIdentifierByteMap.get(absoluteTableIdentifier.getCarbonTableIdentifier().getTableUniqueName());
        if (null == tableLock) {
            Object object = lock;
            synchronized (object) {
                tableLock = this.absoluteTableIdentifierByteMap.get(absoluteTableIdentifier.getCarbonTableIdentifier().getTableUniqueName());
                if (null == tableLock) {
                    tableLock = new Object();
                    this.absoluteTableIdentifierByteMap.put(absoluteTableIdentifier.getCarbonTableIdentifier().getTableUniqueName(), tableLock);
                }
            }
        }
        return tableLock;
    }

    public SegmentProperties getSegmentProperties(int segmentPropertiesIndex) {
        SegmentPropertiesWrapper segmentPropertiesWrapper = this.getSegmentPropertiesWrapper(segmentPropertiesIndex);
        if (null != segmentPropertiesWrapper) {
            return segmentPropertiesWrapper.getSegmentProperties();
        }
        return null;
    }

    public SegmentPropertiesWrapper getSegmentPropertiesWrapper(int segmentPropertiesWrapperIndex) {
        return indexToSegmentPropertiesWrapperMapping.get(segmentPropertiesWrapperIndex);
    }

    public void invalidate(AbsoluteTableIdentifier absoluteTableIdentifier) {
        ArrayList<SegmentPropertiesWrapper> segmentPropertiesWrappersToBeRemoved = new ArrayList<SegmentPropertiesWrapper>();
        for (Map.Entry<SegmentPropertiesWrapper, SegmentIdAndSegmentPropertiesIndexWrapper> entry : this.segmentPropWrapperToSegmentSetMap.entrySet()) {
            SegmentPropertiesWrapper segmentPropertiesWrapper = entry.getKey();
            if (!segmentPropertiesWrapper.getTableIdentifier().getCarbonTableIdentifier().getTableUniqueName().equals(absoluteTableIdentifier.getCarbonTableIdentifier().getTableUniqueName())) continue;
            SegmentIdAndSegmentPropertiesIndexWrapper value = entry.getValue();
            indexToSegmentPropertiesWrapperMapping.remove(value.getSegmentPropertiesIndex());
            segmentPropertiesWrappersToBeRemoved.add(segmentPropertiesWrapper);
        }
        for (SegmentPropertiesWrapper segmentPropertiesWrapper : segmentPropertiesWrappersToBeRemoved) {
            this.segmentPropWrapperToSegmentSetMap.remove(segmentPropertiesWrapper);
        }
        this.absoluteTableIdentifierByteMap.remove(absoluteTableIdentifier.getCarbonTableIdentifier().getTableUniqueName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String segmentId, SegmentPropertiesWrapper segmentPropertiesWrapper, boolean clearSegmentWrapperFromMap) {
        SegmentIdAndSegmentPropertiesIndexWrapper segmentIdAndSegmentPropertiesIndexWrapper = this.segmentPropWrapperToSegmentSetMap.get(segmentPropertiesWrapper);
        if (segmentIdAndSegmentPropertiesIndexWrapper != null) {
            Object object = this.getOrCreateTableLock(segmentPropertiesWrapper.getTableIdentifier());
            synchronized (object) {
                segmentIdAndSegmentPropertiesIndexWrapper.removeSegmentId(segmentId);
                if (clearSegmentWrapperFromMap && segmentIdAndSegmentPropertiesIndexWrapper.segmentIdSet.isEmpty()) {
                    indexToSegmentPropertiesWrapperMapping.remove(segmentIdAndSegmentPropertiesIndexWrapper.getSegmentPropertiesIndex());
                    this.segmentPropWrapperToSegmentSetMap.remove(segmentPropertiesWrapper);
                } else if (!clearSegmentWrapperFromMap && segmentIdAndSegmentPropertiesIndexWrapper.segmentIdSet.isEmpty()) {
                    segmentPropertiesWrapper.clear();
                    LOGGER.info((Object)("cleared min max for segmentProperties at index: " + segmentIdAndSegmentPropertiesIndexWrapper.getSegmentPropertiesIndex()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSegmentId(int segmentPropertiesIndex, String segmentId) {
        SegmentPropertiesWrapper segmentPropertiesWrapper = indexToSegmentPropertiesWrapperMapping.get(segmentPropertiesIndex);
        if (null != segmentPropertiesWrapper) {
            SegmentIdAndSegmentPropertiesIndexWrapper segmentIdAndSegmentPropertiesIndexWrapper = this.segmentPropWrapperToSegmentSetMap.get(segmentPropertiesWrapper);
            Object object = this.getOrCreateTableLock(segmentPropertiesWrapper.getTableIdentifier());
            synchronized (object) {
                segmentIdAndSegmentPropertiesIndexWrapper.addSegmentId(segmentId);
            }
        }
    }

    public static class SegmentIdAndSegmentPropertiesIndexWrapper {
        private Set<String> segmentIdSet = new HashSet<String>(16);
        private int segmentPropertiesIndex;

        public SegmentIdAndSegmentPropertiesIndexWrapper(String segmentId, int segmentPropertiesIndex) {
            this.addSegmentId(segmentId);
            this.segmentPropertiesIndex = segmentPropertiesIndex;
        }

        public void addSegmentId(String segmentId) {
            this.segmentIdSet.add(segmentId);
        }

        public void removeSegmentId(String segmentId) {
            this.segmentIdSet.remove(segmentId);
        }

        public int getSegmentPropertiesIndex() {
            return this.segmentPropertiesIndex;
        }
    }

    public static class SegmentPropertiesWrapper {
        private static final Object taskSchemaLock = new Object();
        private static final Object fileFooterSchemaLock = new Object();
        private static final Object minMaxLock = new Object();
        private List<ColumnSchema> columnsInTable;
        private SegmentProperties segmentProperties;
        private List<CarbonColumn> minMaxCacheColumns;
        private CarbonTable carbonTable;
        private CarbonRowSchema[] taskSummarySchemaForBlock;
        private CarbonRowSchema[] taskSummarySchemaForBlocklet;
        private CarbonRowSchema[] taskSummarySchemaForBlockWithOutFilePath;
        private CarbonRowSchema[] taskSummarySchemaForBlockletWithOutFilePath;
        private CarbonRowSchema[] fileFooterEntrySchemaForBlock;
        private CarbonRowSchema[] fileFooterEntrySchemaForBlocklet;

        public SegmentPropertiesWrapper(CarbonTable carbonTable, List<ColumnSchema> columnsInTable) {
            this.carbonTable = carbonTable;
            this.columnsInTable = columnsInTable;
        }

        public CarbonTable getCarbonTable() {
            return this.carbonTable;
        }

        public void initSegmentProperties() {
            this.segmentProperties = new SegmentProperties(this.columnsInTable);
        }

        public void addMinMaxColumns(CarbonTable carbonTable) {
            if (null == this.minMaxCacheColumns || this.minMaxCacheColumns.isEmpty()) {
                this.minMaxCacheColumns = carbonTable.getMinMaxCacheColumns(this.segmentProperties);
            }
        }

        public void clear() {
            if (null != this.minMaxCacheColumns) {
                this.minMaxCacheColumns = null;
            }
            this.taskSummarySchemaForBlock = null;
            this.taskSummarySchemaForBlocklet = null;
            this.taskSummarySchemaForBlockWithOutFilePath = null;
            this.taskSummarySchemaForBlockletWithOutFilePath = null;
            this.fileFooterEntrySchemaForBlock = null;
            this.fileFooterEntrySchemaForBlocklet = null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SegmentPropertiesWrapper)) {
                return false;
            }
            SegmentPropertiesWrapper other = (SegmentPropertiesWrapper)obj;
            return this.carbonTable.getAbsoluteTableIdentifier().equals(other.carbonTable.getAbsoluteTableIdentifier()) && this.checkColumnSchemaEquality(this.columnsInTable, other.columnsInTable);
        }

        private boolean checkColumnSchemaEquality(List<ColumnSchema> obj1, List<ColumnSchema> obj2) {
            if (obj1 == null || obj2 == null || obj1.size() != obj2.size()) {
                return false;
            }
            boolean exists = true;
            for (int i = 0; i < obj1.size(); ++i) {
                if (obj1.get(i).equalsWithStrictCheck(obj2.get(i))) continue;
                exists = false;
                break;
            }
            return exists;
        }

        private void sortList(List<ColumnSchema> columnSchemas) {
            Collections.sort(columnSchemas, new Comparator<ColumnSchema>(){

                @Override
                public int compare(ColumnSchema o1, ColumnSchema o2) {
                    return o1.getColumnUniqueId().compareTo(o2.getColumnUniqueId());
                }
            });
        }

        public int hashCode() {
            int allColumnsHashCode = 0;
            StringBuilder builder = new StringBuilder();
            for (ColumnSchema columnSchema : this.columnsInTable) {
                allColumnsHashCode += columnSchema.strictHashCode();
                builder.append(columnSchema.getColumnUniqueId()).append(",");
            }
            return this.carbonTable.getAbsoluteTableIdentifier().hashCode() + allColumnsHashCode + builder.toString().hashCode();
        }

        public AbsoluteTableIdentifier getTableIdentifier() {
            return this.carbonTable.getAbsoluteTableIdentifier();
        }

        public SegmentProperties getSegmentProperties() {
            return this.segmentProperties;
        }

        public List<ColumnSchema> getColumnsInTable() {
            return this.columnsInTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CarbonRowSchema[] getTaskSummarySchemaForBlock(boolean storeBlockletCount, boolean filePathToBeStored) {
            if (null == this.taskSummarySchemaForBlock && filePathToBeStored) {
                Object object = taskSchemaLock;
                synchronized (object) {
                    if (null == this.taskSummarySchemaForBlock) {
                        this.taskSummarySchemaForBlock = SchemaGenerator.createTaskSummarySchema(this.segmentProperties, this.getMinMaxCacheColumns(), storeBlockletCount, filePathToBeStored);
                    }
                }
            }
            if (null == this.taskSummarySchemaForBlockWithOutFilePath && !filePathToBeStored) {
                Object object = taskSchemaLock;
                synchronized (object) {
                    if (null == this.taskSummarySchemaForBlockWithOutFilePath) {
                        this.taskSummarySchemaForBlockWithOutFilePath = SchemaGenerator.createTaskSummarySchema(this.segmentProperties, this.getMinMaxCacheColumns(), storeBlockletCount, filePathToBeStored);
                    }
                }
            }
            if (filePathToBeStored) {
                return this.taskSummarySchemaForBlock;
            }
            return this.taskSummarySchemaForBlockWithOutFilePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CarbonRowSchema[] getTaskSummarySchemaForBlocklet(boolean storeBlockletCount, boolean filePathToBeStored) {
            if (null == this.taskSummarySchemaForBlocklet && filePathToBeStored) {
                Object object = taskSchemaLock;
                synchronized (object) {
                    if (null == this.taskSummarySchemaForBlocklet) {
                        this.taskSummarySchemaForBlocklet = SchemaGenerator.createTaskSummarySchema(this.segmentProperties, this.getMinMaxCacheColumns(), storeBlockletCount, filePathToBeStored);
                    }
                }
            }
            if (null == this.taskSummarySchemaForBlockletWithOutFilePath && !filePathToBeStored) {
                Object object = taskSchemaLock;
                synchronized (object) {
                    if (null == this.taskSummarySchemaForBlockletWithOutFilePath) {
                        this.taskSummarySchemaForBlockletWithOutFilePath = SchemaGenerator.createTaskSummarySchema(this.segmentProperties, this.getMinMaxCacheColumns(), storeBlockletCount, filePathToBeStored);
                    }
                }
            }
            if (filePathToBeStored) {
                return this.taskSummarySchemaForBlocklet;
            }
            return this.taskSummarySchemaForBlockletWithOutFilePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CarbonRowSchema[] getBlockFileFooterEntrySchema() {
            if (null == this.fileFooterEntrySchemaForBlock) {
                Object object = fileFooterSchemaLock;
                synchronized (object) {
                    if (null == this.fileFooterEntrySchemaForBlock) {
                        this.fileFooterEntrySchemaForBlock = SchemaGenerator.createBlockSchema(this.segmentProperties, this.getMinMaxCacheColumns());
                    }
                }
            }
            return this.fileFooterEntrySchemaForBlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CarbonRowSchema[] getBlockletFileFooterEntrySchema() {
            if (null == this.fileFooterEntrySchemaForBlocklet) {
                Object object = fileFooterSchemaLock;
                synchronized (object) {
                    if (null == this.fileFooterEntrySchemaForBlocklet) {
                        this.fileFooterEntrySchemaForBlocklet = SchemaGenerator.createBlockletSchema(this.segmentProperties, this.getMinMaxCacheColumns());
                    }
                }
            }
            return this.fileFooterEntrySchemaForBlocklet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CarbonColumn> getMinMaxCacheColumns() {
            if (null == this.minMaxCacheColumns) {
                Object object = minMaxLock;
                synchronized (object) {
                    if (null == this.minMaxCacheColumns) {
                        this.addMinMaxColumns(this.carbonTable);
                    }
                }
            }
            return this.minMaxCacheColumns;
        }
    }
}

