/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.block;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TableBlockInfo
implements Distributable,
Serializable {
    private static final long serialVersionUID = -6502868998599821172L;
    private String filePath;
    private long fileSize;
    private long blockOffset;
    private long blockLength;
    private Segment segment;
    private String[] locations;
    private ColumnarFormatVersion version;
    private String[] deletedDeltaFilePath;
    private BlockletDetailInfo detailInfo;
    private String indexWriterPath;
    private transient DataFileFooter dataFileFooter;
    public static final Comparator<Distributable> DATA_SIZE_DESC_COMPARATOR = new Comparator<Distributable>(){

        @Override
        public int compare(Distributable o1, Distributable o2) {
            long diff = ((TableBlockInfo)o1).getBlockLength() - ((TableBlockInfo)o2).getBlockLength();
            return diff < 0L ? 1 : (diff == 0L ? 0 : -1);
        }
    };

    public TableBlockInfo(String filePath, long blockOffset, String segmentId, String[] locations, long blockLength, ColumnarFormatVersion version, String[] deletedDeltaFilePath) {
        this.filePath = FileFactory.getUpdatedFilePath(filePath);
        this.blockOffset = blockOffset;
        this.segment = Segment.toSegment(segmentId);
        this.locations = locations;
        this.blockLength = blockLength;
        this.version = version;
        this.deletedDeltaFilePath = deletedDeltaFilePath;
    }

    public TableBlockInfo() {
    }

    public TableBlockInfo copy() {
        TableBlockInfo info = new TableBlockInfo();
        info.filePath = this.filePath;
        info.blockOffset = this.blockOffset;
        info.blockLength = this.blockLength;
        info.segment = this.segment;
        info.locations = this.locations;
        info.version = this.version;
        info.deletedDeltaFilePath = this.deletedDeltaFilePath;
        info.detailInfo = this.detailInfo.copy();
        info.indexWriterPath = this.indexWriterPath;
        return info;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getBlockOffset() {
        return this.blockOffset;
    }

    public void setBlockOffset(long blockOffset) {
        this.blockOffset = blockOffset;
    }

    public String getSegmentId() {
        if (this.segment == null) {
            return null;
        }
        return this.segment.getSegmentNo();
    }

    public Segment getSegment() {
        return this.segment;
    }

    public long getBlockLength() {
        if (this.blockLength == 0L) {
            Path path = new Path(this.filePath);
            try {
                FileSystem fs = path.getFileSystem(FileFactory.getConfiguration());
                this.blockLength = fs.listStatus(path)[0].getLen();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.blockLength;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableBlockInfo)) {
            return false;
        }
        TableBlockInfo other = (TableBlockInfo)obj;
        if (!this.segment.equals(other.segment)) {
            return false;
        }
        if (this.blockOffset != other.blockOffset) {
            return false;
        }
        if (this.blockLength != other.blockLength) {
            return false;
        }
        if (null == this.filePath || null == other.filePath) {
            return false;
        }
        return new Path(this.filePath).equals((Object)new Path(other.filePath));
    }

    @Override
    public int compareTo(Distributable other) {
        double seg2;
        int compareResult = 0;
        double seg1 = Double.parseDouble(this.segment.getSegmentNo());
        if (seg1 - (seg2 = Double.parseDouble(((TableBlockInfo)other).segment.getSegmentNo())) < 0.0) {
            return -1;
        }
        if (seg1 - seg2 > 0.0) {
            return 1;
        }
        if (CarbonTablePath.isCarbonDataFile(this.filePath)) {
            int compare = ByteUtil.compare(CarbonTablePath.DataFileUtil.getTaskNo(this.filePath).getBytes(Charset.forName("UTF-8")), CarbonTablePath.DataFileUtil.getTaskNo(((TableBlockInfo)other).filePath).getBytes(Charset.forName("UTF-8")));
            if (compare != 0) {
                return compare;
            }
            int firstPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo(this.filePath));
            int SecondPartNo = Integer.parseInt(CarbonTablePath.DataFileUtil.getPartNo(((TableBlockInfo)other).filePath));
            compareResult = firstPartNo - SecondPartNo;
        } else {
            compareResult = this.filePath.compareTo(((TableBlockInfo)other).getFilePath());
        }
        if (compareResult != 0) {
            return compareResult;
        }
        if (this.blockOffset + this.blockLength < ((TableBlockInfo)other).blockOffset + ((TableBlockInfo)other).blockLength) {
            return -1;
        }
        if (this.blockOffset + this.blockLength > ((TableBlockInfo)other).blockOffset + ((TableBlockInfo)other).blockLength) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = this.filePath.hashCode();
        result = 31 * result + (int)(this.blockOffset ^ this.blockOffset >>> 32);
        result = 31 * result + (int)(this.blockLength ^ this.blockLength >>> 32);
        result = 31 * result + this.segment.hashCode();
        result = 31 * result;
        return result;
    }

    @Override
    public String[] getLocations() {
        return this.locations;
    }

    public ColumnarFormatVersion getVersion() {
        return this.version;
    }

    public void setVersion(ColumnarFormatVersion version) {
        this.version = version;
    }

    public String[] getDeletedDeltaFilePath() {
        return this.deletedDeltaFilePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public BlockletDetailInfo getDetailInfo() {
        return this.detailInfo;
    }

    public void setDetailInfo(BlockletDetailInfo detailInfo) {
        this.detailInfo = detailInfo;
    }

    public String getIndexWriterPath() {
        return this.indexWriterPath;
    }

    public void setIndexWriterPath(String indexWriterPath) {
        this.indexWriterPath = indexWriterPath;
    }

    public DataFileFooter getDataFileFooter() {
        return this.dataFileFooter;
    }

    public void setDataFileFooter(DataFileFooter dataFileFooter) {
        this.dataFileFooter = dataFileFooter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TableBlockInfo{");
        sb.append("filePath='").append(this.filePath).append('\'');
        sb.append(", blockOffset=").append(this.blockOffset);
        sb.append(", blockLength=").append(this.blockLength);
        sb.append(", segment='").append(this.segment.toString()).append('\'');
        sb.append(", locations=").append(Arrays.toString(this.locations));
        sb.append('}');
        return sb.toString();
    }
}

