/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.blocklet;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.page.ActualDataBasedFallbackEncoder;
import org.apache.carbondata.core.datastore.page.DecoderBasedFallbackEncoder;
import org.apache.carbondata.core.datastore.page.FallbackEncodedColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.localdictionary.PageLevelDictionary;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.format.LocalDictionaryChunk;
import org.apache.log4j.Logger;

public class BlockletEncodedColumnPage {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BlockletEncodedColumnPage.class.getName());
    private List<EncodedColumnPage> encodedColumnPageList;
    private ExecutorService fallbackExecutorService;
    private boolean isLocalDictEncoded;
    private PageLevelDictionary pageLevelDictionary;
    private ArrayDeque<Future<FallbackEncodedColumnPage>> fallbackFutureQueue;
    private String columnName;
    private boolean isDecoderBasedFallBackEnabled;
    private LocalDictionaryGenerator localDictionaryGenerator;

    BlockletEncodedColumnPage(ExecutorService fallbackExecutorService, boolean isDecoderBasedFallBackEnabled, LocalDictionaryGenerator localDictionaryGenerator) {
        this.fallbackExecutorService = fallbackExecutorService;
        this.fallbackFutureQueue = new ArrayDeque();
        this.isDecoderBasedFallBackEnabled = isDecoderBasedFallBackEnabled;
        this.localDictionaryGenerator = localDictionaryGenerator;
    }

    void addEncodedColumnPage(EncodedColumnPage encodedColumnPage) {
        if (null == this.encodedColumnPageList) {
            this.encodedColumnPageList = new ArrayList<EncodedColumnPage>();
            if (encodedColumnPage.isLocalDictGeneratedPage()) {
                this.isLocalDictEncoded = true;
                this.pageLevelDictionary = encodedColumnPage.getPageDictionary();
            }
            this.encodedColumnPageList.add(encodedColumnPage);
            this.columnName = encodedColumnPage.getActualPage().getColumnSpec().getFieldName();
            return;
        }
        if (!this.isLocalDictEncoded && encodedColumnPage.isLocalDictGeneratedPage()) {
            LOGGER.info((Object)("Local dictionary Fallback is initiated for column: " + this.columnName + " for page:" + this.encodedColumnPageList.size()));
            this.initiateFallBack(encodedColumnPage, this.encodedColumnPageList.size());
            this.encodedColumnPageList.add(null);
        } else if (!this.isLocalDictEncoded || encodedColumnPage.isLocalDictGeneratedPage()) {
            if (null != this.pageLevelDictionary) {
                this.pageLevelDictionary.mergerDictionaryValues(encodedColumnPage.getPageDictionary());
            }
            this.encodedColumnPageList.add(encodedColumnPage);
        } else {
            this.isLocalDictEncoded = false;
            this.pageLevelDictionary = null;
            LOGGER.info((Object)("Local dictionary Fallback is initiated for column: " + this.columnName + " for pages: 1 to " + this.encodedColumnPageList.size()));
            for (int pageIndex = 0; pageIndex < this.encodedColumnPageList.size(); ++pageIndex) {
                if (!this.encodedColumnPageList.get(pageIndex).getActualPage().isLocalDictGeneratedPage()) continue;
                this.initiateFallBack(this.encodedColumnPageList.get(pageIndex), pageIndex);
            }
            this.encodedColumnPageList.add(encodedColumnPage);
        }
    }

    public List<EncodedColumnPage> getEncodedColumnPageList() {
        if (null != this.fallbackFutureQueue) {
            try {
                while (!this.fallbackFutureQueue.isEmpty()) {
                    FallbackEncodedColumnPage fallbackEncodedColumnPage = this.fallbackFutureQueue.poll().get();
                    this.encodedColumnPageList.set(fallbackEncodedColumnPage.getPageIndex(), fallbackEncodedColumnPage.getEncodedColumnPage());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Problem while encoding the blocklet data during fallback", e);
            }
            this.fallbackFutureQueue = null;
        }
        if (null != this.pageLevelDictionary) {
            for (EncodedColumnPage columnPage : this.encodedColumnPageList) {
                columnPage.freeMemory();
            }
        }
        return this.encodedColumnPageList;
    }

    public LocalDictionaryChunk getEncodedDictionary() {
        if (null != this.pageLevelDictionary) {
            try {
                return this.pageLevelDictionary.getLocalDictionaryChunkForBlocklet();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void initiateFallBack(EncodedColumnPage encodedColumnPage, int pageIndex) {
        if (this.isDecoderBasedFallBackEnabled) {
            this.fallbackFutureQueue.add(this.fallbackExecutorService.submit(new DecoderBasedFallbackEncoder(encodedColumnPage, pageIndex, this.localDictionaryGenerator)));
        } else {
            this.fallbackFutureQueue.add(this.fallbackExecutorService.submit(new ActualDataBasedFallbackEncoder(encodedColumnPage, pageIndex)));
        }
    }

    public void cleanBuffer() {
        for (EncodedColumnPage encodedColumnPage : this.encodedColumnPageList) {
            encodedColumnPage.cleanBuffer();
        }
    }
}

