/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.blocklet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.carbondata.core.datastore.blocklet.BlockletEncodedColumnPage;
import org.apache.carbondata.core.datastore.page.EncodedTablePage;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;

public class EncodedBlocklet {
    private int blockletSize;
    private List<BlockletEncodedColumnPage> encodedDimensionColumnPages;
    private List<BlockletEncodedColumnPage> encodedMeasureColumnPages;
    private ExecutorService executorService;
    private int numberOfPages;
    private List<Short> rowCountInPage;
    private boolean isDecoderBasedFallBackEnabled;
    private Map<String, LocalDictionaryGenerator> localDictionaryGeneratorMap;

    public EncodedBlocklet(ExecutorService executorService, boolean isDecoderBasedFallBackEnabled, Map<String, LocalDictionaryGenerator> localDictionaryGeneratorMap) {
        this.executorService = executorService;
        this.isDecoderBasedFallBackEnabled = isDecoderBasedFallBackEnabled;
        this.localDictionaryGeneratorMap = localDictionaryGeneratorMap;
        this.rowCountInPage = new ArrayList<Short>();
    }

    private void addPageMetadata(EncodedTablePage encodedTablePage) {
        if (null == this.rowCountInPage) {
            this.rowCountInPage = new ArrayList<Short>();
        }
        this.blockletSize += encodedTablePage.getPageSize();
        ++this.numberOfPages;
        this.rowCountInPage.add((short)encodedTablePage.getPageSize());
    }

    private void addEncodedMeasurePage(EncodedTablePage encodedTablePage) {
        if (null == this.encodedMeasureColumnPages) {
            this.encodedMeasureColumnPages = new ArrayList<BlockletEncodedColumnPage>();
            for (int i = 0; i < encodedTablePage.getNumMeasures(); ++i) {
                BlockletEncodedColumnPage blockletEncodedColumnPage = new BlockletEncodedColumnPage(null, false, null);
                blockletEncodedColumnPage.addEncodedColumnPage(encodedTablePage.getMeasure(i));
                this.encodedMeasureColumnPages.add(blockletEncodedColumnPage);
            }
        } else {
            for (int i = 0; i < encodedTablePage.getNumMeasures(); ++i) {
                this.encodedMeasureColumnPages.get(i).addEncodedColumnPage(encodedTablePage.getMeasure(i));
            }
        }
    }

    private void addEncodedDimensionPage(EncodedTablePage encodedTablePage) {
        if (null == this.encodedDimensionColumnPages) {
            this.encodedDimensionColumnPages = new ArrayList<BlockletEncodedColumnPage>();
            for (int i = 0; i < encodedTablePage.getNumDimensions(); ++i) {
                BlockletEncodedColumnPage blockletEncodedColumnPage = new BlockletEncodedColumnPage(this.executorService, this.isDecoderBasedFallBackEnabled, this.localDictionaryGeneratorMap.get(encodedTablePage.getDimension(i).getActualPage().getColumnSpec().getFieldName()));
                blockletEncodedColumnPage.addEncodedColumnPage(encodedTablePage.getDimension(i));
                this.encodedDimensionColumnPages.add(blockletEncodedColumnPage);
            }
        } else {
            for (int i = 0; i < encodedTablePage.getNumDimensions(); ++i) {
                this.encodedDimensionColumnPages.get(i).addEncodedColumnPage(encodedTablePage.getDimension(i));
            }
        }
    }

    public void addEncodedTablePage(EncodedTablePage encodedTablePage) {
        this.addPageMetadata(encodedTablePage);
        this.addEncodedDimensionPage(encodedTablePage);
        this.addEncodedMeasurePage(encodedTablePage);
    }

    public int getBlockletSize() {
        return this.blockletSize;
    }

    public List<BlockletEncodedColumnPage> getEncodedDimensionColumnPages() {
        return this.encodedDimensionColumnPages;
    }

    public List<BlockletEncodedColumnPage> getEncodedMeasureColumnPages() {
        return this.encodedMeasureColumnPages;
    }

    public int getNumberOfDimension() {
        return this.encodedDimensionColumnPages.size();
    }

    public int getNumberOfMeasure() {
        return this.encodedMeasureColumnPages.size();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public List<Short> getRowCountInPage() {
        return this.rowCountInPage;
    }

    public void setRowCountInPage(List<Short> rowCountInPage) {
        this.rowCountInPage = rowCountInPage;
    }

    public void clear() {
        if (null != this.encodedDimensionColumnPages) {
            for (BlockletEncodedColumnPage blockletEncodedColumnPage : this.encodedDimensionColumnPages) {
                blockletEncodedColumnPage.cleanBuffer();
            }
        }
        if (null != this.encodedMeasureColumnPages) {
            for (BlockletEncodedColumnPage blockletEncodedColumnPage : this.encodedMeasureColumnPages) {
                blockletEncodedColumnPage.cleanBuffer();
            }
        }
        this.numberOfPages = 0;
        this.encodedDimensionColumnPages = null;
        this.blockletSize = 0;
        this.encodedMeasureColumnPages = null;
        this.rowCountInPage = null;
    }
}

